/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control.util;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;

public class ExecutorAssist {
    private static Executor executor = new DefaultExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execute(File workingDir, CommandLine commandLine, Map environment) throws IOException {
        int rValue = 0;
        try {
            Executor executor = ExecutorAssist.executor;
            synchronized (executor) {
                ExecutorAssist.executor.setWorkingDirectory(workingDir);
                rValue = ExecutorAssist.executor.execute(commandLine, environment);
            }
        }
        catch (ExecuteException e) {
            rValue = Math.max(e.getExitValue(), rValue);
        }
        return rValue;
    }

    public static Future<Integer> executeAsync(final File workingDir, final CommandLine commandLine, final Map environment) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        return executorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ExecutorAssist.execute(workingDir, commandLine, environment);
            }
        });
    }

    public static int execute(File workingDir, CommandLine commandLine) throws IOException {
        return ExecutorAssist.execute(workingDir, commandLine, null);
    }

    static {
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
    }
}

