/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control.command;

import java.io.File;
import org.apache.commons.cli.Options;
import org.apache.commons.exec.CommandLine;
import org.rhq.server.control.RHQControlException;
import org.rhq.server.control.command.AbstractInstall;
import org.rhq.server.control.util.ExecutorAssist;

public class Stop
extends AbstractInstall {
    private Options options = new Options().addOption(null, "storage", false, "Stop RHQ storage node").addOption(null, "server", false, "Stop RHQ server").addOption(null, "agent", false, "Stop RHQ agent");

    @Override
    public String getName() {
        return "stop";
    }

    @Override
    public String getDescription() {
        return "Stops RHQ services";
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    protected String getReadmeFilename() {
        return "STOP_README.txt";
    }

    @Override
    protected int exec(org.apache.commons.cli.CommandLine commandLine) {
        int rValue = 0;
        try {
            if (commandLine.getOptions().length == 0) {
                if (this.isAgentInstalled()) {
                    rValue = Math.max(rValue, this.stopAgent());
                }
                rValue = Math.max(rValue, this.stopRHQServer());
                if (this.isStorageInstalled()) {
                    rValue = Math.max(rValue, this.stopStorage());
                }
            } else {
                if (commandLine.hasOption("agent")) {
                    if (this.isAgentInstalled()) {
                        rValue = Math.max(rValue, this.stopAgent());
                    } else {
                        this.log.warn((Object)"It appears that the agent is not installed. The --agent option will be ignored.");
                        rValue = 2;
                    }
                }
                if (commandLine.hasOption("server")) {
                    rValue = Math.max(rValue, this.stopRHQServer());
                }
                if (commandLine.hasOption("storage")) {
                    if (this.isStorageInstalled()) {
                        rValue = Math.max(rValue, this.stopStorage());
                    } else {
                        this.log.warn((Object)"It appears that the storage node is not installed. The --storage option will be ignored.");
                        rValue = 2;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RHQControlException("Failed to stop services", e);
        }
        return rValue;
    }

    private int stopStorage() throws Exception {
        int rValue;
        this.log.debug((Object)"Stopping RHQ storage node");
        if (this.isWindows()) {
            CommandLine commandLine = this.getCommandLine("rhq-storage", "stop");
            rValue = ExecutorAssist.execute(this.getBinDir(), commandLine);
            if (rValue != 0) {
                this.log.debug((Object)("Failed to stop storage service, return code " + rValue));
            } else {
                System.out.println("RHQ storage node has stopped");
            }
        } else {
            if (this.isStorageRunning()) {
                String pid = this.getStoragePid();
                System.out.println("Stopping RHQ storage node...");
                System.out.println("RHQ storage node (pid=" + pid + ") is stopping...");
                this.killPid(pid);
                this.waitForProcessToStop(pid);
                System.out.println("RHQ storage node has stopped");
            }
            rValue = 0;
        }
        return rValue;
    }

    private int stopRHQServer() throws Exception {
        this.log.debug((Object)"Stopping RHQ server");
        CommandLine commandLine = this.getCommandLine("rhq-server", "stop");
        int rValue = ExecutorAssist.execute(this.getBinDir(), commandLine);
        if (rValue != 0) {
            this.log.debug((Object)"Failed to stop server service");
        }
        return rValue;
    }

    private int stopAgent() throws Exception {
        this.log.debug((Object)"Stopping RHQ agent");
        File agentBinDir = new File(this.getAgentBasedir(), "bin");
        CommandLine commandLine = this.getCommandLine("rhq-agent-wrapper", "stop");
        int rValue = ExecutorAssist.execute(agentBinDir, commandLine);
        if (rValue != 0) {
            this.log.debug((Object)("Failed to stop agent service, return value" + rValue));
        }
        return rValue;
    }
}

