/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control.command;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.rhq.core.util.file.FileReverter;
import org.rhq.core.util.file.FileUtil;
import org.rhq.server.control.ControlCommand;
import org.rhq.server.control.RHQControlException;
import org.rhq.server.control.command.AbstractInstall;
import org.rhq.server.control.command.Start;
import org.rhq.server.control.command.Stop;

public class Install
extends AbstractInstall {
    private static final String FROM_AGENT_DIR_OPTION = "from-agent-dir";
    private Options options = new Options().addOption(null, "from-agent-dir", true, "Full path to the install directory of the existing RHQ Agent. This is used when installing a new RHQ HA Server, or an RHQ Storage Node, to a machine with an existing RHQ Agent installed. The existing agent will be updated as needed and relocated into the default location: <server-dir>/../rhq-agent.").addOption(null, "storage", false, "Install RHQ storage node. The install directory will be [" + this.getStorageBasedir() + "]. Note that this option implies --agent which means an agent will also be installed, if one is not yet installed.").addOption(null, "server", false, "Install RHQ server. If you have not yet installed an RHQ storage node somewhere in your network, you must specify --storage to install one.").addOption(null, "agent", false, "Install RHQ agent. The install directory will be [" + this.getAgentBasedir() + "]").addOption(null, "agent-config", true, "An alternate XML file to use in place of the default agent-configuration.xml").addOption(null, "agent-preference", true, "An agent preference setting (whose argument is in the form 'name=value') to be set in the agent. More than one of these is allowed.").addOption(null, "start", false, "If specified then immediately start the services after installation.  Note that services may be started and shut down as part of the installation process, but will not be started or left running by default.").addOption(null, "storage-data-root-dir", true, "The root directory under which all storage data directories will be placed.");

    @Override
    public String getName() {
        return "install";
    }

    @Override
    public String getDescription() {
        return "Installs RHQ services.";
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    protected String getReadmeFilename() {
        return "INSTALL_README.txt";
    }

    /*
     * Loose catch block
     */
    @Override
    protected int exec(CommandLine commandLine) {
        int rValue;
        block46: {
            Stop stopCommand;
            boolean startedServer;
            boolean startedStorage;
            boolean start;
            block47: {
                block43: {
                    int i$;
                    block44: {
                        Stop stopCommand2;
                        block45: {
                            start = commandLine.hasOption("start");
                            startedStorage = false;
                            startedServer = false;
                            rValue = 0;
                            List<String> errors = this.validateOptions(commandLine);
                            if (errors.isEmpty()) break block43;
                            for (String error : errors) {
                                this.log.error((Object)error);
                            }
                            this.log.error((Object)"Exiting due to the previous errors");
                            i$ = 5;
                            if (start || !startedStorage && !startedServer) break block44;
                            stopCommand2 = new Stop();
                            if (!startedServer) break block45;
                            try {
                                rValue = Math.max(rValue, stopCommand2.exec(new String[]{"--server"}));
                            }
                            catch (Exception e) {
                                this.log.warn((Object)"Could not stop the server - it may still be running.");
                            }
                        }
                        if (startedStorage) {
                            try {
                                rValue = Math.max(rValue, stopCommand2.exec(new String[]{"--storage"}));
                            }
                            catch (Exception e) {
                                this.log.warn((Object)"Could not stop the storage node - it may still be running.");
                            }
                        }
                    }
                    return i$;
                }
                final FileReverter serverPropFileReverter = new FileReverter(this.getServerPropertiesFile());
                this.addUndoTask(new ControlCommand.UndoTask("Reverting server properties file"){

                    @Override
                    public void performUndoWork() throws Exception {
                        try {
                            serverPropFileReverter.revert();
                        }
                        catch (Exception e) {
                            throw new Exception("Cannot reset rhq-server.properties - revert settings manually", e);
                        }
                    }
                });
                boolean hasFromAgentOption = commandLine.hasOption(FROM_AGENT_DIR_OPTION);
                File fromAgentDir = null;
                if (hasFromAgentOption) {
                    this.log.info((Object)"Stopping the existing agent, if running...");
                    fromAgentDir = Install.getFromAgentDir(commandLine);
                    rValue = Math.max(rValue, this.killAgent(fromAgentDir));
                }
                boolean installAll = !commandLine.hasOption("storage") && !commandLine.hasOption("server") && !commandLine.hasOption("agent");
                boolean installStorage = installAll || commandLine.hasOption("storage");
                boolean installServer = installAll || commandLine.hasOption("server");
                boolean installAgent = installAll || commandLine.hasOption("agent") || commandLine.hasOption("storage");
                boolean startStorage = false;
                if (installStorage) {
                    if (this.isStorageInstalled()) {
                        this.log.info((Object)("The RHQ storage node is already installed in [" + new File(this.getBaseDir(), "rhq-storage") + "]. It will not be installed."));
                        if (this.isWindows()) {
                            this.log.info((Object)"Ensuring the RHQ Storage Windows service exists. Ignore any CreateService failure.");
                            rValue = Math.max(rValue, this.installWindowsService(this.getBinDir(), "rhq-storage", false, false));
                        }
                    } else {
                        rValue = Math.max(rValue, this.installStorageNode(this.getStorageBasedir(), commandLine, false));
                        startStorage = start;
                    }
                }
                if ((startStorage || installServer) && rValue == 0) {
                    startedStorage = true;
                    Start startCommand = new Start();
                    rValue = Math.max(rValue, startCommand.exec(new String[]{"--storage"}));
                    if (installServer) {
                        this.log.info((Object)"Pausing to ensure RHQ Storage is initialized prior to RHQ Server installation.");
                        Thread.sleep(12500L);
                    }
                }
                if (installServer && rValue == 0) {
                    if (this.isServerInstalled()) {
                        this.log.info((Object)"The RHQ server is already installed. It will not be installed.");
                        if (this.isWindows()) {
                            this.log.info((Object)"Ensuring the RHQ Server Windows service exists. Ignore any CreateService failure.");
                            rValue = Math.max(rValue, this.installWindowsService(this.getBinDir(), "rhq-server", false, false));
                        }
                    } else {
                        startedServer = true;
                        rValue = Math.max(rValue, this.startRHQServerForInstallation());
                        Future<Integer> integerFuture = this.runRHQServerInstaller(AbstractInstall.ServerInstallerAction.INSTALL);
                        this.waitForRHQServerToInitialize(integerFuture);
                        rValue = Math.max(rValue, integerFuture.get());
                    }
                }
                if (installAgent && rValue == 0) {
                    if (this.isAgentInstalled()) {
                        this.log.info((Object)("The RHQ agent is already installed in [" + this.getAgentBasedir() + "]. It will not be installed."));
                        if (this.isWindows()) {
                            try {
                                this.log.info((Object)"Ensuring the RHQ Agent Windows service exists. Ignore any CreateService failure.");
                                rValue = Math.max(rValue, this.installWindowsService(new File(this.getAgentBasedir(), "bin"), "rhq-agent-wrapper", false, false));
                            }
                            catch (Exception e) {
                                this.log.debug((Object)"Failed to stop agent service", (Throwable)e);
                            }
                        }
                    } else {
                        final File agentBasedir = this.getAgentBasedir();
                        if (!hasFromAgentOption) {
                            this.installAgent(agentBasedir, commandLine);
                        } else {
                            File agentInstallerJar = this.getFileDownload("rhq-agent", "rhq-enterprise-agent");
                            rValue = Math.max(rValue, this.updateAndMoveExistingAgent(agentBasedir, fromAgentDir, agentInstallerJar));
                            this.addUndoTask(new ControlCommand.UndoTask("Removing agent install directory"){

                                @Override
                                public void performUndoWork() {
                                    FileUtil.purge((File)agentBasedir, (boolean)true);
                                }
                            });
                            this.log.info((Object)("The agent has been upgraded and placed in: " + agentBasedir));
                        }
                        rValue = Math.max(rValue, this.updateWindowsAgentService(agentBasedir));
                        if (start) {
                            rValue = Math.max(rValue, this.startAgent(agentBasedir));
                        }
                    }
                }
                if (start || !startedStorage && !startedServer) break block46;
                stopCommand = new Stop();
                if (!startedServer) break block47;
                try {
                    rValue = Math.max(rValue, stopCommand.exec(new String[]{"--server"}));
                }
                catch (Exception e) {
                    this.log.warn((Object)"Could not stop the server - it may still be running.");
                }
            }
            if (startedStorage) {
                try {
                    rValue = Math.max(rValue, stopCommand.exec(new String[]{"--storage"}));
                }
                catch (Exception e) {
                    this.log.warn((Object)"Could not stop the storage node - it may still be running.");
                }
            }
            break block46;
            catch (Exception e) {
                try {
                    throw new RHQControlException("An error occurred while executing the install command", e);
                }
                catch (Throwable throwable) {
                    if (!start && (startedStorage || startedServer)) {
                        Stop stopCommand3 = new Stop();
                        if (startedServer) {
                            try {
                                rValue = Math.max(rValue, stopCommand3.exec(new String[]{"--server"}));
                            }
                            catch (Exception e2) {
                                this.log.warn((Object)"Could not stop the server - it may still be running.");
                            }
                        }
                        if (startedStorage) {
                            try {
                                rValue = Math.max(rValue, stopCommand3.exec(new String[]{"--storage"}));
                            }
                            catch (Exception e3) {
                                this.log.warn((Object)"Could not stop the storage node - it may still be running.");
                            }
                        }
                    }
                    throw throwable;
                }
            }
        }
        return rValue;
    }

    private List<String> validateOptions(CommandLine commandLine) {
        File agentConfig;
        LinkedList<String> errors = new LinkedList<String>();
        if (!(commandLine.hasOption("storage") || commandLine.hasOption("server") || commandLine.hasOption("agent"))) {
            this.validateCustomStorageDataDirectories(commandLine, errors);
            if (commandLine.hasOption("agent-config") && !this.isAgentInstalled()) {
                agentConfig = new File(commandLine.getOptionValue("agent-config"));
                this.validateAgentConfigOption(agentConfig, errors);
            }
        } else {
            if (commandLine.hasOption("storage")) {
                if (!this.isAgentInstalled() && commandLine.hasOption("agent-config")) {
                    agentConfig = new File(commandLine.getOptionValue("agent-config"));
                    this.validateAgentConfigOption(agentConfig, errors);
                }
                this.validateCustomStorageDataDirectories(commandLine, errors);
            }
            if (commandLine.hasOption("agent") && !this.isAgentInstalled() && commandLine.hasOption("agent-config")) {
                agentConfig = new File(commandLine.getOptionValue("agent-config"));
                this.validateAgentConfigOption(agentConfig, errors);
            }
        }
        if (commandLine.hasOption(FROM_AGENT_DIR_OPTION)) {
            if (this.isAgentInstalled()) {
                errors.add("An Agent is already installed. The from-agent-dir option is not allowed.");
            } else {
                File fromAgentDir = new File(commandLine.getOptionValue(FROM_AGENT_DIR_OPTION));
                if (!fromAgentDir.isDirectory()) {
                    errors.add("The from-agent-dir directory does not exist: [" + fromAgentDir.getPath() + "]");
                } else {
                    String agentEnvFileName = File.separatorChar == '/' ? "bin/rhq-agent-env.sh" : "bin/rhq-agent-env.bat";
                    File agentEnvFile = new File(fromAgentDir, agentEnvFileName);
                    if (!agentEnvFile.isFile()) {
                        errors.add("The from-agent-dir directory does not appear to be an RHQ Agent installation. Missing expected file: [" + agentEnvFile.getPath() + "]");
                    }
                }
            }
        }
        return errors;
    }

    private void validateAgentConfigOption(File agentConfig, List<String> errors) {
        if (!agentConfig.exists()) {
            errors.add("The --agent-config option has as its value a file that does not exist [" + agentConfig.getAbsolutePath() + "]");
        } else if (agentConfig.isDirectory()) {
            errors.add("The --agent-config option has as its value a path that is a directory [" + agentConfig.getAbsolutePath() + "]. It should be an XML file that replaces the default " + "agent-configuration.xml");
        }
    }
}

