/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.SubsystemExtension;
import org.jboss.as.osgi.management.OSGiRuntimeResource;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.BootstrapBundlesIntegration;
import org.jboss.as.osgi.service.BundleLifecycleIntegration;
import org.jboss.as.osgi.service.FrameworkActivator;
import org.jboss.as.osgi.service.FrameworkModuleIntegration;
import org.jboss.as.osgi.service.InitialDeploymentTracker;
import org.jboss.as.osgi.service.JAXPServiceProvider;
import org.jboss.as.osgi.service.ModuleLoaderIntegration;
import org.jboss.as.osgi.service.PersistentBundlesIntegration;
import org.jboss.as.osgi.service.RepositoryService;
import org.jboss.as.osgi.service.ResolverService;
import org.jboss.as.osgi.service.SecurityActions;
import org.jboss.as.osgi.service.SystemPackagesIntegration;
import org.jboss.as.osgi.service.SystemServicesIntegration;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.log.ModuleLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.spi.FrameworkBuilder;
import org.jboss.osgi.framework.spi.FrameworkBuilderFactory;
import org.jboss.osgi.framework.spi.IntegrationService;
import org.jboss.osgi.framework.spi.SystemPaths;

public class FrameworkBootstrapService
implements Service<Void> {
    static final ServiceName SERVICE_NAME = OSGiConstants.SERVICE_BASE_NAME.append(new String[]{"framework", "bootstrap"});
    static final String MAPPED_OSGI_SOCKET_BINDINGS = "org.jboss.as.osgi.socket.bindings";
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private final InjectedValue<SubsystemState> injectedSubsystemState = new InjectedValue();
    private final InitialDeploymentTracker deploymentTracker;
    private final ServiceVerificationHandler verificationHandler;
    private final List<SubsystemExtension> extensions;
    private final OSGiRuntimeResource resource;

    public static ServiceController<Void> addService(ServiceTarget target, OSGiRuntimeResource resource, InitialDeploymentTracker deploymentTracker, List<SubsystemExtension> extensions, ServiceVerificationHandler verificationHandler) {
        FrameworkBootstrapService service = new FrameworkBootstrapService(resource, deploymentTracker, extensions, verificationHandler);
        ServiceBuilder builder = target.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.injectedServerEnvironment);
        builder.addDependency(OSGiConstants.SUBSYSTEM_STATE_SERVICE_NAME, SubsystemState.class, service.injectedSubsystemState);
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    private FrameworkBootstrapService(OSGiRuntimeResource resource, InitialDeploymentTracker deploymentTracker, List<SubsystemExtension> extensions, ServiceVerificationHandler verificationHandler) {
        this.verificationHandler = verificationHandler;
        this.deploymentTracker = deploymentTracker;
        this.extensions = extensions;
        this.resource = resource;
    }

    public synchronized void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Starting: %s in mode %s", controller.getName(), controller.getMode());
        try {
            ServiceContainer serviceContainer = context.getController().getServiceContainer();
            SubsystemState subsystemState = (SubsystemState)this.injectedSubsystemState.getValue();
            HashMap<String, Object> props = new HashMap<String, Object>(subsystemState.getProperties());
            this.setupIntegrationProperties(context, props);
            Module coreFrameworkModule = ((ModuleClassLoader)FrameworkBuilder.class.getClassLoader()).getModule();
            Module.registerURLStreamHandlerFactoryModule((Module)coreFrameworkModule);
            Module.registerContentHandlerFactoryModule((Module)coreFrameworkModule);
            ServiceTarget serviceTarget = context.getChildTarget();
            JAXPServiceProvider.addService(serviceTarget);
            ResolverService.addService(serviceTarget);
            RepositoryService.addService(serviceTarget);
            SubsystemState.Activation activation = subsystemState.getActivationPolicy();
            ServiceController.Mode initialMode = activation == SubsystemState.Activation.EAGER ? ServiceController.Mode.ACTIVE : ServiceController.Mode.LAZY;
            FrameworkBuilder builder = FrameworkBuilderFactory.create(props, (ServiceController.Mode)initialMode);
            builder.setServiceContainer(serviceContainer);
            builder.setServiceTarget(serviceTarget);
            builder.createFrameworkServices(serviceContainer, true);
            builder.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, (IntegrationService)new BundleLifecycleIntegration());
            builder.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, (IntegrationService)new FrameworkModuleIntegration(props));
            builder.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, (IntegrationService)new ModuleLoaderIntegration());
            builder.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, (IntegrationService)new SystemServicesIntegration(this.resource, this.extensions));
            builder.registerIntegrationService(FrameworkBuilder.FrameworkPhase.INIT, (IntegrationService)new BootstrapBundlesIntegration());
            builder.registerIntegrationService(FrameworkBuilder.FrameworkPhase.INIT, (IntegrationService)new PersistentBundlesIntegration(this.deploymentTracker));
            builder.installServices(FrameworkBuilder.FrameworkPhase.CREATE, serviceTarget, (ServiceListener)this.verificationHandler);
            if (activation == SubsystemState.Activation.EAGER) {
                builder.installServices(FrameworkBuilder.FrameworkPhase.INIT, serviceTarget, (ServiceListener)this.verificationHandler);
                builder.installServices(FrameworkBuilder.FrameworkPhase.ACTIVE, serviceTarget, (ServiceListener)this.verificationHandler);
            }
            FrameworkActivator.create(builder);
        }
        catch (Throwable th) {
            throw OSGiMessages.MESSAGES.startFailedToCreateFrameworkServices(th);
        }
    }

    public synchronized void stop(StopContext context) {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Stopping: %s in mode %s", controller.getName(), controller.getMode());
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    private void setupIntegrationProperties(StartContext context, Map<String, Object> props) {
        String extrapackages;
        String syspackages;
        String sysmodules;
        ModuleLogger moduleLogger;
        String storage = (String)props.get("org.osgi.framework.storage");
        if (storage == null) {
            ServerEnvironment environment = (ServerEnvironment)this.injectedServerEnvironment.getValue();
            File dataDir = environment.getServerDataDir();
            storage = dataDir.getAbsolutePath() + File.separator + "osgi-store";
            props.put("org.osgi.framework.storage", storage);
        }
        if ((moduleLogger = Module.getModuleLogger()) != null) {
            props.put(ModuleLogger.class.getName(), moduleLogger.getClass().getName());
        }
        if ((sysmodules = (String)props.get("org.jboss.osgi.system.modules")) == null) {
            LinkedHashSet<String> sysModules = new LinkedHashSet<String>();
            sysModules.addAll(Arrays.asList(SystemPackagesIntegration.DEFAULT_SYSTEM_MODULES));
            sysmodules = ((Object)sysModules).toString();
            sysmodules = sysmodules.substring(1, sysmodules.length() - 1);
            props.put("org.jboss.osgi.system.modules", sysmodules);
        }
        if ((syspackages = (String)this.getPropertyWithSystemFallback(props, "org.osgi.framework.system.packages")) == null) {
            LinkedHashSet<String> sysPackages = new LinkedHashSet<String>();
            sysPackages.addAll(Arrays.asList(SystemPackagesIntegration.JAVAX_API_PACKAGES));
            sysPackages.addAll(Arrays.asList(SystemPaths.DEFAULT_FRAMEWORK_PACKAGES));
            sysPackages.addAll(Arrays.asList(SystemPackagesIntegration.DEFAULT_INTEGRATION_PACKAGES));
            syspackages = ((Object)sysPackages).toString();
            syspackages = syspackages.substring(1, syspackages.length() - 1);
            props.put("org.osgi.framework.system.packages", syspackages);
        }
        if ((extrapackages = (String)this.getPropertyWithSystemFallback(props, "org.osgi.framework.system.packages.extra")) != null) {
            props.put("org.osgi.framework.system.packages.extra", extrapackages);
        }
    }

    Object getPropertyWithSystemFallback(Map<String, Object> props, String key) {
        Object value = props.get(key);
        if (value == null) {
            value = SecurityActions.getSystemProperty(key);
        }
        return value;
    }
}

