/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentHelper;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.management.OperationAssociation;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.client.ModelControllerServerDeploymentManager;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.spi.BundleLifecycle;
import org.jboss.osgi.framework.spi.BundleLifecyclePlugin;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.FutureServiceValue;
import org.jboss.osgi.framework.spi.ServiceTracker;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.vfs.VFSUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.startlevel.StartLevel;

public final class BundleLifecycleIntegration
extends BundleLifecyclePlugin {
    private static Map<String, Deployment> deploymentMap = new HashMap<String, Deployment>();
    private final InjectedValue<ModelController> injectedController = new InjectedValue();
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<StartLevel> injectedStartLevel = new InjectedValue();
    private final InjectedValue<XResolver> injectedResolver = new InjectedValue();
    private ServerDeploymentManager deploymentManager;

    protected void addServiceDependencies(ServiceBuilder<BundleLifecycle> builder) {
        super.addServiceDependencies(builder);
        builder.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, this.injectedController);
        builder.addDependency(org.jboss.osgi.framework.Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(org.jboss.osgi.framework.Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependency(org.jboss.osgi.framework.Services.RESOLVER, XResolver.class, this.injectedResolver);
        builder.addDependency(org.jboss.osgi.framework.Services.START_LEVEL, StartLevel.class, this.injectedStartLevel);
        builder.addDependency(org.jboss.osgi.framework.Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public void start(StartContext startContext) throws StartException {
        super.start(startContext);
        this.deploymentManager = new ModelControllerServerDeploymentManager((ModelController)this.injectedController.getValue());
    }

    protected BundleLifecycle createServiceValue(StartContext startContext) throws StartException {
        BundleLifecycle defaultService = super.createServiceValue(startContext);
        return new BundleLifecycleImpl(defaultService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Deployment getDeployment(String runtimeName) {
        Map<String, Deployment> map = deploymentMap;
        synchronized (map) {
            return deploymentMap.get(runtimeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putDeployment(String runtimeName, Deployment dep) {
        Map<String, Deployment> map = deploymentMap;
        synchronized (map) {
            deploymentMap.put(runtimeName, dep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Deployment removeDeployment(String runtimeName) {
        Map<String, Deployment> map = deploymentMap;
        synchronized (map) {
            return deploymentMap.remove(runtimeName);
        }
    }

    class BundleLifecycleImpl
    implements BundleLifecycle {
        private final BundleLifecycle defaultService;

        public BundleLifecycleImpl(BundleLifecycle defaultService) {
            this.defaultService = defaultService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void install(Deployment dep) throws BundleException {
            if (OperationAssociation.INSTANCE.getAssociation() != null) {
                OSGiLogger.LOGGER.warnCannotDeployBundleFromManagementOperation(dep);
                BundleManager bundleManager = (BundleManager)BundleLifecycleIntegration.this.injectedBundleManager.getValue();
                bundleManager.installBundle(dep, null, null);
            } else {
                OSGiLogger.LOGGER.debugf("Install deployment: %s", dep);
                String runtimeName = this.getRuntimeName(dep);
                BundleLifecycleIntegration.this.putDeployment(runtimeName, dep);
                try {
                    InputStream input = dep.getRoot().openStream();
                    try {
                        ServerDeploymentHelper server = new ServerDeploymentHelper(BundleLifecycleIntegration.this.deploymentManager);
                        server.deploy(runtimeName, input);
                    }
                    finally {
                        VFSUtils.safeClose((Closeable)input);
                    }
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (Exception ex) {
                    throw OSGiMessages.MESSAGES.cannotDeployBundle(ex, dep);
                }
            }
        }

        public void resolve(XBundle bundle2) throws ResolutionException {
            this.defaultService.resolve(bundle2);
            Deployment deployment = (Deployment)bundle2.adapt(Deployment.class);
            DeploymentUnit depUnit = (DeploymentUnit)deployment.getAttachment(DeploymentUnit.class);
            if (depUnit == null) {
                ModuleIdentifier identifier = bundle2.getBundleRevision().getModuleIdentifier();
                ServiceName moduleServiceName = ServiceModuleLoader.moduleServiceName((ModuleIdentifier)identifier);
                ServiceContainer serviceRegistry = ((BundleManager)BundleLifecycleIntegration.this.injectedBundleManager.getValue()).getServiceContainer();
                ServiceController controller = serviceRegistry.getRequiredService(moduleServiceName);
                FutureServiceValue future = new FutureServiceValue(controller);
                try {
                    future.get(2L, TimeUnit.SECONDS);
                }
                catch (Exception ex) {
                    throw FrameworkMessages.MESSAGES.illegalStateCannotLoadModule((Throwable)ex, identifier);
                }
            }
        }

        public void start(XBundle bundle2, int options) throws BundleException {
            Deployment deployment = (Deployment)bundle2.adapt(Deployment.class);
            DeploymentUnit depUnit = (DeploymentUnit)deployment.getAttachment(DeploymentUnit.class);
            if (depUnit == null) {
                this.defaultService.start(bundle2, options);
                return;
            }
            List deferredModules = DeploymentUtils.getDeferredModules((DeploymentUnit)depUnit);
            if (!deferredModules.contains(depUnit.getName())) {
                this.defaultService.start(bundle2, options);
                return;
            }
            ServiceController<Phase> phaseService = this.getDeferredPhaseService(depUnit);
            if (phaseService.getMode() != ServiceController.Mode.NEVER) {
                this.defaultService.start(bundle2, options);
                return;
            }
            ServiceName deploymentServiceName = depUnit.getParent() == null ? depUnit.getServiceName() : depUnit.getParent().getServiceName();
            ServiceController deploymentService = ((BundleManager)BundleLifecycleIntegration.this.injectedBundleManager.getValue()).getServiceContainer().getRequiredService(deploymentServiceName);
            this.activateDeferredPhase(bundle2, options, depUnit, phaseService, (ServiceController<DeploymentUnit>)deploymentService);
        }

        public void stop(XBundle bundle2, int options) throws BundleException {
            this.defaultService.stop(bundle2, options);
        }

        public void update(XBundle bundle2, InputStream input) throws BundleException {
            this.defaultService.update(bundle2, input);
        }

        public void uninstall(XBundle bundle2, int options) throws BundleException {
            OSGiLogger.LOGGER.tracef("Uninstall deployment: %s", bundle2);
            try {
                ServerDeploymentHelper server = new ServerDeploymentHelper(BundleLifecycleIntegration.this.deploymentManager);
                Deployment dep = (Deployment)bundle2.adapt(Deployment.class);
                server.undeploy(this.getRuntimeName(dep));
            }
            catch (Exception ex) {
                OSGiLogger.LOGGER.warnCannotUndeployBundle(ex, (Bundle)bundle2);
            }
        }

        private void activateDeferredPhase(XBundle bundle2, int options, DeploymentUnit depUnit, ServiceController<Phase> phaseService, ServiceController<DeploymentUnit> parentDeploymentService) throws BundleException {
            StartLevel startLevel = (StartLevel)BundleLifecycleIntegration.this.injectedStartLevel.getValue();
            int bundleStartLevel = startLevel.getBundleStartLevel((Bundle)bundle2);
            if (bundleStartLevel > startLevel.getStartLevel()) {
                OSGiLogger.LOGGER.debugf("Start level [%d] not valid for: %s", bundleStartLevel, bundle2);
                return;
            }
            OSGiLogger.LOGGER.infoActivateDeferredModulePhase((Bundle)bundle2);
            ServiceTracker<Object> serviceTracker = new ServiceTracker<Object>("DeferredActivation"){
                private final AtomicInteger count;
                {
                    this.count = new AtomicInteger();
                }

                public void serviceListenerAdded(ServiceController<? extends Object> controller) {
                    OSGiLogger.LOGGER.debugf("Added: [%d] %s ", this.count.incrementAndGet(), controller.getName());
                }

                protected void serviceStarted(ServiceController<?> controller) {
                    OSGiLogger.LOGGER.debugf("Started: [%d] %s ", this.count.decrementAndGet(), controller.getName());
                }

                protected void serviceStartFailed(ServiceController<?> controller) {
                    OSGiLogger.LOGGER.debugf("Failed: [%d] %s ", this.count.decrementAndGet(), controller.getName());
                }

                protected void complete() {
                    OSGiLogger.LOGGER.debugf("Complete: [%d]", this.count.get());
                }
            };
            phaseService.addListener(ServiceListener.Inheritance.ALL, (ServiceListener)serviceTracker);
            if (!bundle2.isResolved()) {
                XEnvironment env = (XEnvironment)BundleLifecycleIntegration.this.injectedEnvironment.getValue();
                XResolver resolver = (XResolver)BundleLifecycleIntegration.this.injectedResolver.getValue();
                XResolveContext context = resolver.createResolveContext(env, Collections.singleton(bundle2.getBundleRevision()), null);
                try {
                    resolver.resolveAndApply(context);
                }
                catch (ResolutionException ex) {
                    phaseService.removeListener((ServiceListener)serviceTracker);
                    throw FrameworkMessages.MESSAGES.cannotResolveBundle((Throwable)ex, (Bundle)bundle2);
                }
            }
            ((AtomicInteger)depUnit.getAttachment(Attachments.DEFERRED_ACTIVATION_COUNT)).incrementAndGet();
            phaseService.setMode(ServiceController.Mode.ACTIVE);
            try {
                serviceTracker.awaitCompletion();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (serviceTracker.hasFailedServices()) {
                StartException startex = null;
                for (ServiceController aux : serviceTracker.getFailedServices()) {
                    if (aux.getStartException() == null) continue;
                    startex = aux.getStartException();
                    break;
                }
                BundleException failure = startex != null && startex.getCause() instanceof BundleException ? (BundleException)startex.getCause() : OSGiMessages.MESSAGES.cannotActivateDeferredModulePhase((Throwable)startex, (Bundle)bundle2);
                OSGiLogger.LOGGER.warnDeactivateDeferredModulePhase((Bundle)bundle2);
                phaseService.setMode(ServiceController.Mode.NEVER);
                try {
                    FutureServiceValue future = new FutureServiceValue(phaseService, ServiceController.State.DOWN);
                    future.get(30L, TimeUnit.SECONDS);
                }
                catch (ExecutionException ex) {
                    OSGiLogger.LOGGER.errorf(failure, failure.getMessage(), new Object[0]);
                    throw OSGiMessages.MESSAGES.cannotDeactivateDeferredModulePhase(ex, (Bundle)bundle2);
                }
                catch (TimeoutException ex) {
                    OSGiLogger.LOGGER.errorf(failure, failure.getMessage(), new Object[0]);
                    throw OSGiMessages.MESSAGES.cannotDeactivateDeferredModulePhase(ex, (Bundle)bundle2);
                }
                throw failure;
            }
        }

        private String getRuntimeName(Deployment dep) {
            String location = dep.getLocation();
            try {
                new URI(location);
                int queryIndex = location.indexOf(63);
                if (queryIndex > 0) {
                    location = location.substring(0, queryIndex);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return location;
        }

        private ServiceController<Phase> getDeferredPhaseService(DeploymentUnit depUnit) {
            ServiceName serviceName = DeploymentUtils.getDeploymentUnitPhaseServiceName((DeploymentUnit)depUnit, (Phase)Phase.FIRST_MODULE_USE);
            BundleManager bundleManager = (BundleManager)BundleLifecycleIntegration.this.injectedBundleManager.getValue();
            ServiceContainer serviceContainer = bundleManager.getServiceContainer();
            return serviceContainer.getRequiredService(serviceName);
        }
    }
}

