/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.installer;

import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.as.controller.client.ModelControllerClient;
import org.rhq.cassandra.schema.DBConnectionFactory;
import org.rhq.cassandra.schema.SchemaManager;
import org.rhq.cassandra.schema.exception.InstalledSchemaTooOldException;
import org.rhq.cassandra.schema.exception.SchemaNotInstalledException;
import org.rhq.common.jbossas.client.controller.CoreJBossASClient;
import org.rhq.common.jbossas.client.controller.DatasourceJBossASClient;
import org.rhq.common.jbossas.client.controller.DeploymentJBossASClient;
import org.rhq.common.jbossas.client.controller.MCCHelper;
import org.rhq.common.jbossas.client.controller.WebJBossASClient;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.DbUtil;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.core.util.PropertiesFileUpdate;
import org.rhq.core.util.StringUtil;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.obfuscation.Obfuscator;
import org.rhq.core.util.obfuscation.PicketBoxObfuscator;
import org.rhq.enterprise.server.installer.InstallerConfiguration;
import org.rhq.enterprise.server.installer.InstallerService;
import org.rhq.enterprise.server.installer.ServerDetails;
import org.rhq.enterprise.server.installer.ServerInstallUtil;
import org.rhq.enterprise.server.installer.ServerProperties;

public class InstallerServiceImpl
implements InstallerService {
    private static final String RHQ_EXTENSION_NAME = "org.rhq.server-startup";
    private static final String RHQ_SUBSYSTEM_NAME = "rhq-startup";
    private static final String EAR_NAME = "rhq.ear";
    private static final String SYSPROP_PROPFILE = "rhq.server.properties-file";
    private static final String SYSPROP_BASEDIR = "rhq.server.basedir";
    private static final String SYSPROP_TEST_CONTROLLER_TIMEOUT = "rhq.test.controller.timeout";
    private static final int TEST_CONTROLLER_TIMEOUT_SECS;
    private final Log log = LogFactory.getLog(InstallerServiceImpl.class);
    private final InstallerConfiguration installerConfiguration;

    private void log(String s) {
        this.log.info((Object)s);
    }

    private void log(String s, Throwable t) {
        this.log.warn((Object)s, t);
    }

    public InstallerServiceImpl(InstallerConfiguration config) {
        this.installerConfiguration = config;
    }

    @Override
    public String obfuscatePassword(String clearTextPassword) throws Exception {
        String obfuscatedPassword = PicketBoxObfuscator.encode((String)clearTextPassword);
        return obfuscatedPassword;
    }

    @Override
    public void listServers() throws Exception {
        String obfuscatedDbPassword;
        String clearTextDbPassword;
        String dbUsername;
        HashMap<String, String> serverProperties = this.getServerProperties();
        String dbUrl = serverProperties.get("rhq.server.database.connection-url");
        ArrayList<ServerDetails> allServerDetails = this.getAllServerDetails(dbUrl, dbUsername = serverProperties.get("rhq.server.database.user-name"), clearTextDbPassword = PicketBoxObfuscator.decode((String)(obfuscatedDbPassword = serverProperties.get("rhq.server.database.password"))));
        if (allServerDetails == null) {
            this.log.warn((Object)"Cannot get details on all servers");
            return;
        }
        if (allServerDetails.size() == 0) {
            this.log("There are no known servers currently registered");
            return;
        }
        StringBuilder info = new StringBuilder("Details on currently registered servers");
        info.append("\n");
        info.append("Server Name");
        info.append("\t");
        info.append("Public Endpoint Address");
        info.append("\t");
        info.append("Secure Port");
        info.append("\n");
        for (ServerDetails serverDetails : allServerDetails) {
            info.append(serverDetails.getName());
            info.append("\t");
            info.append(serverDetails.getEndpointAddress());
            info.append("\t");
            info.append(serverDetails.getEndpointPortString());
            info.append("\t");
            info.append(serverDetails.getEndpointSecurePortString());
            info.append("\n");
        }
        this.log(info.toString());
    }

    @Override
    public void listVersions() throws Exception {
        String obfuscatedDbPassword;
        String clearTextDbPassword;
        String dbUsername;
        String version = this.getClass().getPackage().getImplementationVersion();
        HashMap<String, String> serverProperties = this.getServerProperties();
        String dbUrl = serverProperties.get("rhq.server.database.connection-url");
        LinkedHashMap<String, String> map = ServerInstallUtil.getServerVersions(dbUrl, dbUsername = serverProperties.get("rhq.server.database.user-name"), clearTextDbPassword = PicketBoxObfuscator.decode((String)(obfuscatedDbPassword = serverProperties.get("rhq.server.database.password"))));
        if (map.isEmpty()) {
            this.log("There are no Servers currently registered.");
            return;
        }
        StringBuilder info = new StringBuilder("\n\n");
        boolean upgradeRequired = false;
        info.append("Installed Server Versions");
        info.append("\n");
        info.append("Server Name");
        info.append("\n");
        for (Map.Entry entry : map.entrySet()) {
            info.append((String)entry.getKey());
            info.append("\tVersion = ");
            info.append((String)entry.getValue());
            info.append("\n");
            upgradeRequired |= !version.equals(entry.getValue());
        }
        info.append("\n");
        map = ServerInstallUtil.getStorageNodeVersions(dbUrl, dbUsername, clearTextDbPassword);
        if (null == map || map.isEmpty()) {
            info.append("There are no Storage Nodes currently registered.\n");
            info.append("This is normal when upgrading from a version without Storage Nodes. If so:\n");
            info.append("  ==> 1) Complete Server and Storage Node upgrades.\n");
            info.append("  ==> 2) Start all Storage Nodes to prepare them for a schema update.\n");
            info.append("  ==>    Use 'rhqctl start --storage'.  Servers and Agents should not be running.\n");
            info.append("  ==> 3) Initialize the Storage Cluster via 'rhqctl upgrade --storage-schema'.\n");
            info.append("  ==> 4) See 'rhq-data-migrator --help' for moving legacy data to the new storage cluster.");
            info.append("\n");
            this.log(info.toString());
            return;
        }
        info.append("Installed Storage Node Versions");
        info.append("\n");
        info.append("Storage Node Address");
        info.append("\n");
        for (Map.Entry entry : map.entrySet()) {
            info.append((String)entry.getKey());
            info.append("\tVersion = ");
            info.append((String)entry.getValue());
            info.append("\n");
            upgradeRequired |= !version.equals(entry.getValue());
        }
        info.append("\n");
        if (upgradeRequired) {
            info.append("  ==> At least one Server or Storage Node requires an upgrade to the current version!");
        } else {
            info.append("  ==> All Servers and Storage Nodes are at the same version. No upgrades required.");
        }
        info.append("\n\n");
        try {
            info.append("Checking Storage Cluster Schema Version...");
            info.append("\n\n");
            SchemaManager storageNodeSchemaManager = this.createStorageNodeSchemaManager(serverProperties);
            storageNodeSchemaManager.checkCompatibility();
            info.append("  ==> The Storage Cluster version is up to date. No update required.");
        }
        catch (NoHostAvailableException e1) {
            info.append("  ==> Could not connect to Storage Cluster.\n");
            info.append("  ==> To check Storage Cluster schema version start all nodes of the Storage Cluster and execute 'rhqctl uprade --list-versions'.");
        }
        catch (AuthenticationException e2) {
            info.append("  ==> Could not connect to Storage Cluster.\n");
            info.append("  ==> To check Storage Cluster schema version start all nodes of the Storage Cluster and execute 'rhqctl uprade --list-versions'.");
        }
        catch (InstalledSchemaTooOldException e3) {
            info.append("  ==> The Storage Cluster version is old and requires an update!\n");
            info.append("  ==> 1) Complete Server and Storage Node upgrades.\n");
            info.append("  ==> 2) Start all Storage Nodes to prepare them for a schema update.\n");
            info.append("  ==>    Use 'rhqctl start --storage'.  Servers and Agents should not be running.\n");
            info.append("  ==> 3) Update the Storage Cluster via 'rhqctl upgrade --storage-schema.'");
        }
        catch (Exception e) {
            info.append("  ==> Failed to check Storage Cluster Version: " + e.getMessage() + "\n");
            info.append("  ==> To check Storage Cluster schema version start all nodes of the Storage Cluster and execute 'rhqctl uprade --list-versions'.");
        }
        info.append("\n");
        this.log(info.toString());
    }

    @Override
    public void test() throws InstallerService.AutoInstallDisabledException, InstallerService.AlreadyInstalledException, Exception {
        HashMap<String, String> serverProperties = this.preInstall();
        ServerProperties.validate(serverProperties);
        String dbUrl = serverProperties.get("rhq.server.database.connection-url");
        String dbUsername = serverProperties.get("rhq.server.database.user-name");
        String obfuscatedDbPassword = serverProperties.get("rhq.server.database.password");
        String clearTextDbPassword = PicketBoxObfuscator.decode((String)obfuscatedDbPassword);
        String dbErrorStr = this.testConnection(dbUrl, dbUsername, clearTextDbPassword);
        if (dbErrorStr != null) {
            throw new Exception(dbErrorStr);
        }
        ServerDetails detailsFromProps = this.getServerDetailsFromPropertiesOnly(serverProperties);
        ServerDetails detailsFromDb = this.getServerDetails(dbUrl, dbUsername, clearTextDbPassword, detailsFromProps.getName());
        ServerInstallUtil.ExistingSchemaOption existingSchemaOption = this.getAutoinstallExistingSchemaOption(serverProperties);
        if (detailsFromDb == null) {
            this.log("This will be considered a new server: " + detailsFromProps);
        } else if (existingSchemaOption == ServerInstallUtil.ExistingSchemaOption.OVERWRITE) {
            this.log("This [" + detailsFromProps + "] will OVERWRITE the existing server [" + detailsFromDb + "] that already exists in the database.");
        } else {
            this.log("This [" + detailsFromProps + "] will be considered a reinstallation of an existing server [" + detailsFromDb + "]");
        }
        if (existingSchemaOption == ServerInstallUtil.ExistingSchemaOption.OVERWRITE) {
            this.log.warn((Object)"The installer has been configured to OVERWRITE any existing data in the database. If you do install with this configuration, realize that all existing data in the database will be lost.");
        }
        String appServerHomeDir = this.getAppServerHomeDir();
        this.log("The app server where the installation will go is found at: " + appServerHomeDir);
        this.log("It looks like everything is OK and you can start the installation.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public HashMap<String, String> preInstall() throws InstallerService.AutoInstallDisabledException, InstallerService.AlreadyInstalledException, Exception {
        boolean autoInstallMode;
        HashMap<String, String> serverProperties;
        try {
            serverProperties = this.getServerProperties();
            autoInstallMode = ServerInstallUtil.isAutoinstallEnabled(serverProperties);
        }
        catch (Throwable t) {
            throw new Exception("Cannot determine if in auto-install mode", t);
        }
        if (autoInstallMode) {
            this.log("The server is preconfigured and ready for auto-install.");
        } else {
            if (!this.installerConfiguration.isForceInstall()) throw new InstallerService.AutoInstallDisabledException("Auto-installation is disabled. Please fully configure rhq-server.properties");
            this.log("Auto-installation would have been disabled, but installer was asked to force the install... continuing.");
        }
        String asVersion = this.testModelControllerClient(serverProperties, TEST_CONTROLLER_TIMEOUT_SECS);
        this.log("Installing into app server version [" + asVersion + "]");
        String installationResults = this.getInstallationResults();
        if (installationResults == null) return serverProperties;
        if (installationResults.length() == 0) {
            if (!this.installerConfiguration.isForceInstall()) throw new InstallerService.AlreadyInstalledException("The installer has already been told to perform its work. The server should be ready soon.");
            this.log("The installer appears to have already been told to perform its work, but the installer was asked for force the install... continuing.");
            return serverProperties;
        } else {
            if (!this.installerConfiguration.isForceInstall()) throw new Exception("The installer has already attempted to install the server but errors occurred:\n" + installationResults);
            this.log("The installer is going to force another installation attempt, even though a previous attempt encountered errors:\n" + installationResults);
        }
        return serverProperties;
    }

    @Override
    public String getInstallationResults() throws Exception {
        if (this.isEarDeployed()) {
            return "";
        }
        if (this.getInstalledFileMarker().exists()) {
            return "";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(HashMap<String, String> serverProperties, ServerDetails serverDetails, String existingSchemaOption, boolean isUpgrade) throws InstallerService.AutoInstallDisabledException, InstallerService.AlreadyInstalledException, Exception {
        if (this.isEarDeployed()) {
            if (this.installerConfiguration.isForceInstall()) {
                this.log("It looks like the installation has already been completed, but the installer was asked for force the install... continuing.");
            } else {
                throw new InstallerService.AlreadyInstalledException("It looks like the installation has already been completed - there is nothing for the installer to do.");
            }
        }
        String appServerConfigDir = this.getAppServerConfigDir();
        Random random = new Random();
        String managementPassword = Obfuscator.generateString((Random)random, null, (int)8);
        ServerInstallUtil.createDefaultManagementUser(managementPassword, serverDetails, appServerConfigDir);
        String encodedManagementPassword = Obfuscator.encode((String)managementPassword);
        serverProperties.put("rhq.server.management.password", encodedManagementPassword);
        String storageUsername = serverProperties.get("rhq.storage.username");
        String storagePassword = serverProperties.get("rhq.storage.password");
        if (ServerInstallUtil.isEmpty(storageUsername)) {
            storageUsername = Obfuscator.generateString((Random)random, (String)"abcdefghijklmnopqrstuvwxyz", (int)8);
            serverProperties.put("rhq.storage.username", storageUsername);
        }
        if (ServerInstallUtil.isEmpty(storagePassword)) {
            storagePassword = Obfuscator.generateString((Random)random, null, (int)8);
            String encodedStoragePassword = PicketBoxObfuscator.encode((String)storagePassword);
            serverProperties.put("rhq.storage.password", encodedStoragePassword);
        }
        HashSet<String> additionalProperties = new HashSet<String>();
        additionalProperties.add("rhq.server.management.password");
        additionalProperties.add("rhq.storage.username");
        additionalProperties.add("rhq.storage.password");
        ServerProperties.validate(serverProperties, additionalProperties);
        this.prepareDatabase(serverProperties, serverDetails, existingSchemaOption, isUpgrade);
        ModelControllerClient mcc = null;
        try {
            mcc = this.createModelControllerClient();
            ServerInstallUtil.createObfuscationVault(mcc, serverProperties);
            ServerInstallUtil.setSocketBindings(mcc, serverProperties);
            ServerInstallUtil.configureDeploymentScanner(mcc);
            ServerInstallUtil.configureTransactionManager(mcc);
            ServerInstallUtil.configureLogging(mcc, serverProperties);
            ServerInstallUtil.createUserSecurityDomain(mcc);
            ServerInstallUtil.createRestSecurityDomain(mcc);
            File keystoreFile = ServerInstallUtil.createKeystore(serverDetails != null ? serverDetails : this.getServerDetailsFromPropertiesOnly(serverProperties), appServerConfigDir);
            ServerInstallUtil.setupWebConnectors(mcc, appServerConfigDir, serverProperties);
        }
        finally {
            MCCHelper.safeClose((ModelControllerClient)mcc);
        }
        this.deployServices(serverProperties);
        this.deployAppExtension();
        this.reloadConfiguration();
        this.testModelControllerClient(TEST_CONTROLLER_TIMEOUT_SECS);
        this.deployAppSubsystem();
        this.stampServerVersion(serverDetails);
        try {
            this.writeInstalledFileMarker();
        }
        catch (IOException e) {
            this.log.warn((Object)"An error occurred while creating the installed file marker", (Throwable)e);
        }
    }

    @Override
    public void prepareDatabase(HashMap<String, String> serverProperties, ServerDetails serverDetails, String existingSchemaOption, boolean isUpgrade) throws Exception {
        String[] properties;
        ServerInstallUtil.ExistingSchemaOption existingSchemaOptionEnum;
        String clearTextDbPassword;
        String obfuscatedDbPassword;
        ServerInstallUtil.SupportedDatabaseType supportedDbType;
        boolean autoInstallMode;
        block39: {
            autoInstallMode = ServerInstallUtil.isAutoinstallEnabled(serverProperties);
            if (autoInstallMode) {
                serverDetails = this.getServerDetailsFromPropertiesOnly(serverProperties);
            } else {
                if (serverDetails == null) {
                    throw new Exception("Auto-installation is disabled and cannot determine server details");
                }
                if (ServerInstallUtil.isEmpty(serverDetails.getName())) {
                    throw new Exception("Please enter a server name");
                }
                if (ServerInstallUtil.isEmpty(serverDetails.getEndpointAddress())) {
                    try {
                        serverDetails.setEndpointAddress(InetAddress.getLocalHost().getCanonicalHostName());
                    }
                    catch (Exception e) {
                        throw new Exception("Could not assign a server public address automatically - please specify one.");
                    }
                }
            }
            DatabaseTypeFactory.clearDatabaseTypeCache();
            String databaseType = serverProperties.get("rhq.server.database.type-mapping");
            if (ServerInstallUtil.isEmpty(databaseType)) {
                throw new Exception("Please indicate the type of database to connect to");
            }
            supportedDbType = ServerInstallUtil.getSupportedDatabaseType(databaseType);
            if (supportedDbType == null) {
                throw new Exception("Invalid database type: " + databaseType);
            }
            try {
                String url = serverProperties.get("rhq.server.database.connection-url");
                Pattern pattern = null;
                if (supportedDbType == ServerInstallUtil.SupportedDatabaseType.POSTGRES) {
                    pattern = Pattern.compile(".*://(.*):([0123456789]+)/(.*)");
                } else if (supportedDbType == ServerInstallUtil.SupportedDatabaseType.ORACLE) {
                    // empty if block
                }
                if (pattern == null) break block39;
                Matcher match = pattern.matcher(url);
                if (match.find() && match.groupCount() == 3) {
                    String serverName = match.group(1);
                    String port = match.group(2);
                    String dbName = match.group(3);
                    serverProperties.put("rhq.server.database.server-name", serverName);
                    serverProperties.put("rhq.server.database.port", port);
                    serverProperties.put("rhq.server.database.db-name", dbName);
                    break block39;
                }
                throw new Exception("Cannot get server, port or db name from connection URL: " + url);
            }
            catch (Exception e) {
                throw new Exception("JDBC connection URL seems to be invalid", e);
            }
        }
        try {
            String dialect = null;
            String quartzDriverDelegateClass = "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
            String quartzSelectWithLockSQL = "SELECT * FROM {0}LOCKS ROWLOCK WHERE LOCK_NAME = ? FOR UPDATE";
            String quartzLockHandlerClass = "org.quartz.impl.jdbcjobstore.StdRowLockSemaphore";
            if (supportedDbType == ServerInstallUtil.SupportedDatabaseType.POSTGRES) {
                dialect = "org.hibernate.dialect.PostgreSQLDialect";
                quartzDriverDelegateClass = "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate";
            } else if (supportedDbType == ServerInstallUtil.SupportedDatabaseType.ORACLE) {
                dialect = "org.hibernate.dialect.Oracle10gDialect";
                quartzDriverDelegateClass = "org.quartz.impl.jdbcjobstore.oracle.OracleDelegate";
            }
            serverProperties.put("hibernate.dialect", dialect);
            serverProperties.put("rhq.server.quartz.driverDelegateClass", quartzDriverDelegateClass);
            serverProperties.put("rhq.server.quartz.selectWithLockSQL", quartzSelectWithLockSQL);
            serverProperties.put("rhq.server.quartz.lockHandlerClass", quartzLockHandlerClass);
        }
        catch (Exception e) {
            throw new Exception("Cannot configure internal database settings", e);
        }
        String dbUrl = serverProperties.get("rhq.server.database.connection-url");
        String dbUsername = serverProperties.get("rhq.server.database.user-name");
        if (autoInstallMode) {
            obfuscatedDbPassword = serverProperties.get("rhq.server.database.password");
            clearTextDbPassword = PicketBoxObfuscator.decode((String)obfuscatedDbPassword);
        } else {
            clearTextDbPassword = serverProperties.get("rhq.server.database.password");
            obfuscatedDbPassword = PicketBoxObfuscator.encode((String)clearTextDbPassword);
            serverProperties.put("rhq.server.database.password", obfuscatedDbPassword);
        }
        String testConnectionErrorMessage = this.testConnection(dbUrl, dbUsername, clearTextDbPassword);
        if (testConnectionErrorMessage != null) {
            throw new Exception("Cannot connect to the database: " + testConnectionErrorMessage);
        }
        this.saveServerProperties(serverProperties);
        if (autoInstallMode) {
            existingSchemaOptionEnum = this.getAutoinstallExistingSchemaOption(serverProperties);
        } else {
            if (existingSchemaOption == null) {
                throw new Exception("Don't know what to do with the database schema");
            }
            existingSchemaOptionEnum = ServerInstallUtil.ExistingSchemaOption.valueOf(existingSchemaOption);
        }
        try {
            if (ServerInstallUtil.ExistingSchemaOption.SKIP != existingSchemaOptionEnum) {
                String dbSetupLogDir = this.getDatabaseSetupLogDir();
                if (this.isDatabaseSchemaExist(dbUrl, dbUsername, clearTextDbPassword)) {
                    if (ServerInstallUtil.ExistingSchemaOption.OVERWRITE == existingSchemaOptionEnum) {
                        this.log("Database schema exists but installer was told to overwrite it - a new schema will be created now.");
                        ServerInstallUtil.createNewDatabaseSchema(serverProperties, serverDetails, clearTextDbPassword, dbSetupLogDir);
                    } else {
                        this.log("Database schema exists - it will now be updated.");
                        ServerInstallUtil.upgradeExistingDatabaseSchema(serverProperties, serverDetails, clearTextDbPassword, dbSetupLogDir);
                    }
                } else {
                    this.log("Database schema does not yet exist - it will now be created.");
                    ServerInstallUtil.createNewDatabaseSchema(serverProperties, serverDetails, clearTextDbPassword, dbSetupLogDir);
                }
            } else {
                this.log("Ignoring database schema - installer will assume it exists and is already up-to-date.");
            }
        }
        catch (Exception e) {
            throw new Exception("Could not complete the database schema installation", e);
        }
        String storageNodes = serverProperties.get("rhq.storage.nodes");
        if (!isUpgrade && !StringUtil.isBlank((String)storageNodes)) {
            ServerInstallUtil.deleteStorageNodes(serverProperties, clearTextDbPassword, false);
        }
        Map<String, String> storageProperties = ServerInstallUtil.fetchStorageClusterSettings(serverProperties, clearTextDbPassword);
        for (String property : properties = new String[]{"rhq.storage.username", "rhq.storage.password", "rhq.storage.nodes", "rhq.storage.gossip-port", "rhq.storage.cql-port"}) {
            if (StringUtil.isBlank((String)storageProperties.get(property)) || storageProperties.get(property).equals("UNSET")) continue;
            serverProperties.put(property, storageProperties.get(property));
        }
        Set<String> storageNodeAddresses = null;
        if (!isUpgrade) {
            storageNodeAddresses = this.prepareStorageSchema(serverProperties, clearTextDbPassword, existingSchemaOptionEnum);
        } else {
            this.log("When all upgrades are complete the Storage Cluster schema must then be updated using 'rhqctl upgrade --storage-schema.");
        }
        ServerInstallUtil.storeServerDetails(serverProperties, clearTextDbPassword, serverDetails);
        ServerInstallUtil.persistAdminPasswordIfNecessary(serverProperties, clearTextDbPassword);
        if (!isUpgrade) {
            ServerInstallUtil.persistStorageNodesIfNecessary(serverProperties, clearTextDbPassword, this.parseNodeInformation(serverProperties, storageNodeAddresses));
        }
        ServerInstallUtil.persistStorageClusterSettingsIfNecessary(serverProperties, clearTextDbPassword);
        this.saveServerProperties(serverProperties);
    }

    @Override
    public void updateStorageSchema(HashMap<String, String> serverProperties) throws Exception {
        String obfuscatedDbPassword = serverProperties.get("rhq.server.database.password");
        String clearTextDbPassword = PicketBoxObfuscator.decode((String)obfuscatedDbPassword);
        Set<String> storageNodeAddresses = this.prepareStorageSchema(serverProperties, clearTextDbPassword, ServerInstallUtil.ExistingSchemaOption.KEEP);
        ServerInstallUtil.persistStorageNodesIfNecessary(serverProperties, clearTextDbPassword, this.parseNodeInformation(serverProperties, storageNodeAddresses));
    }

    private Set<String> prepareStorageSchema(HashMap<String, String> serverProperties, String clearTextDbPassword, ServerInstallUtil.ExistingSchemaOption existingSchemaOptionEnum) throws Exception {
        Set storageNodeAddresses;
        block10: {
            SchemaManager storageNodeSchemaManager = null;
            storageNodeAddresses = Collections.emptySet();
            try {
                storageNodeSchemaManager = this.createStorageNodeSchemaManager(serverProperties);
                if (ServerInstallUtil.ExistingSchemaOption.SKIP != existingSchemaOptionEnum) {
                    if (ServerInstallUtil.ExistingSchemaOption.OVERWRITE == existingSchemaOptionEnum) {
                        this.log("Storage cluster schema exists but the installer was told to overwrite it - dropping existing schema...");
                        storageNodeSchemaManager.drop();
                    }
                    final String dbPassword = clearTextDbPassword;
                    final String dbUrl = serverProperties.get("rhq.server.database.connection-url");
                    final String dbUsername = serverProperties.get("rhq.server.database.user-name");
                    DBConnectionFactory connectionFactory = new DBConnectionFactory(){

                        public Connection newConnection() throws SQLException {
                            return DbUtil.getConnection((String)dbUrl, (String)dbUsername, (String)dbPassword);
                        }
                    };
                    Properties schemaProperties = new Properties();
                    schemaProperties.put("relational_db_connection_factory", connectionFactory);
                    schemaProperties.put("data.dir", this.getAppServerDataDir());
                    try {
                        storageNodeSchemaManager.checkCompatibility();
                    }
                    catch (AuthenticationException e1) {
                        this.log("Storage user does not exist. Installing Storage Cluster schema along with updates to storage nodes.");
                        storageNodeSchemaManager.install(schemaProperties);
                        storageNodeSchemaManager.updateTopology();
                    }
                    catch (SchemaNotInstalledException e2) {
                        this.log("Storage cluster Schema does not exist. Installing Storage Cluster schema along with updates to storage nodes.");
                        storageNodeSchemaManager.install(schemaProperties);
                        storageNodeSchemaManager.updateTopology();
                    }
                    catch (InstalledSchemaTooOldException e3) {
                        this.log("Storage cluster Schema out of date. Applying Storage Cluster schema updates.");
                        storageNodeSchemaManager.install(schemaProperties);
                    }
                    storageNodeAddresses = storageNodeSchemaManager.getStorageNodeAddresses();
                    storageNodeSchemaManager.shutdown();
                    break block10;
                }
                this.log("Ignoring storage cluster schema - installer will assume it exists and is already up-to-date.");
            }
            catch (NoHostAvailableException e) {
                this.log.error((Object)"Failed to connect to the storage cluster. Please check the following:\n\t1) At least one storage node is running\n\t2) The rhq.storage.nodes property specifies the correct hostname/address of at least one storage node\n\t3) The rhq.storage.cql-port property has the correct value\n");
                throw new Exception("Could not connect to the storage cluster: " + ThrowableUtil.getRootMessage((Throwable)e));
            }
            catch (IllegalArgumentException e) {
                this.log.error((Object)"Failed to connect to the storage cluster. Please check the following:\n\t1) At least one storage node is running\n\t2) The rhq.storage.nodes property specifies the correct hostname/address of at least one storage node\n\t3) The rhq.storage.cql-port property has the correct value\n");
                throw new Exception("Could not connect to the storage cluster: " + ThrowableUtil.getRootMessage((Throwable)e));
            }
            catch (Exception e) {
                String msg = "Could not complete storage cluster schema installation: " + ThrowableUtil.getRootMessage((Throwable)e);
                this.log.error((Object)msg, (Throwable)e);
                throw new Exception(msg, e);
            }
        }
        return storageNodeAddresses;
    }

    @Override
    public ArrayList<String> getServerNames(String connectionUrl, String username, String password) {
        try {
            return ServerInstallUtil.getServerNames(connectionUrl, username, password);
        }
        catch (Exception e) {
            this.log("Could not get the list of registered server names", e);
            return null;
        }
    }

    @Override
    public ArrayList<ServerDetails> getAllServerDetails(String connectionUrl, String username, String password) {
        ArrayList<String> serverNames = this.getServerNames(connectionUrl, username, password);
        if (serverNames == null) {
            return null;
        }
        ArrayList<ServerDetails> serverDetails = new ArrayList<ServerDetails>(serverNames.size());
        for (String serverName : serverNames) {
            ServerDetails currentDetails = this.getServerDetails(connectionUrl, username, password, serverName);
            if (currentDetails == null) {
                return null;
            }
            serverDetails.add(currentDetails);
        }
        return serverDetails;
    }

    @Override
    public ServerDetails getServerDetails(String connectionUrl, String username, String password, String serverName) {
        try {
            ServerDetails sd = ServerInstallUtil.getServerDetails(connectionUrl, username, password, serverName);
            if (sd != null) {
                if (ServerInstallUtil.isEmpty(sd.getName())) {
                    try {
                        sd.setEndpointAddress(InetAddress.getLocalHost().getCanonicalHostName());
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                if (ServerInstallUtil.isEmpty(sd.getEndpointAddress())) {
                    try {
                        sd.setEndpointAddress(InetAddress.getLocalHost().getHostAddress());
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
            }
            return sd;
        }
        catch (Exception e) {
            this.log("Could not get server details for [" + serverName + "]", e);
            return null;
        }
    }

    @Override
    public boolean isDatabaseSchemaExist(String connectionUrl, String username, String password) {
        try {
            return ServerInstallUtil.isDatabaseSchemaExist(connectionUrl, username, password);
        }
        catch (Exception e) {
            this.log("Could not determine database existence", e);
            return false;
        }
    }

    @Override
    public String testConnection(String connectionUrl, String username, String password) {
        String results = ServerInstallUtil.testConnection(connectionUrl, username, password);
        return results;
    }

    @Override
    public HashMap<String, String> getServerProperties() throws Exception {
        File serverPropertiesFile = this.getServerPropertiesFile();
        PropertiesFileUpdate propsFile = new PropertiesFileUpdate(serverPropertiesFile.getAbsolutePath());
        Properties props = propsFile.loadExistingProperties();
        boolean isIBM = System.getProperty("java.vendor", "").contains("IBM");
        if (isIBM) {
            for (String algPropName : ServerProperties.IBM_ALGOROTHM_SETTINGS) {
                if (!props.getProperty(algPropName, "").equalsIgnoreCase("SunX509")) continue;
                props.setProperty(algPropName, "IbmX509");
            }
        }
        HashMap<String, String> map = new HashMap<String, String>(props.size());
        for (Object property : props.keySet()) {
            map.put(property.toString(), props.getProperty(property.toString()));
        }
        return map;
    }

    private void saveServerProperties(HashMap<String, String> serverProperties) throws Exception {
        ServerProperties.validate(serverProperties);
        File serverPropertiesFile = this.getServerPropertiesFile();
        PropertiesFileUpdate propsFile = new PropertiesFileUpdate(serverPropertiesFile.getAbsolutePath());
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : serverProperties.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        if (!props.containsKey("rhq.server.log-level")) {
            props.setProperty("rhq.server.log-level", "INFO");
            serverProperties.put("rhq.server.log-level", "INFO");
        }
        propsFile.update(props);
        for (Map.Entry<String, String> entry : serverProperties.entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAppServerVersion() throws Exception {
        ModelControllerClient mcc = null;
        try {
            String version;
            mcc = this.createModelControllerClient();
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            String string = version = client.getAppServerVersion();
            return string;
        }
        finally {
            MCCHelper.safeClose((ModelControllerClient)mcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOperatingSystem() throws Exception {
        ModelControllerClient mcc = null;
        try {
            String osName;
            mcc = this.createModelControllerClient();
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            String string = osName = client.getOperatingSystem();
            return string;
        }
        finally {
            MCCHelper.safeClose((ModelControllerClient)mcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAppServerHomeDir() throws Exception {
        File baseDir = new File(System.getProperty(SYSPROP_BASEDIR));
        if (null != baseDir && baseDir.isDirectory()) {
            return baseDir.getAbsolutePath();
        }
        ModelControllerClient mcc = null;
        try {
            String dir;
            mcc = this.createModelControllerClient();
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            String string = dir = client.getAppServerHomeDir();
            return string;
        }
        finally {
            MCCHelper.safeClose((ModelControllerClient)mcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAppServerDataDir() throws Exception {
        File dataDir;
        File basedir = new File(System.getProperty(SYSPROP_BASEDIR));
        if (null != basedir && (dataDir = new File(basedir, "jbossas/standalone/data")).isDirectory()) {
            return dataDir.getAbsolutePath();
        }
        ModelControllerClient mcc = null;
        try {
            String dir;
            mcc = this.createModelControllerClient();
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            String string = dir = client.getAppServerDataDir();
            return string;
        }
        finally {
            MCCHelper.safeClose((ModelControllerClient)mcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAppServerConfigDir() throws Exception {
        File confDir;
        File basedir = new File(System.getProperty(SYSPROP_BASEDIR));
        if (null != basedir && (confDir = new File(basedir, "jbossas/standalone/configuration")).isDirectory()) {
            return confDir.getAbsolutePath();
        }
        ModelControllerClient mcc = null;
        try {
            String dir;
            mcc = this.createModelControllerClient();
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            String string = dir = client.getAppServerConfigDir();
            return string;
        }
        finally {
            MCCHelper.safeClose((ModelControllerClient)mcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEarDeployed() throws Exception {
        ModelControllerClient mcc = null;
        try {
            boolean isDeployed;
            mcc = this.createModelControllerClient();
            DeploymentJBossASClient client = new DeploymentJBossASClient(mcc);
            boolean bl = isDeployed = client.isDeployment(EAR_NAME);
            return bl;
        }
        finally {
            MCCHelper.safeClose((ModelControllerClient)mcc);
        }
    }

    private String getDatabaseSetupLogDir() throws Exception {
        File logDir;
        String installerLogDirStr = System.getProperty("rhq.server.installer.logdir");
        if (installerLogDirStr != null) {
            logDir = new File(installerLogDirStr);
            logDir.mkdirs();
            if (!logDir.isDirectory()) {
                throw new Exception("Cannot create installer log directory: " + logDir);
            }
        } else {
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            if (!tmpDir.isDirectory()) {
                this.log("Missing tmp dir [" + tmpDir + "]; will use current directory to store logs");
                logDir = new File(".");
            } else {
                logDir = new File(tmpDir, "rhq-installer-db");
                logDir.mkdir();
                if (!logDir.isDirectory()) {
                    this.log("Cannot create database setup log directory [" + logDir + "]; will use current directory");
                    logDir = new File(".");
                }
            }
        }
        String logDirPath = logDir.getAbsolutePath();
        this.log("Database setup log file directory: " + logDirPath);
        return logDirPath;
    }

    private File getServerPropertiesFile() throws Exception {
        String sysprop = System.getProperty(SYSPROP_PROPFILE);
        if (sysprop != null) {
            File propFile = new File(sysprop);
            if (propFile.isFile()) {
                return propFile;
            }
            throw new IllegalArgumentException("System property [rhq.server.properties-file] pointing to invalid file: " + propFile);
        }
        File appServerHomeDir = new File(this.getAppServerHomeDir());
        File serverPropertiesFile = new File(appServerHomeDir, "../bin/rhq-server.properties");
        return serverPropertiesFile;
    }

    private ServerInstallUtil.ExistingSchemaOption getAutoinstallExistingSchemaOption(HashMap<String, String> serverProperties) {
        String s = serverProperties.get("rhq.autoinstall.database");
        ServerInstallUtil.ExistingSchemaOption existingSchemaOptionEnum = s == null || s.equalsIgnoreCase("auto") ? ServerInstallUtil.ExistingSchemaOption.KEEP : ServerInstallUtil.ExistingSchemaOption.valueOf(s.toUpperCase());
        return existingSchemaOptionEnum;
    }

    private ServerDetails getServerDetailsFromPropertiesOnly(HashMap<String, String> serverProperties) throws Exception {
        String connectorTransport;
        String highAvailabilityName = serverProperties.get("rhq.server.high-availability.name");
        String publicEndpoint = serverProperties.get("rhq.autoinstall.public-endpoint-address");
        if (ServerInstallUtil.isEmpty(highAvailabilityName)) {
            try {
                highAvailabilityName = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception e) {
                this.log("Could not determine default server name: ", e);
                throw new Exception("Server name is not preconfigured and could not be determined automatically");
            }
        }
        if (ServerInstallUtil.isEmpty(publicEndpoint)) {
            String connBindAddress = serverProperties.get("rhq.communications.connector.bind-address");
            if (!ServerInstallUtil.isEmpty(connBindAddress) && !"0.0.0.0".equals(connBindAddress.trim())) {
                publicEndpoint = connBindAddress.trim();
            } else {
                String serverBindAddress = serverProperties.get("jboss.bind.address");
                if (!ServerInstallUtil.isEmpty(serverBindAddress) && !"0.0.0.0".equals(serverBindAddress.trim())) {
                    publicEndpoint = serverBindAddress.trim();
                } else {
                    try {
                        publicEndpoint = InetAddress.getLocalHost().getCanonicalHostName();
                    }
                    catch (Exception e) {
                        this.log("Could not determine default public endpoint address: ", e);
                        throw new Exception("Public endpoint address not preconfigured and could not be determined automatically");
                    }
                }
            }
        }
        int port = -1;
        int securePort = -1;
        String publicPort = serverProperties.get("rhq.autoinstall.public-endpoint-port");
        String publicSecurePort = serverProperties.get("rhq.autoinstall.public-endpoint-secure-port");
        if (!ServerInstallUtil.isEmpty(publicPort)) {
            try {
                port = Integer.parseInt(publicPort);
            }
            catch (Exception e) {
                this.log("Invalid public endpoint port specified - will fallback to a default value", e);
            }
        }
        if (!ServerInstallUtil.isEmpty(publicSecurePort)) {
            try {
                securePort = Integer.parseInt(publicSecurePort);
            }
            catch (Exception e) {
                this.log("Invalid public endpoint secure port specified - will fallback to a default value", e);
            }
        }
        if ((connectorTransport = serverProperties.get("rhq.communications.connector.transport")) != null && connectorTransport.contains("socket")) {
            String connectorBindPort = serverProperties.get("rhq.communications.connector.bind-port");
            if (ServerInstallUtil.isEmpty(connectorBindPort) || "0".equals(connectorBindPort.trim())) {
                throw new Exception("Using non-servlet transport [" + connectorTransport + "] but didn't define a port");
            }
            if (port == -1) {
                port = Integer.parseInt(connectorBindPort);
            }
            if (securePort == -1) {
                securePort = Integer.parseInt(connectorBindPort);
            }
        } else {
            if (port == -1) {
                try {
                    port = Integer.parseInt(serverProperties.get("rhq.server.socket.binding.port.http"));
                }
                catch (Exception e) {
                    this.log("Could not determine port, will use default: " + e);
                    port = 7080;
                }
            }
            if (securePort == -1) {
                try {
                    securePort = Integer.parseInt(serverProperties.get("rhq.server.socket.binding.port.https"));
                }
                catch (Exception e) {
                    this.log("Could not determine secure port, will use default: " + e);
                    securePort = 7443;
                }
            }
        }
        ServerDetails serverDetails = new ServerDetails(highAvailabilityName, publicEndpoint, port, securePort);
        return serverDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String testModelControllerClient(HashMap<String, String> fallbackProps, int secsToWait) throws Exception {
        long start = System.currentTimeMillis();
        long end = start + (long)secsToWait * 1000L;
        Exception error = null;
        while (System.currentTimeMillis() < end) {
            String string;
            String retVal = this.testModelControllerClient(fallbackProps);
            ModelControllerClient mcc = null;
            try {
                mcc = this.createModelControllerClient();
                if (!new WebJBossASClient(mcc).isWebSubsystem()) {
                    throw new IllegalStateException("The server does not appear to be fully started yet (the web subsystem did not start)");
                }
                string = retVal;
            }
            catch (Throwable throwable) {
                try {
                    MCCHelper.safeClose((ModelControllerClient)mcc);
                    throw throwable;
                }
                catch (Exception e) {
                    error = e;
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ignore) {}
                }
            }
            MCCHelper.safeClose((ModelControllerClient)mcc);
            return string;
        }
        throw new RuntimeException("Timed out before being able to successfully connect to the server", error);
    }

    private String testModelControllerClient(int secsToWait) throws Exception {
        return this.testModelControllerClient(null, secsToWait);
    }

    private String testModelControllerClient(HashMap<String, String> fallbackProps) throws Exception {
        String host = this.installerConfiguration.getManagementHost();
        int port = this.installerConfiguration.getManagementPort();
        ModelControllerClient mcc = null;
        try {
            String asVersion;
            mcc = ModelControllerClient.Factory.create((String)host, (int)port);
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            Properties sysprops = client.getSystemProperties();
            if (!sysprops.containsKey("rhq.server.database.connection-url")) {
                throw new Exception("Not an RHQ Server");
            }
            String string = asVersion = client.getAppServerVersion();
            return string;
        }
        catch (Exception e) {
            try {
                mcc.close();
                mcc = null;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            if (fallbackProps == null) {
                throw new Exception("Cannot obtain client connection to the RHQ app server", e);
            }
            try {
                String portStr;
                boolean differentValues = false;
                String hostStr = fallbackProps.get("jboss.bind.address.management");
                if (hostStr != null && hostStr.length() > 0 && !hostStr.equals(host)) {
                    host = hostStr;
                    if (host.equals("0.0.0.0")) {
                        host = "127.0.0.1";
                    }
                    differentValues = true;
                }
                if ((portStr = fallbackProps.get("jboss.management.native.port")) != null && !portStr.equals(String.valueOf(port))) {
                    port = Integer.parseInt(portStr);
                    differentValues = true;
                }
                if (!differentValues) {
                    throw new Exception("Cannot obtain client connection to the RHQ app server!", e);
                }
                mcc = ModelControllerClient.Factory.create((String)host, (int)port);
                CoreJBossASClient client = new CoreJBossASClient(mcc);
                Properties sysprops = client.getSystemProperties();
                if (!sysprops.containsKey("rhq.server.database.connection-url")) {
                    throw new Exception("Not an RHQ Server");
                }
                String asVersion = client.getAppServerVersion();
                this.installerConfiguration.setManagementHost(host);
                this.installerConfiguration.setManagementPort(port);
                String string = asVersion;
                return string;
            }
            catch (Exception e2) {
                throw new Exception("Cannot obtain client connection to the RHQ app server!!", e);
            }
            finally {
                MCCHelper.safeClose((ModelControllerClient)mcc);
                mcc = null;
            }
        }
        finally {
            MCCHelper.safeClose((ModelControllerClient)mcc);
        }
    }

    private ModelControllerClient createModelControllerClient() {
        ModelControllerClient client;
        try {
            String host = this.installerConfiguration.getManagementHost();
            int port = this.installerConfiguration.getManagementPort();
            client = ModelControllerClient.Factory.create((String)host, (int)port);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot obtain client connection to the app server", e);
        }
        return client;
    }

    private void deployServices(HashMap<String, String> serverProperties) throws Exception {
        ModelControllerClient mcc = null;
        try {
            mcc = this.createModelControllerClient();
            ServerInstallUtil.createDatasourceSecurityDomain(mcc, serverProperties);
            ServerInstallUtil.createNewCaches(mcc, serverProperties);
            ServerInstallUtil.createNewJdbcDrivers(mcc, serverProperties);
            ServerInstallUtil.createNewDatasources(mcc, serverProperties);
            ServerInstallUtil.createNewJMSQueues(mcc, serverProperties);
            ServerInstallUtil.setupMailService(mcc, serverProperties);
            new CoreJBossASClient(mcc).setEnableAdminConsole(false);
            new DatasourceJBossASClient(mcc).removeDatasource("ExampleDS");
        }
        catch (Exception e) {
            this.log("deployServices failed", e);
            throw new Exception("Failed to deploy services: " + ThrowableUtil.getAllMessages((Throwable)e));
        }
        finally {
            MCCHelper.safeClose((ModelControllerClient)mcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployAppExtension() throws Exception {
        ModelControllerClient mcc = null;
        try {
            mcc = this.createModelControllerClient();
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            boolean isDeployed = client.isExtension(RHQ_EXTENSION_NAME);
            if (!isDeployed) {
                this.log("Installing RHQ EAR startup subsystem extension");
                client.addExtension(RHQ_EXTENSION_NAME);
            } else {
                this.log("RHQ EAR startup subsystem extension is already deployed");
            }
        }
        finally {
            MCCHelper.safeClose((ModelControllerClient)mcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployAppSubsystem() throws Exception {
        ModelControllerClient mcc = null;
        try {
            mcc = this.createModelControllerClient();
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            boolean isDeployed = client.isSubsystem(RHQ_SUBSYSTEM_NAME);
            if (!isDeployed) {
                this.log("Installing RHQ EAR subsystem");
                client.addSubsystem(RHQ_SUBSYSTEM_NAME);
            } else {
                this.log("RHQ EAR subsystem is already deployed");
            }
        }
        finally {
            MCCHelper.safeClose((ModelControllerClient)mcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadConfiguration() {
        this.log("Will now ask the app server to reload its configuration");
        ModelControllerClient mcc = null;
        try {
            mcc = this.createModelControllerClient();
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            client.reload();
            this.log("App server has been successfully asked to reload its configuration");
        }
        catch (Exception e) {
            this.log("reloadConfiguration failed - restart the server to complete the installation", e);
        }
        finally {
            MCCHelper.safeClose((ModelControllerClient)mcc);
        }
    }

    private Set<StorageNode> parseNodeInformation(Map<String, String> serverProps, Set<String> storageNodeAddresses) {
        if (storageNodeAddresses.size() == 0) {
            throw new IllegalArgumentException("List of storage nodes not configured.");
        }
        String propStorageCQLPort = serverProps.get("rhq.storage.cql-port");
        if (propStorageCQLPort == null || propStorageCQLPort.trim().isEmpty()) {
            throw new IllegalArgumentException("CQL port not configured.");
        }
        int cqlPort = Integer.parseInt(serverProps.get("rhq.storage.cql-port"));
        TreeSet<StorageNode> parsedNodes = new TreeSet<StorageNode>(new Comparator<StorageNode>(){

            @Override
            public int compare(StorageNode left, StorageNode right) {
                return left.getAddress().compareTo(right.getAddress());
            }
        });
        for (String address : storageNodeAddresses) {
            StorageNode node = new StorageNode();
            node.setAddress(address);
            node.setCqlPort(cqlPort);
            parsedNodes.add(node);
        }
        return parsedNodes;
    }

    private Set<StorageNode> parseNodeInformation(Map<String, String> serverProps) {
        String propStorageNodes = serverProps.get("rhq.storage.nodes");
        if (propStorageNodes == null || propStorageNodes.trim().isEmpty()) {
            throw new IllegalArgumentException("rhq.storage.nodes not set.");
        }
        return this.parseNodeInformation(serverProps, (Set<String>)ImmutableSet.copyOf((Object[])serverProps.get("rhq.storage.nodes").split(",")));
    }

    private SchemaManager createStorageNodeSchemaManager(Map<String, String> serverProps) {
        String username = serverProps.get("rhq.storage.username");
        String password = serverProps.get("rhq.storage.password");
        ArrayList<StorageNode> storageNodes = new ArrayList<StorageNode>(this.parseNodeInformation(serverProps));
        String[] nodes = new String[storageNodes.size()];
        for (int index = 0; index < storageNodes.size(); ++index) {
            nodes[index] = ((StorageNode)storageNodes.get(index)).getAddress();
        }
        int cqlPort = ((StorageNode)storageNodes.get(0)).getCqlPort();
        return new SchemaManager(username, password, nodes, cqlPort);
    }

    private File getInstalledFileMarker() throws Exception {
        File datadir = new File(this.getAppServerDataDir());
        if (!datadir.isDirectory()) {
            throw new IOException("Directory Not Found: [" + datadir.getPath() + "]");
        }
        File markerFile = new File(datadir, "rhq.installed");
        return markerFile;
    }

    private void writeInstalledFileMarker() throws Exception {
        File markerFile = this.getInstalledFileMarker();
        markerFile.createNewFile();
    }

    private void stampServerVersion(ServerDetails serverDetails) throws Exception {
        HashMap<String, String> serverProperties = this.getServerProperties();
        String dbUrl = serverProperties.get("rhq.server.database.connection-url");
        String dbUsername = serverProperties.get("rhq.server.database.user-name");
        String obfuscatedDbPassword = serverProperties.get("rhq.server.database.password");
        String clearTextDbPassword = PicketBoxObfuscator.decode((String)obfuscatedDbPassword);
        if (null == serverDetails) {
            serverDetails = this.getServerDetailsFromPropertiesOnly(serverProperties);
        }
        ServerInstallUtil.updateServerVersion(dbUrl, dbUsername, clearTextDbPassword, serverDetails.getName());
    }

    static {
        int secs = 60;
        try {
            secs = Integer.parseInt(System.getProperty(SYSPROP_TEST_CONTROLLER_TIMEOUT, String.valueOf(secs)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        TEST_CONTROLLER_TIMEOUT_SECS = secs;
    }
}

