/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.script;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.util.StringUtil;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.script.ScriptArgumentParser;

public class ScriptServerComponent
implements ResourceComponent,
MeasurementFacet,
OperationFacet {
    private static final Log LOG = LogFactory.getLog(ScriptServerComponent.class);
    private static final long DEFAULT_MAX_WAIT_TIME = 3600000L;
    protected static final String PLUGINCONFIG_EXECUTABLE = "executable";
    protected static final String PLUGINCONFIG_WORKINGDIR = "workingDirectory";
    protected static final String PLUGINCONFIG_ENVVARS = "environmentVariables";
    protected static final String PLUGINCONFIG_ENVVAR_NAME = "name";
    protected static final String PLUGINCONFIG_ENVVAR_VALUE = "value";
    protected static final String PLUGINCONFIG_AVAIL_EXECUTE_CHECK = "availabilityExecuteCheck";
    protected static final String PLUGINCONFIG_AVAIL_EXITCODE_REGEX = "availabilityExitCodeRegex";
    protected static final String PLUGINCONFIG_AVAIL_OUTPUT_REGEX = "availabilityOutputRegex";
    protected static final String PLUGINCONFIG_AVAIL_ARGS = "availabilityArguments";
    protected static final String PLUGINCONFIG_VERSION_ARGS = "versionArguments";
    protected static final String PLUGINCONFIG_VERSION_REGEX = "versionRegex";
    protected static final String PLUGINCONFIG_FIXED_VERSION = "fixedVersion";
    protected static final String PLUGINCONFIG_DESC_ARGS = "descriptionArguments";
    protected static final String PLUGINCONFIG_DESC_REGEX = "descriptionRegex";
    protected static final String PLUGINCONFIG_FIXED_DESC = "fixedDescription";
    protected static final String PLUGINCONFIG_QUOTING_ENABLED = "quotingEnabled";
    protected static final String PLUGINCONFIG_ESCAPE_CHARACTER = "escapeCharacter";
    protected static final String OPERATION_PARAM_ARGUMENTS = "arguments";
    protected static final String OPERATION_PARAM_WAIT_TIME = "waitTime";
    protected static final String OPERATION_PARAM_CAPTURE_OUTPUT = "captureOutput";
    protected static final String OPERATION_PARAM_KILL_ON_TIMEOUT = "killOnTimeout";
    protected static final String OPERATION_RESULT_EXITCODE = "exitCode";
    protected static final String OPERATION_RESULT_OUTPUT = "output";
    protected static final String METRIC_PROPERTY_ARGUMENTS = "arguments";
    protected static final String METRIC_PROPERTY_REGEX = "regex";
    protected static final String METRIC_PROPERTY_EXITCODE = "exitcode";
    protected static final char DISABLING_ESCAPE_CHARACTER = '\u0000';
    private char escapeChar = '\u0000';
    private ResourceContext resourceContext;

    public void start(ResourceContext context) {
        this.resourceContext = context;
        this.escapeChar = ScriptServerComponent.getConfiguredEscapeCharacter(this.resourceContext.getPluginConfiguration());
        if (StringUtil.isBlank((String)this.resourceContext.getPluginConfiguration().getSimpleValue(PLUGINCONFIG_QUOTING_ENABLED))) {
            LOG.warn((Object)(this.resourceContext.getResourceDetails() + ": the attribute enabling argument quoting is not set" + " in plugin config. Defaulting to enabled."));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Script Server started: " + context.getPluginConfiguration()));
        }
    }

    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Script Server stopped: " + this.resourceContext.getPluginConfiguration()));
        }
    }

    public AvailabilityType getAvailability() {
        boolean result = this.checkAvailability();
        return result ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        HashMap<String, ProcessExecutionResults> exeResultsCache = new HashMap<String, ProcessExecutionResults>();
        Iterator<MeasurementScheduleRequest> i$ = requests.iterator();
        while (i$.hasNext()) {
            boolean dataMustBeNumeric;
            MeasurementScheduleRequest request = i$.next();
            String metricPropertyName = request.getName();
            if (request.getDataType() == DataType.MEASUREMENT) {
                dataMustBeNumeric = true;
            } else if (request.getDataType() == DataType.TRAIT) {
                dataMustBeNumeric = false;
            } else {
                LOG.error((Object)("Plugin does not support metric [" + metricPropertyName + "] of type [" + request.getDataType() + "]"));
                continue;
            }
            try {
                Object dataValue;
                block19: {
                    Map<String, String> argsRegex = this.parseMetricProperty(metricPropertyName);
                    if (argsRegex == null) continue;
                    String arguments = argsRegex.get("arguments");
                    String regex = argsRegex.get(METRIC_PROPERTY_REGEX);
                    boolean valueIsExitCode = METRIC_PROPERTY_EXITCODE.equals(regex);
                    ProcessExecutionResults exeResults = (ProcessExecutionResults)exeResultsCache.get(arguments == null ? "" : arguments);
                    if (exeResults == null) {
                        boolean captureOutput = !valueIsExitCode;
                        exeResults = this.executeExecutable(arguments, 3600000L, captureOutput);
                        exeResultsCache.put(arguments == null ? "" : arguments, exeResults);
                    }
                    if (exeResults.getError() != null) {
                        LOG.error((Object)("Cannot collect CLI metric [" + metricPropertyName + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)exeResults.getError())));
                        continue;
                    }
                    if (valueIsExitCode) {
                        dataValue = exeResults.getExitCode();
                        if (dataValue == null) {
                            LOG.error((Object)("Could not determine exit code for metric property [" + metricPropertyName + "] - metric will not be collected"));
                            continue;
                        }
                    } else {
                        if (regex != null) {
                            String output = exeResults.getCapturedOutput();
                            if (output == null) {
                                LOG.error((Object)("Could not get output for metric property [" + metricPropertyName + "] -- metric will not be collected"));
                                continue;
                            }
                            output = output.trim();
                            Pattern pattern = Pattern.compile(regex);
                            Matcher match = pattern.matcher(output);
                            if (match.find()) {
                                dataValue = match.groupCount() > 0 ? match.group(1) : output;
                                break block19;
                            } else {
                                LOG.error((Object)("Output did not match metric property [" + metricPropertyName + "] - metric will not be collected: " + this.truncateString(output)));
                                continue;
                            }
                        }
                        dataValue = exeResults.getCapturedOutput();
                        if (dataValue == null) {
                            LOG.error((Object)("Could not get output for metric property [" + metricPropertyName + "] - metric will not be collected"));
                            continue;
                        }
                    }
                }
                if (dataMustBeNumeric) {
                    Double numeric = Double.parseDouble(dataValue.toString().trim());
                    report.addData(new MeasurementDataNumeric(request, numeric));
                    continue;
                }
                report.addData(new MeasurementDataTrait(request, dataValue.toString().trim()));
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to obtain measurement [" + metricPropertyName + "]. Cause: " + e));
                continue;
            }
            break;
        }
        return;
    }

    protected Map<String, String> parseMetricProperty(String metricPropertyName) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (metricPropertyName != null && metricPropertyName.length() > 0) {
            if (!metricPropertyName.startsWith("{")) {
                map.put("arguments", metricPropertyName);
            } else {
                String[] argsRegex = metricPropertyName.substring(1).split("\\}\\|", 2);
                if (argsRegex.length != 2) {
                    LOG.error((Object)("Invalid metric property [" + metricPropertyName + "] - metric will not be collected"));
                    return null;
                }
                if (!this.isValidRegularExpression(argsRegex[1])) {
                    LOG.error((Object)("Invalid regex [" + argsRegex[1] + "] for metric property [" + metricPropertyName + "] - metric will not be collected"));
                    return null;
                }
                if (argsRegex[0].length() > 0) {
                    map.put("arguments", argsRegex[0]);
                }
                if (argsRegex[1].length() > 0) {
                    map.put(METRIC_PROPERTY_REGEX, argsRegex[1]);
                }
            }
        }
        return map;
    }

    public OperationResult invokeOperation(String name, Configuration configuration) throws Exception {
        long waitTime;
        OperationResult result = new OperationResult();
        String arguments = configuration.getSimpleValue("arguments", null);
        String waitTimeStr = configuration.getSimpleValue(OPERATION_PARAM_WAIT_TIME, null);
        String captureOutputStr = configuration.getSimpleValue(OPERATION_PARAM_CAPTURE_OUTPUT, null);
        String killOnTimeoutStr = configuration.getSimpleValue(OPERATION_PARAM_KILL_ON_TIMEOUT, null);
        if (waitTimeStr != null) {
            try {
                waitTime = Long.parseLong(waitTimeStr);
                waitTime *= 1000L;
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Wait time parameter value is invalid: " + waitTimeStr);
            }
        } else {
            waitTime = 3600000L;
        }
        boolean captureOutput = captureOutputStr == null || Boolean.parseBoolean(captureOutputStr);
        boolean killOnTimeout = killOnTimeoutStr == null || Boolean.parseBoolean(killOnTimeoutStr);
        ProcessExecutionResults exeResults = this.executeExecutable(arguments, waitTime, captureOutput, killOnTimeout);
        Integer exitcode = exeResults.getExitCode();
        String output = exeResults.getCapturedOutput();
        Throwable error = exeResults.getError();
        if (error != null) {
            result.setErrorMessage(ThrowableUtil.getAllMessages((Throwable)error));
        }
        Configuration resultsConfig = result.getComplexResults();
        if (exitcode != null) {
            resultsConfig.put((Property)new PropertySimple(OPERATION_RESULT_EXITCODE, (Object)exitcode));
        }
        if (output != null) {
            resultsConfig.put((Property)new PropertySimple(OPERATION_RESULT_OUTPUT, (Object)output.trim()));
        }
        return result;
    }

    protected ResourceContext getResourcContext() {
        return this.resourceContext;
    }

    protected ProcessExecutionResults executeExecutable(String args, long wait, boolean captureOutput) {
        return this.executeExecutable(args, wait, captureOutput, true);
    }

    protected ProcessExecutionResults executeExecutable(String args, long wait, boolean captureOutput, boolean killOnTimeout) throws InvalidPluginConfigurationException {
        SystemInfo sysInfo = this.resourceContext.getSystemInformation();
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        ProcessExecutionResults results = ScriptServerComponent.executeExecutable(sysInfo, pluginConfig, args, wait, captureOutput, killOnTimeout, this.escapeChar);
        if (LOG.isDebugEnabled()) {
            this.logDebug("CLI results: exitcode=[" + results.getExitCode() + "]; error=[" + results.getError() + "]; output=" + this.truncateString(results.getCapturedOutput()));
        }
        return results;
    }

    protected static char getConfiguredEscapeCharacter(Configuration pluginConfiguration) {
        char escapeChar = '\u0000';
        String attributeString = pluginConfiguration.getSimpleValue(PLUGINCONFIG_QUOTING_ENABLED);
        if (StringUtil.isBlank((String)attributeString) || Boolean.TRUE.toString().equalsIgnoreCase(attributeString)) {
            String ec = pluginConfiguration.getSimpleValue(PLUGINCONFIG_ESCAPE_CHARACTER, "\\");
            escapeChar = ec.charAt(0);
        }
        return escapeChar;
    }

    protected static ProcessExecutionResults executeExecutable(SystemInfo sysInfo, Configuration pluginConfig, String args, long wait, boolean captureOutput, char escapeChar) throws InvalidPluginConfigurationException {
        return ScriptServerComponent.executeExecutable(sysInfo, pluginConfig, args, wait, captureOutput, true, escapeChar);
    }

    private static ProcessExecutionResults executeExecutable(SystemInfo sysInfo, Configuration pluginConfig, String args, long wait, boolean captureOutput, boolean killOnTimeout, char escapeChar) throws InvalidPluginConfigurationException {
        ProcessExecution processExecution = ScriptServerComponent.getProcessExecutionInfo(pluginConfig);
        if (args != null) {
            if (ScriptServerComponent.isQuotingEnabled(escapeChar)) {
                processExecution.setArguments(ScriptArgumentParser.parse(args, escapeChar));
            } else {
                processExecution.setArguments(args.split(" "));
            }
        }
        processExecution.setCaptureOutput(captureOutput);
        processExecution.setWaitForCompletion(wait);
        processExecution.setKillOnTimeout(killOnTimeout);
        ProcessExecutionResults results = sysInfo.executeProcess(processExecution);
        return results;
    }

    private boolean checkAvailability() throws InvalidPluginConfigurationException {
        String executable;
        boolean availExecuteCheck = false;
        String availArgs = null;
        String availExitCodeRegex = null;
        Pattern availOutputRegex = null;
        try {
            Configuration pc = this.resourceContext.getPluginConfiguration();
            executable = pc.getSimpleValue(PLUGINCONFIG_EXECUTABLE, null);
            if (executable == null) {
                throw new Exception("Missing executable in plugin configuraton");
            }
            PropertySimple availExecuteCheckProp = pc.getSimple(PLUGINCONFIG_AVAIL_EXECUTE_CHECK);
            PropertySimple availArgsProp = pc.getSimple(PLUGINCONFIG_AVAIL_ARGS);
            PropertySimple availExitCodeRegexProp = pc.getSimple(PLUGINCONFIG_AVAIL_EXITCODE_REGEX);
            PropertySimple availOutputRegexProp = pc.getSimple(PLUGINCONFIG_AVAIL_OUTPUT_REGEX);
            if (availExecuteCheckProp != null && availExecuteCheckProp.getBooleanValue() != null) {
                availExecuteCheck = availExecuteCheckProp.getBooleanValue();
            }
            if (availArgsProp != null && availArgsProp.getStringValue() != null) {
                availArgs = availArgsProp.getStringValue();
            }
            if (availExitCodeRegexProp != null && availExitCodeRegexProp.getStringValue() != null) {
                availExitCodeRegex = availExitCodeRegexProp.getStringValue();
            }
            if (availOutputRegexProp != null && availOutputRegexProp.getStringValue() != null) {
                availOutputRegex = Pattern.compile(availOutputRegexProp.getStringValue());
            }
        }
        catch (Exception e) {
            throw new InvalidPluginConfigurationException("Cannot get avail plugin config. Cause: " + e);
        }
        File executableFile = new File(executable);
        if (!executableFile.exists()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("The executable [" + executable + "] does not exist - resource is considered DOWN");
            }
            return false;
        }
        if (availExecuteCheck || availExitCodeRegex != null || availOutputRegex != null) {
            String output;
            boolean outputMatches;
            ProcessExecutionResults results = this.executeExecutable(availArgs, 3000L, availOutputRegex != null);
            if (results.getError() != null) {
                if (LOG.isDebugEnabled()) {
                    this.logDebug("CLI execution encountered an error, resource is considered DOWN: " + ThrowableUtil.getAllMessages((Throwable)results.getError()));
                }
                return false;
            }
            if (availExitCodeRegex != null) {
                if (results.getExitCode() == null) {
                    if (LOG.isDebugEnabled()) {
                        this.logDebug("Cannot get exit code, resource is considered DOWN");
                    }
                    return false;
                }
                boolean exitcodeMatches = results.getExitCode().toString().matches(availExitCodeRegex);
                if (!exitcodeMatches) {
                    if (LOG.isDebugEnabled()) {
                        this.logDebug("CLI exit code=[" + results.getExitCode() + "] != [" + availExitCodeRegex + "]. DOWN");
                    }
                    return false;
                }
            }
            if (availOutputRegex != null && !(outputMatches = availOutputRegex.matcher(output = (output = results.getCapturedOutput()) == null ? "" : output.trim()).find())) {
                if (LOG.isDebugEnabled()) {
                    this.logDebug("CLI output [" + this.truncateString(output) + "] did not match regex [" + availOutputRegex + "], resource is considered DOWN");
                }
                return false;
            }
        }
        return true;
    }

    private String truncateString(String output) {
        String outputToLog = output;
        if (outputToLog != null && outputToLog.length() > 100) {
            outputToLog = outputToLog.substring(0, 100) + "...";
        }
        return outputToLog;
    }

    private static ProcessExecution getProcessExecutionInfo(Configuration pluginConfig) throws InvalidPluginConfigurationException {
        PropertySimple executableProp = pluginConfig.getSimple(PLUGINCONFIG_EXECUTABLE);
        PropertySimple workingDirProp = pluginConfig.getSimple(PLUGINCONFIG_WORKINGDIR);
        PropertyList envvarsProp = pluginConfig.getList(PLUGINCONFIG_ENVVARS);
        String workingDir = null;
        HashMap<String, String> envvars = null;
        if (executableProp == null) {
            throw new InvalidPluginConfigurationException("Missing required plugin config: executable");
        }
        String executable = executableProp.getStringValue();
        if (executable == null || executable.length() == 0) {
            throw new InvalidPluginConfigurationException("Bad plugin config: executable");
        }
        if (workingDirProp != null && (workingDir = workingDirProp.getStringValue()) != null && workingDir.length() == 0) {
            workingDir = null;
        }
        if (envvarsProp != null) {
            try {
                List listOfMaps = envvarsProp.getList();
                if (listOfMaps.size() > 0) {
                    envvars = new HashMap<String, String>();
                    for (Property envvarMap : listOfMaps) {
                        PropertySimple name = (PropertySimple)((PropertyMap)envvarMap).get(PLUGINCONFIG_ENVVAR_NAME);
                        PropertySimple value = (PropertySimple)((PropertyMap)envvarMap).get(PLUGINCONFIG_ENVVAR_VALUE);
                        envvars.put(name.getStringValue(), value.getStringValue());
                    }
                }
            }
            catch (Exception e) {
                throw new InvalidPluginConfigurationException("Bad plugin config: environmentVariables. Cause: " + e);
            }
        }
        ProcessExecution processExecution = new ProcessExecution(executable);
        processExecution.setEnvironmentVariables(envvars);
        processExecution.setWorkingDirectory(workingDir);
        return processExecution;
    }

    private boolean isValidRegularExpression(String regex) {
        try {
            Pattern.compile(regex);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void logDebug(String msg) {
        LOG.debug((Object)("[" + this.resourceContext.getResourceKey() + "]: " + msg));
    }

    private static boolean isQuotingEnabled(char escapeChar) {
        return escapeChar != '\u0000';
    }
}

