/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.database.PooledConnectionProvider;
import org.rhq.plugins.postgres.PostgresServerComponent;

public class PostgresUserDiscoveryComponent
implements ResourceDiscoveryComponent<PostgresServerComponent<?>>,
ResourceUpgradeFacet<PostgresServerComponent<?>> {
    private static final Log LOG = LogFactory.getLog(PostgresUserDiscoveryComponent.class);
    static final String OID_PREFIX = "oid: ";
    static final String FIND_ALL_ROLES = "select * from pg_roles";
    static final String FIND_ROLE_BY_NAME = "select * from pg_roles where rolname = ?";
    @Deprecated
    public static final String USERS_QUERY = "select * from pg_roles";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<PostgresServerComponent<?>> context) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Discovering postgres users for " + ((PostgresServerComponent)context.getParentResourceComponent()).getJDBCUrl() + "..."));
        }
        HashSet<DiscoveredResourceDetails> discoveredUsers = new HashSet<DiscoveredResourceDetails>();
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = ((PostgresServerComponent)context.getParentResourceComponent()).getPooledConnectionProvider().getPooledConnection();
            statement = connection.prepareStatement("select * from pg_roles");
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                long userOid = resultSet.getLong("oid");
                String userName = resultSet.getString("rolname");
                DiscoveredResourceDetails service = new DiscoveredResourceDetails(context.getResourceType(), PostgresUserDiscoveryComponent.createResourceKey(userOid), userName, null, "A Postgres user", null, null);
                discoveredUsers.add(service);
            }
        }
        catch (Throwable throwable) {
            DatabasePluginUtil.safeClose((Connection)connection, statement, resultSet);
            throw throwable;
        }
        DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        return discoveredUsers;
    }

    static String createResourceKey(long userOid) {
        return OID_PREFIX + userOid;
    }

    public ResourceUpgradeReport upgrade(ResourceUpgradeContext<PostgresServerComponent<?>> inventoriedResource) {
        String currentResourceKey = inventoriedResource.getResourceKey();
        if (!currentResourceKey.startsWith(OID_PREFIX)) {
            ResourceUpgradeReport report = new ResourceUpgradeReport();
            try {
                long userOid = PostgresUserDiscoveryComponent.getUserOid(currentResourceKey, ((PostgresServerComponent)inventoriedResource.getParentResourceComponent()).getPooledConnectionProvider());
                if (userOid == -1L) {
                    LOG.warn((Object)("Could not find oid of user [" + currentResourceKey + "]"));
                    return null;
                }
                report.setNewResourceKey(PostgresUserDiscoveryComponent.createResourceKey(userOid));
                return report;
            }
            catch (SQLException e) {
                LOG.warn((Object)("Exception thrown while searching oid of user [" + currentResourceKey + "]"), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getUserOid(String user, PooledConnectionProvider pooledConnectionProvider) throws SQLException {
        ResultSet resultSet;
        PreparedStatement statement;
        Connection connection;
        block3: {
            long l;
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = pooledConnectionProvider.getPooledConnection();
                statement = connection.prepareStatement(FIND_ROLE_BY_NAME);
                statement.setString(1, user);
                resultSet = statement.executeQuery();
                if (!resultSet.next()) break block3;
                l = resultSet.getLong("oid");
            }
            catch (Throwable throwable) {
                DatabasePluginUtil.safeClose((Connection)connection, statement, resultSet);
                throw throwable;
            }
            DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement, (ResultSet)resultSet);
            return l;
        }
        long l = -1L;
        DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        return l;
    }
}

