/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.util.StringUtil;
import org.rhq.plugins.database.ConnectionPoolingSupport;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.database.DatabaseQueryUtility;
import org.rhq.plugins.database.PooledConnectionProvider;
import org.rhq.plugins.postgres.PostgresDatabaseComponent;

public class PostgresTableComponent
implements DatabaseComponent<PostgresDatabaseComponent>,
ConnectionPoolingSupport,
MeasurementFacet,
ConfigurationFacet,
DeleteResourceFacet,
OperationFacet {
    private static final Log LOG = LogFactory.getLog(PostgresTableComponent.class);
    private static final String TABLE_EXISTS_QUERY = "select 1 from pg_stat_user_tables where schemaname = ? and relname = ?";
    private static final String TABLE_STATS_QUERY = "select ts.*,  pg_relation_size(ts.relid) AS table_size, pg_total_relation_size(ts.relid) AS total_size, ios.heap_blks_read, ios.heap_blks_hit, ios.idx_blks_read, ios.idx_blks_hit, ios.toast_blks_read, ios.toast_blks_hit, ios.tidx_blks_read, ios.tidx_blks_hit from pg_stat_user_tables ts left join pg_statio_user_tables ios on ts.relid = ios.relid where ts.schemaname = ? and ts.relname = ?";
    private static final String TABLE_ROW_COUNT_APPROX_QUERY = "select pgc.reltuples from pg_class pgc, pg_namespace pgn where pgn.nspname = ? and pgc.relname = ? and pgc.relnamespace = pgn.oid";
    @Deprecated
    public static final String PG_STAT_USER_TABLES_QUERY = "SELECT ts.*,  pg_relation_size(ts.relid) AS table_size, pg_total_relation_size(ts.relid) AS total_size, \n  ios.heap_blks_read, ios.heap_blks_hit, ios.idx_blks_read, ios.idx_blks_hit, \n  ios.toast_blks_read, ios.toast_blks_hit, ios.tidx_blks_read, ios.tidx_blks_hit \nFROM pg_stat_user_tables ts LEFT JOIN pg_statio_user_tables ios on ts.relid = ios.relid \nWHERE ts.relname = ?";
    @Deprecated
    public static final String PG_COUNT_ROWS = "SELECT COUNT(*) FROM ";
    @Deprecated
    public static final String PG_COUNT_ROWS_APPROX = "SELECT reltuples FROM pg_class WHERE relname = ? ";
    private ResourceContext<PostgresDatabaseComponent> resourceContext;

    public void start(ResourceContext<PostgresDatabaseComponent> context) {
        if (!context.getResourceKey().contains(".")) {
            throw new InvalidPluginConfigurationException("Resource key in old format (missing schema name)");
        }
        if (StringUtil.isBlank((String)PostgresTableComponent.getSchemaNameFromContext(context))) {
            throw new InvalidPluginConfigurationException("schemaName is not defined");
        }
        if (StringUtil.isBlank((String)PostgresTableComponent.getTableNameFromContext(context))) {
            throw new InvalidPluginConfigurationException("tableName is not defined");
        }
        try {
            if (!this.tableExists(context)) {
                throw new InvalidPluginConfigurationException("table does not exist");
            }
        }
        catch (SQLException e) {
            throw new InvalidPluginConfigurationException("Exception while checking table existence", (Throwable)e);
        }
        this.resourceContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists(ResourceContext<PostgresDatabaseComponent> context) throws SQLException {
        boolean bl;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = ((PostgresDatabaseComponent)context.getParentResourceComponent()).getPooledConnectionProvider().getPooledConnection();
            statement = connection.prepareStatement(TABLE_EXISTS_QUERY);
            statement.setString(1, PostgresTableComponent.getSchemaNameFromContext(context));
            statement.setString(2, PostgresTableComponent.getTableNameFromContext(context));
            resultSet = statement.executeQuery();
            bl = resultSet.next();
        }
        catch (Throwable throwable) {
            DatabasePluginUtil.safeClose((Connection)connection, statement, resultSet);
            throw throwable;
        }
        DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        return bl;
    }

    public void stop() {
        this.resourceContext = null;
    }

    public boolean supportsConnectionPooling() {
        return true;
    }

    public PooledConnectionProvider getPooledConnectionProvider() {
        return ((PostgresDatabaseComponent)this.resourceContext.getParentResourceComponent()).getPooledConnectionProvider();
    }

    public String getSchemaName() {
        return PostgresTableComponent.getSchemaNameFromContext(this.resourceContext);
    }

    public String getTableName() {
        return PostgresTableComponent.getTableNameFromContext(this.resourceContext);
    }

    public AvailabilityType getAvailability() {
        try {
            return this.tableExists(this.resourceContext) ? AvailabilityType.UP : AvailabilityType.DOWN;
        }
        catch (SQLException e) {
            LOG.debug((Object)"Exception while checking table existence", (Throwable)e);
            return AvailabilityType.UNKNOWN;
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        String tableName = PostgresTableComponent.getTableNameFromContext(this.resourceContext);
        String schemaName = PostgresTableComponent.getSchemaNameFromContext(this.resourceContext);
        Map results = DatabasePluginUtil.getNumericQueryValues((ResourceComponent)this, (String)TABLE_STATS_QUERY, (Object[])new Object[]{schemaName, tableName});
        for (MeasurementScheduleRequest request : requests) {
            String metricName = request.getName();
            Double value = metricName.equals("rows") ? DatabasePluginUtil.getSingleNumericQueryValue((ResourceComponent)this, (String)this.getCountQuery(schemaName, tableName), (Object[])new Object[0]) : (metricName.equals("rows_approx") ? DatabasePluginUtil.getSingleNumericQueryValue((ResourceComponent)this, (String)TABLE_ROW_COUNT_APPROX_QUERY, (Object[])new Object[]{schemaName, tableName}) : (Double)results.get(metricName));
            if (value == null) continue;
            MeasurementDataNumeric mdn = new MeasurementDataNumeric(request, value);
            report.addData(mdn);
        }
    }

    private String getCountQuery(String schemaName, String tableName) {
        return "select count(1) from " + this.getFullyQualifiedTableName(schemaName, PostgresTableComponent.getQuoted(tableName));
    }

    private String getFullyQualifiedTableName(String schemaName, String tableName) {
        return schemaName + "." + tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResource() throws Exception {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getPooledConnectionProvider().getPooledConnection();
            statement = connection.prepareStatement("drop table " + this.getFullyQualifiedTableName(PostgresTableComponent.getSchemaNameFromContext(this.resourceContext), PostgresTableComponent.getQuoted(PostgresTableComponent.getTableNameFromContext(this.resourceContext))));
            statement.executeUpdate();
        }
        catch (Throwable throwable) {
            DatabasePluginUtil.safeClose((Connection)connection, statement);
            throw throwable;
        }
        DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration loadResourceConfiguration() throws Exception {
        Configuration config = new Configuration();
        config.put((Property)new PropertySimple("schemaName", (Object)this.resourceContext.getPluginConfiguration().getSimple("schemaName").getStringValue()));
        config.put((Property)new PropertySimple("tableName", (Object)this.resourceContext.getPluginConfiguration().getSimple("tableName").getStringValue()));
        Connection connection = null;
        try {
            connection = ((PostgresDatabaseComponent)this.resourceContext.getParentResourceComponent()).getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet columns = databaseMetaData.getColumns("", PostgresTableComponent.getSchemaNameFromContext(this.resourceContext), PostgresTableComponent.getTableNameFromContext(this.resourceContext), "");
            PropertyList columnList = new PropertyList("columns");
            while (columns.next()) {
                PropertyMap col = new PropertyMap("columnDefinition");
                col.put((Property)new PropertySimple("columnName", (Object)columns.getString("COLUMN_NAME")));
                col.put((Property)new PropertySimple("columnType", (Object)columns.getString("TYPE_NAME")));
                col.put((Property)new PropertySimple("columnLength", (Object)columns.getInt("COLUMN_SIZE")));
                col.put((Property)new PropertySimple("columnPrecision", (Object)columns.getInt("DECIMAL_DIGITS")));
                col.put((Property)new PropertySimple("columnDefault", (Object)columns.getString("COLUMN_DEF")));
                col.put((Property)new PropertySimple("columnNullable", (Object)PostgresTableComponent.isNullableToBoolean(columns.getInt("NULLABLE"))));
                columnList.add((Property)col);
            }
            config.put((Property)columnList);
        }
        catch (Throwable throwable) {
            DatabasePluginUtil.safeClose(connection);
            throw throwable;
        }
        DatabasePluginUtil.safeClose((Connection)connection);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        try {
            Configuration updatedConfiguration = report.getConfiguration();
            PropertyList updatedColumns = updatedConfiguration.getList("columns");
            Connection connection = ((PostgresDatabaseComponent)this.resourceContext.getParentResourceComponent()).getConnection();
            DatabaseMetaData dmd = connection.getMetaData();
            ResultSet rs = dmd.getColumns("", "", PostgresTableComponent.getTableNameFromContext(this.resourceContext), "");
            HashMap<String, ColumnDefinition> existingDefs = new HashMap<String, ColumnDefinition>();
            try {
                while (rs.next()) {
                    ColumnDefinition def = new ColumnDefinition(rs);
                    existingDefs.put(def.columnName, def);
                }
            }
            finally {
                rs.close();
            }
            for (Property newColumnDefinition : updatedColumns.getList()) {
                boolean columnDefaultChanged;
                boolean columnPrecisionChanged;
                PropertyMap colDef = (PropertyMap)newColumnDefinition;
                ColumnDefinition existingDef = (ColumnDefinition)existingDefs.get(colDef.getSimple("columnName").getStringValue());
                ColumnDefinition newDef = new ColumnDefinition(colDef);
                if (existingDef == null) {
                    String sql = "ALTER TABLE " + PostgresTableComponent.getQuoted(PostgresTableComponent.getTableNameFromContext(this.resourceContext)) + " ADD COLUMN " + newDef.getColumnSql();
                    if (DatabaseQueryUtility.executeUpdate((DatabaseComponent)this, (String)sql, (Object[])new Object[0]) == 0) continue;
                    throw new RuntimeException("Couldn't add column using SQL: " + sql);
                }
                existingDefs.remove(existingDef.columnName);
                boolean columnLengthChanged = existingDef.columnLength != null && !existingDef.columnLength.equals(newDef.columnLength) || existingDef.columnLength == null && existingDef.columnLength != null;
                boolean bl = columnPrecisionChanged = existingDef.columnPrecision != null && !existingDef.columnPrecision.equals(newDef.columnPrecision) || existingDef.columnPrecision == null && existingDef.columnPrecision != null;
                if (!existingDef.columnType.equals(newDef.columnType) || columnLengthChanged || columnPrecisionChanged) {
                    String sql = "ALTER TABLE " + PostgresTableComponent.getQuoted(PostgresTableComponent.getTableNameFromContext(this.resourceContext)) + " ALTER COLUMN " + PostgresTableComponent.getQuoted(newDef.columnName) + " TYPE " + newDef.columnType;
                    if (newDef.columnLength != null) {
                        sql = sql + " ( " + newDef.columnLength;
                        if (newDef.columnPrecision != null && !newDef.columnType.startsWith("varchar")) {
                            sql = sql + ", " + newDef.columnPrecision;
                        }
                        sql = sql + " ) ";
                    }
                    if (DatabaseQueryUtility.executeUpdate((DatabaseComponent)this, (String)sql, (Object[])new Object[0]) != 1) {
                        throw new RuntimeException("Couldn't alter column type using SQL: " + sql);
                    }
                }
                if (!(columnDefaultChanged = existingDef.columnDefault != null && !existingDef.columnDefault.equals(newDef.columnDefault) || existingDef.columnDefault == null && newDef.columnDefault != null)) continue;
                String sql = "ALTER TABLE " + PostgresTableComponent.getQuoted(PostgresTableComponent.getTableNameFromContext(this.resourceContext)) + " ALTER COLUMN " + PostgresTableComponent.getQuoted(newDef.columnName);
                sql = newDef.columnDefault == null ? sql + " DROP DEFAULT" : sql + " SET DEFAULT " + newDef.columnDefault;
                if (DatabaseQueryUtility.executeUpdate((DatabaseComponent)this, (String)sql, (Object[])new Object[0]) == 1) continue;
                throw new RuntimeException("Couldn't update column default using SQL: " + sql);
            }
            for (ColumnDefinition def : existingDefs.values()) {
                DatabaseQueryUtility.executeUpdate((DatabaseComponent)this, (String)("ALTER TABLE " + PostgresTableComponent.getQuoted(PostgresTableComponent.getTableNameFromContext(this.resourceContext)) + " DROP COLUMN " + PostgresTableComponent.getQuoted(def.columnName)), (Object[])new Object[0]);
            }
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (SQLException e) {
            report.setErrorMessageFromThrowable((Throwable)e);
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
        }
    }

    public Connection getConnection() {
        return ((PostgresDatabaseComponent)this.resourceContext.getParentResourceComponent()).getConnection();
    }

    public void removeConnection() {
        ((PostgresDatabaseComponent)this.resourceContext.getParentResourceComponent()).removeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if ("vacuum".equals(name)) {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.getPooledConnectionProvider().getPooledConnection();
                statement = connection.prepareStatement("vacuum " + this.getFullyQualifiedTableName(PostgresTableComponent.getSchemaNameFromContext(this.resourceContext), PostgresTableComponent.getQuoted(PostgresTableComponent.getTableNameFromContext(this.resourceContext))));
                statement.executeUpdate();
            }
            catch (Throwable throwable) {
                DatabasePluginUtil.safeClose((Connection)connection, statement);
                throw throwable;
            }
            DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement);
        }
        return null;
    }

    private static String getSchemaNameFromContext(ResourceContext<PostgresDatabaseComponent> resourceContext) {
        return resourceContext.getPluginConfiguration().getSimpleValue("schemaName");
    }

    private static String getTableNameFromContext(ResourceContext<PostgresDatabaseComponent> resourceContext) {
        return resourceContext.getPluginConfiguration().getSimpleValue("tableName");
    }

    private static String getQuoted(String s) {
        return "\"" + s + "\"";
    }

    private static boolean isNullableToBoolean(int isNullable) {
        return isNullable != 0;
    }

    static class ColumnDefinition {
        String columnName;
        String columnType;
        Integer columnLength;
        Integer columnPrecision;
        String columnDefault;
        boolean columnNullable;

        public ColumnDefinition(ResultSet rs) throws SQLException {
            this.columnName = rs.getString("COLUMN_NAME");
            this.columnType = rs.getString("TYPE_NAME");
            this.columnLength = rs.getInt("COLUMN_SIZE");
            this.columnPrecision = rs.getInt("DECIMAL_DIGITS");
            this.columnDefault = rs.getString("COLUMN_DEF");
            this.columnNullable = PostgresTableComponent.isNullableToBoolean(rs.getInt("NULLABLE"));
        }

        public ColumnDefinition(PropertyMap column) {
            this.columnName = column.getSimple("columnName").getStringValue();
            this.columnType = column.getSimple("columnType").getStringValue();
            this.columnLength = column.getSimple("columnLength") == null ? null : column.getSimple("columnLength").getIntegerValue();
            this.columnPrecision = column.getSimple("columnPrecision") == null ? null : column.getSimple("columnPrecision").getIntegerValue();
            this.columnDefault = column.getSimple("columnDefault") == null ? null : column.getSimple("columnDefault").getStringValue();
            this.columnNullable = column.getSimple("columnNullable") != null && column.getSimple("columnNullable").getBooleanValue() != null && column.getSimple("columnNullable").getBooleanValue() != false;
        }

        public String getColumnSql() {
            StringBuilder buf = new StringBuilder();
            buf.append(PostgresTableComponent.getQuoted(this.columnName)).append(" ").append(this.columnType);
            if (!this.isArrayColumnType(this.columnType)) {
                if (this.columnLength != null) {
                    buf.append("(").append(this.columnLength).append(")");
                }
                if (this.columnPrecision != null) {
                    buf.append("(").append(this.columnPrecision).append(")");
                }
            }
            if (this.columnDefault != null) {
                buf.append(" DEFAULT ").append(this.columnDefault);
            }
            if (!this.columnNullable) {
                buf.append(" NOT NULL");
            }
            return buf.toString();
        }

        private boolean isArrayColumnType(String columnType) {
            return columnType != null && columnType.trim().endsWith("[]");
        }
    }
}

