/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.system.AggregateProcessInfo;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.database.ConnectionPoolingSupport;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.database.PooledConnectionProvider;
import org.rhq.plugins.postgres.PostgresDiscoveryComponent;
import org.rhq.plugins.postgres.PostgresPooledConnectionProvider;
import org.rhq.plugins.postgres.PostgresUserComponent;
import org.rhq.plugins.postgres.PostgresUserDiscoveryComponent;
import org.rhq.plugins.postgres.util.PostgresqlConfFile;

public class PostgresServerComponent<T extends ResourceComponent<?>>
implements DatabaseComponent<T>,
ConnectionPoolingSupport,
ConfigurationFacet,
MeasurementFacet,
OperationFacet,
CreateChildResourceFacet {
    private static final Log LOG = LogFactory.getLog(PostgresServerComponent.class);
    private static final String METRIC_RUNTIME_PREFIX = "Runtime.";
    private static final String FIND_STAT_ACTIVITY = "select pid, usename, query, state, client_addr, client_port from pg_stat_activity order by pid asc";
    private static final String FIND_STAT_ACTIVITY_PRE_PG_9_2 = "select procpid as pid, usename, current_query as query, (case when current_query='<IDLE>' then 'idle' else 'active' end) as state, client_addr, client_port from pg_stat_activity order by pid asc";
    static final String DEFAULT_CONFIG_FILE_NAME = "postgresql.conf";
    private AggregateProcessInfo aggregateProcessInfo;
    @Deprecated
    private Connection connection;
    private ResourceContext resourceContext;
    private PostgresPooledConnectionProvider pooledConnectionProvider;
    private static final String[] CONFIG_FILE_PROPERTIES = new String[]{"port", "max_connections", "shared_buffers", "max_fsm_pages", "log_destination", "redirect_stderr", "stats_start_collector", "stats_block_level", "stats_row_level", "autovacuum"};

    public void start(ResourceContext context) throws Exception {
        this.resourceContext = context;
        this.buildSharedConnectionIfNeeded();
        try {
            this.pooledConnectionProvider = new PostgresPooledConnectionProvider(this.resourceContext.getPluginConfiguration());
        }
        catch (SQLException e) {
            SQLException cause;
            if (e.getCause() instanceof SQLException && "28P01".equals((cause = (SQLException)e.getCause()).getSQLState())) {
                throw new InvalidPluginConfigurationException("Invalid password");
            }
            throw new InvalidPluginConfigurationException("Cannot open database connection", (Throwable)e);
        }
        ProcessInfo processInfo = this.resourceContext.getNativeProcess();
        if (processInfo != null) {
            this.aggregateProcessInfo = processInfo.getAggregateProcessTree();
        } else {
            this.findProcessInfo();
        }
        File configFile = this.getConfigurationFileObject();
        if (!configFile.exists()) {
            LOG.warn((Object)("PostgreSQL configuration file [" + configFile + "] does not exist or is not readable. " + "Make sure the user the RHQ Agent is running as has read permissions on the file " + "and its parent directory."));
        } else if (!configFile.canRead()) {
            LOG.warn((Object)("PostgreSQL configuration file [" + configFile + "] is not readable. " + "Make sure the user the RHQ Agent is running as has read permissions on the file."));
        }
    }

    public void stop() {
        this.resourceContext = null;
        DatabasePluginUtil.safeClose((Connection)this.connection);
        this.connection = null;
        this.pooledConnectionProvider.close();
        this.pooledConnectionProvider = null;
        this.aggregateProcessInfo = null;
    }

    public boolean supportsConnectionPooling() {
        return true;
    }

    public PooledConnectionProvider getPooledConnectionProvider() {
        return this.pooledConnectionProvider;
    }

    protected String getJDBCUrl() {
        return PostgresDiscoveryComponent.buildUrl(this.resourceContext.getPluginConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        Connection jdbcConnection = null;
        try {
            jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
            AvailabilityType availabilityType = jdbcConnection.isValid(1) ? AvailabilityType.UP : AvailabilityType.DOWN;
            return availabilityType;
        }
        catch (SQLException e) {
            AvailabilityType availabilityType = AvailabilityType.DOWN;
            return availabilityType;
        }
        finally {
            DatabasePluginUtil.safeClose((Connection)jdbcConnection);
        }
    }

    ResourceContext getResourceContext() {
        return this.resourceContext;
    }

    public Connection getConnection() {
        this.buildSharedConnectionIfNeeded();
        return this.connection;
    }

    private void buildSharedConnectionIfNeeded() {
        block3: {
            try {
                if (this.connection == null || this.connection.isClosed()) {
                    this.connection = PostgresDiscoveryComponent.buildConnection(this.resourceContext.getPluginConfiguration(), true);
                }
            }
            catch (SQLException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)"Could not build shared connection", (Throwable)e);
            }
        }
    }

    public void removeConnection() {
        DatabasePluginUtil.safeClose((Connection)this.connection);
        this.connection = null;
    }

    protected PostgresqlConfFile getConfigurationFile() throws IOException {
        File configFile = this.getConfigurationFileObject();
        return new PostgresqlConfFile(configFile);
    }

    private File getConfigurationFileObject() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String dataDirPath = pluginConfig.getSimpleValue("pgdataDir", null);
        String configFilePath = pluginConfig.getSimpleValue("configFile", null);
        return configFilePath != null ? new File(configFilePath) : new File(dataDirPath, DEFAULT_CONFIG_FILE_NAME);
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration config = new Configuration();
        ConfigurationDefinition configDef = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
        PostgresqlConfFile confFile = this.getConfigurationFile();
        for (String propName : CONFIG_FILE_PROPERTIES) {
            String value = confFile.getProperty(propName);
            PropertyDefinitionSimple propDef = configDef.getPropertyDefinitionSimple(propName);
            PropertySimple prop = this.createProperty(value, propDef);
            config.put((Property)prop);
        }
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        try {
            ConfigurationDefinition def = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (PropertySimple prop : report.getConfiguration().getSimpleProperties().values()) {
                PropertyDefinitionSimple pd = def.getPropertyDefinitionSimple(prop.getName());
                if (!"configFile".equals(pd.getPropertyGroupDefinition().getName())) continue;
                String value = this.getPostgresParameterValue(prop, pd);
                parameters.put(prop.getName(), value);
            }
            PostgresqlConfFile confFile = this.getConfigurationFile();
            confFile.setProperties(parameters);
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to update postgres configuration file", (Throwable)e);
        }
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) {
        HashMap<String, MeasurementScheduleRequest> runtimePropertiesRequests = new HashMap<String, MeasurementScheduleRequest>(metrics.size());
        for (MeasurementScheduleRequest request : metrics) {
            String metricName = request.getName();
            if (metricName.startsWith("Process.")) {
                if (this.aggregateProcessInfo == null) continue;
                this.aggregateProcessInfo.refresh();
                Object val = this.lookupAttributeProperty(this.aggregateProcessInfo, metricName.substring("Process.".length()));
                if (val == null || !(val instanceof Number)) continue;
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(((Number)val).doubleValue())));
                continue;
            }
            if (metricName.startsWith("Database")) {
                ResultSet resultSet;
                Statement statement;
                Connection jdbcConnection;
                block23: {
                    if (metricName.endsWith("startTime")) {
                        block21: {
                            jdbcConnection = null;
                            statement = null;
                            resultSet = null;
                            try {
                                jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
                                statement = jdbcConnection.createStatement();
                                resultSet = statement.executeQuery("SELECT pg_postmaster_start_time()");
                                if (!resultSet.next()) break block21;
                                report.addData(new MeasurementDataTrait(request, resultSet.getTimestamp(1).toString()));
                            }
                            catch (SQLException e) {
                                block22: {
                                    try {
                                        if (!LOG.isDebugEnabled()) break block22;
                                        LOG.debug((Object)("Can not collect metric: " + metricName + ": " + e.getLocalizedMessage()));
                                    }
                                    catch (Throwable throwable) {
                                        DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement, resultSet);
                                        throw throwable;
                                    }
                                }
                                DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, resultSet);
                                continue;
                            }
                        }
                        DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
                        continue;
                    }
                    if (!metricName.endsWith("backends")) continue;
                    jdbcConnection = null;
                    statement = null;
                    resultSet = null;
                    try {
                        jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
                        statement = jdbcConnection.createStatement();
                        resultSet = statement.executeQuery("select count(*) from pg_stat_activity");
                        if (!resultSet.next()) break block23;
                        report.addData(new MeasurementDataNumeric(request, Double.valueOf(resultSet.getLong(1))));
                    }
                    catch (SQLException e) {
                        block24: {
                            try {
                                if (!LOG.isDebugEnabled()) break block24;
                                LOG.debug((Object)("Can not collect metricName: " + metricName + ": " + e.getLocalizedMessage()));
                            }
                            catch (Throwable throwable) {
                                DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, resultSet);
                                throw throwable;
                            }
                        }
                        DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
                        continue;
                    }
                }
                DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
                continue;
            }
            if (!metricName.startsWith(METRIC_RUNTIME_PREFIX)) continue;
            runtimePropertiesRequests.put(metricName.substring(METRIC_RUNTIME_PREFIX.length()), request);
        }
        if (!runtimePropertiesRequests.isEmpty()) {
            Connection jdbcConnection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
                statement = jdbcConnection.createStatement();
                resultSet = statement.executeQuery("show all");
                block16: while (resultSet.next()) {
                    String runtimeProperty = resultSet.getString("name");
                    if (!runtimePropertiesRequests.containsKey(runtimeProperty)) continue;
                    String setting = resultSet.getString("setting");
                    MeasurementScheduleRequest request = (MeasurementScheduleRequest)runtimePropertiesRequests.get(runtimeProperty);
                    switch (request.getDataType()) {
                        case TRAIT: {
                            report.addData(new MeasurementDataTrait(request, setting));
                            continue block16;
                        }
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Unsupported metric data type: " + request.getName() + ", " + request.getDataType()));
                }
            }
            catch (SQLException e) {
                try {
                    LOG.debug((Object)("Can not collect metrics: " + runtimePropertiesRequests.keySet() + ": " + e.getLocalizedMessage()));
                }
                catch (Throwable throwable) {
                    DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement, resultSet);
                    throw throwable;
                }
                DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
            }
            DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
        }
    }

    protected Object lookupAttributeProperty(Object value, String property) {
        String[] ps;
        block4: {
            ps = property.split("\\.", 2);
            String searchProperty = ps[0];
            try {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(value.getClass()).getPropertyDescriptors()) {
                    if (!pd.getName().equals(searchProperty)) continue;
                    value = pd.getReadMethod().invoke(value, new Object[0]);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)("Unable to read property from measurement attribute [" + searchProperty + "] not found on [" + this.resourceContext.getResourceKey() + "]"));
            }
        }
        if (ps.length > 1) {
            value = this.lookupAttributeProperty(value, ps[1]);
        }
        return value;
    }

    @Deprecated
    public double getObjectProperty(Object object, String name) {
        try {
            BeanInfo info = Introspector.getBeanInfo(object.getClass());
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                if (!pd.getName().equals(name)) continue;
                return ((Number)pd.getReadMethod().invoke(object, new Object[0])).doubleValue();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error occurred while retrieving property '" + name + "' from object [" + object + "]"), (Throwable)e);
        }
        return Double.NaN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if (name.equals("listProcessStatistics")) {
            OperationResult operationResult;
            Connection jdbcConnection = null;
            PreparedStatement statement = null;
            ResultSet resultSet = null;
            try {
                jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
                statement = this.isVersionGreaterThan92(jdbcConnection) ? jdbcConnection.prepareStatement(FIND_STAT_ACTIVITY) : jdbcConnection.prepareStatement(FIND_STAT_ACTIVITY_PRE_PG_9_2);
                resultSet = statement.executeQuery();
                PropertyList procList = new PropertyList("processList");
                while (resultSet.next()) {
                    PropertyMap pm = new PropertyMap("process");
                    pm.put((Property)new PropertySimple("pid", (Object)resultSet.getInt("pid")));
                    pm.put((Property)new PropertySimple("userName", (Object)resultSet.getString("usename")));
                    pm.put((Property)new PropertySimple("query", (Object)resultSet.getString("query")));
                    pm.put((Property)new PropertySimple("state", (Object)resultSet.getString("state")));
                    pm.put((Property)new PropertySimple("address", (Object)resultSet.getString("client_addr")));
                    pm.put((Property)new PropertySimple("port", (Object)resultSet.getInt("client_port")));
                    procList.add((Property)pm);
                }
                OperationResult result = new OperationResult();
                result.getComplexResults().put((Property)procList);
                operationResult = result;
            }
            catch (Throwable throwable) {
                DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement, resultSet);
                throw throwable;
            }
            DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
            return operationResult;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreateResourceReport createResource(CreateResourceReport report) {
        long userOid;
        Configuration userConfig = report.getResourceConfiguration();
        String user = userConfig.getSimpleValue("user");
        if (user == null || user.trim().isEmpty()) {
            report.setStatus(CreateResourceStatus.FAILURE);
            report.setErrorMessage("User name is missing");
            return report;
        }
        Connection jdbcConnection = null;
        PreparedStatement statement = null;
        try {
            jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
            statement = jdbcConnection.prepareStatement(PostgresUserComponent.buildUserSql(userConfig, true));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            CreateResourceReport createResourceReport;
            try {
                report.setStatus(CreateResourceStatus.FAILURE);
                report.setErrorMessage("Failed to create user.");
                report.setException((Throwable)e);
                createResourceReport = report;
            }
            catch (Throwable throwable) {
                DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement);
                throw throwable;
            }
            DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement);
            return createResourceReport;
        }
        DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement);
        String resourceName = report.getUserSpecifiedResourceName();
        if (resourceName == null || resourceName.trim().isEmpty()) {
            resourceName = user;
        }
        report.setResourceName(resourceName);
        try {
            userOid = PostgresUserDiscoveryComponent.getUserOid(user, this.getPooledConnectionProvider());
            report.setResourceKey(PostgresUserDiscoveryComponent.createResourceKey(userOid));
        }
        catch (SQLException e) {
            report.setStatus(CreateResourceStatus.FAILURE);
            report.setErrorMessage("The user has been created but its oid could not be read.");
            report.setException((Throwable)e);
            return report;
        }
        try {
            jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
            statement = jdbcConnection.prepareStatement("update pg_authid set rolcatupdate=? where oid=?");
            statement.setBoolean(1, Boolean.valueOf(userConfig.getSimpleValue("superuser")) != false && Boolean.valueOf(userConfig.getSimpleValue("canModifyCatalogDirectly")) != false);
            statement.setLong(2, userOid);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            report.setStatus(CreateResourceStatus.INVALID_CONFIGURATION);
            report.setErrorMessage("The user has been created but cannot modify system catalogs directly.");
            report.setException((Throwable)e);
            CreateResourceReport createResourceReport = report;
            return createResourceReport;
        }
        finally {
            DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement);
        }
        report.setStatus(CreateResourceStatus.SUCCESS);
        return report;
    }

    private String getPostgresParameterValue(PropertySimple prop, PropertyDefinitionSimple propDef) {
        String value = propDef.getType() == PropertySimpleType.BOOLEAN && prop.getBooleanValue() != null ? (prop.getBooleanValue() != false ? "on" : "off") : prop.getStringValue();
        return value;
    }

    private PropertySimple createProperty(String value, PropertyDefinitionSimple propDef) {
        String jonValue;
        if (propDef.getType() == PropertySimpleType.BOOLEAN && value != null) {
            String lowerCaseValue = value.toLowerCase();
            if ("on".equals(lowerCaseValue) || "true".startsWith(lowerCaseValue) || "yes".startsWith(lowerCaseValue) || "1".equals(lowerCaseValue)) {
                jonValue = Boolean.TRUE.toString();
            } else if ("off".startsWith(lowerCaseValue) && lowerCaseValue.length() != 1 || "false".startsWith(lowerCaseValue) || "no".startsWith(lowerCaseValue) || "0".equals(lowerCaseValue)) {
                jonValue = Boolean.FALSE.toString();
            } else {
                jonValue = propDef.isRequired() ? Boolean.FALSE.toString() : null;
                LOG.warn((Object)("Boolean PostgreSQL configuration parameter '" + propDef.getName() + "' has an invalid value: '" + value + "' - defaulting value to '" + jonValue + "'"));
            }
        } else {
            jonValue = value;
        }
        return new PropertySimple(propDef.getName(), (Object)jonValue);
    }

    public void findProcessInfo() {
        List processes = this.resourceContext.getSystemInformation().getProcesses("process|basename|match=^(?i)(postgres|postmaster)\\.exe$,process|basename|nomatch|parent=^(?i)(postgres|postmaster)\\.exe$");
        processes.addAll(this.resourceContext.getSystemInformation().getProcesses("process|basename|match=^(postgres|postmaster)$,process|basename|nomatch|parent=^(postgres|postmaster)$"));
        for (ProcessInfo processInfo : processes) {
            String pgDataPath = PostgresDiscoveryComponent.getDataDirPath(processInfo);
            if (pgDataPath == null) continue;
            this.aggregateProcessInfo = processInfo.getAggregateProcessTree();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isVersionGreaterThan92() throws SQLException {
        Connection connection = null;
        try {
            connection = this.getPooledConnectionProvider().getPooledConnection();
            boolean bl = this.isVersionGreaterThan92(connection);
            return bl;
        }
        finally {
            DatabasePluginUtil.safeClose((Connection)connection);
        }
    }

    boolean isVersionGreaterThan92(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        return metaData.getDatabaseMajorVersion() >= 9 && metaData.getDatabaseMinorVersion() >= 2;
    }
}

