/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.lang.reflect.Field;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pluginapi.plugin.PluginContext;
import org.rhq.core.pluginapi.plugin.PluginLifecycleListener;
import org.rhq.core.util.exception.ThrowableUtil;

public class PostgresPluginLifecycleListener
implements PluginLifecycleListener {
    private final Log log = LogFactory.getLog(PostgresPluginLifecycleListener.class);

    public void initialize(PluginContext context) throws Exception {
    }

    public void shutdown() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            try {
                Driver driver = drivers.nextElement();
                DriverManager.deregisterDriver(driver);
                this.log.debug((Object)("Deregistered JDBC driver: " + driver.getClass()));
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to deregister JDBC drivers - memory might leak" + ThrowableUtil.getAllMessages((Throwable)e)));
            }
        }
        try {
            this.cleanupDriverTimerThread();
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to clean up Postgresql JDBC driver classloader leak. If this warning appears multiple times during the lifetime of the agent, there's possibility of permgen depletion.", (Throwable)e);
        }
        this.log.debug((Object)(this.getClass().getSimpleName() + " completed shutdown."));
    }

    private void cleanupDriverTimerThread() throws ClassNotFoundException {
        Class<?> driverClass = Class.forName("org.postgresql.Driver");
        try {
            Field cancelTimerField = driverClass.getDeclaredField("cancelTimer");
            cancelTimerField.setAccessible(true);
            Timer cancelTimer = (Timer)cancelTimerField.get(null);
            if (cancelTimer != null) {
                cancelTimer.cancel();
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to shutdown the leaking statement cancellation timer of Postgresql JDBC driver.", e);
        }
    }
}

