/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.service;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.metamodel.EntityType;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.service.jta.platform.internal.JBossAppServerJtaPlatform;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;
import org.wildfly.extension.picketlink.PicketLinkLogger;
import org.wildfly.extension.picketlink.PicketLinkMessages;
import org.wildfly.extension.picketlink.idm.config.JPAStoreSubsystemConfiguration;
import org.wildfly.extension.picketlink.idm.config.JPAStoreSubsystemConfigurationBuilder;

public class JPAIdentityStoreService
implements Service<JPAIdentityStoreService> {
    private static final String JPA_ANNOTATION_PACKAGE = "org.picketlink.idm.jpa.annotations";
    private final JPAStoreSubsystemConfigurationBuilder configurationBuilder;
    private JPAStoreSubsystemConfiguration storeConfig;
    private EntityManagerFactory emf;
    private final InjectedValue<TransactionManager> transactionManager = new InjectedValue();

    public JPAIdentityStoreService(JPAStoreSubsystemConfigurationBuilder configurationBuilder) {
        this.configurationBuilder = configurationBuilder;
    }

    public void start(StartContext startContext) throws StartException {
        this.storeConfig = this.configurationBuilder.create();
        try {
            this.configureEntityManagerFactory();
            this.configureEntities();
        }
        catch (Exception e) {
            throw PicketLinkMessages.MESSAGES.idmJpaStartFailed(e);
        }
        this.configureEntities();
        this.configurationBuilder.addContextInitializer(new ContextInitializer(){

            public void initContextForStore(IdentityContext context, IdentityStore<?> store) {
                if (store instanceof JPAIdentityStore && !context.isParameterSet("CTX_ENTITY_MANAGER")) {
                    context.setParameter("CTX_ENTITY_MANAGER", (Object)JPAIdentityStoreService.this.getEntityManager((TransactionManager)JPAIdentityStoreService.this.getTransactionManager().getValue()));
                }
            }
        });
    }

    public void stop(StopContext stopContext) {
        if (this.storeConfig.getEntityManagerFactoryJndiName() == null) {
            this.emf.close();
        }
    }

    public JPAIdentityStoreService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<TransactionManager> getTransactionManager() {
        return this.transactionManager;
    }

    private void configureEntityManagerFactory() {
        this.emf = this.storeConfig.getEntityManagerFactoryJndiName() != null ? this.lookupEntityManagerFactory() : this.createEmbeddedEntityManagerFactory();
    }

    private EntityManagerFactory lookupEntityManagerFactory() {
        PicketLinkLogger.ROOT_LOGGER.debugf("Looking up EntityManagerFactory from [%s]", this.storeConfig.getEntityManagerFactoryJndiName());
        try {
            return (EntityManagerFactory)new InitialContext().lookup(this.storeConfig.getEntityManagerFactoryJndiName());
        }
        catch (NamingException e) {
            throw PicketLinkMessages.MESSAGES.idmJpaEMFLookupFailed(this.storeConfig.getEntityManagerFactoryJndiName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManagerFactory createEmbeddedEntityManagerFactory() {
        PicketLinkLogger.ROOT_LOGGER.debugf("Creating embedded EntityManagerFactory.", new Object[0]);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            String dataSourceJndiUrl = this.storeConfig.getDataSourceJndiUrl();
            if (!StringUtil.isNullOrEmpty((String)dataSourceJndiUrl)) {
                PicketLinkLogger.ROOT_LOGGER.debugf("Using datasource [%s] for embedded EntityManagerFactory.", dataSourceJndiUrl);
                properties.put("javax.persistence.jtaDataSource", dataSourceJndiUrl);
            }
            properties.put("hibernate.transaction.jta.platform", (String)new JBossAppServerJtaPlatform());
            Module entityModule = this.storeConfig.getEntityModule();
            if (entityModule != null) {
                Thread.currentThread().setContextClassLoader((ClassLoader)entityModule.getClassLoader());
            }
            EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)this.storeConfig.getEntityModuleUnitName(), properties);
            return entityManagerFactory;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private void configureEntities() {
        Set mappedEntities = this.emf.getMetamodel().getEntities();
        for (EntityType entity : mappedEntities) {
            Class javaType = entity.getJavaType();
            if (Modifier.isAbstract(javaType.getModifiers()) || !this.isIdentityEntity(javaType)) continue;
            PicketLinkLogger.ROOT_LOGGER.debugf("Mapping entity [%s] to JPA Identity Store.", javaType.getName());
            this.configurationBuilder.mappedEntity(new Class[]{javaType});
        }
    }

    private boolean isIdentityEntity(Class<?> cls) {
        Class<?> checkClass = cls;
        while (!checkClass.equals(Object.class)) {
            for (Annotation a : checkClass.getAnnotations()) {
                if (!a.annotationType().getName().startsWith(JPA_ANNOTATION_PACKAGE)) continue;
                return true;
            }
            for (Field f : checkClass.getDeclaredFields()) {
                for (Annotation a : f.getAnnotations()) {
                    if (!a.annotationType().getName().startsWith(JPA_ANNOTATION_PACKAGE)) continue;
                    return true;
                }
            }
            checkClass = checkClass.getSuperclass();
        }
        return false;
    }

    private EntityManager getEntityManager(TransactionManager transactionManager) {
        return (EntityManager)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{EntityManager.class}, (InvocationHandler)new EntityManagerInvocationHandler(this.emf.createEntityManager(), this.storeConfig.getEntityModule(), transactionManager));
    }

    private class EntityManagerInvocationHandler
    implements InvocationHandler {
        private final EntityManager em;
        private final Module entityModule;
        private final TransactionManager transactionManager;

        public EntityManagerInvocationHandler(EntityManager em, Module entitiesModule, TransactionManager transactionManager) {
            this.em = em;
            this.entityModule = entitiesModule;
            this.transactionManager = transactionManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Transaction tx = null;
            if (this.isTxRequired(method)) {
                if (this.transactionManager.getStatus() == 6) {
                    this.transactionManager.begin();
                }
                this.em.joinTransaction();
                tx = this.transactionManager.getTransaction();
            }
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (this.entityModule != null) {
                    Thread.currentThread().setContextClassLoader((ClassLoader)this.entityModule.getClassLoader());
                }
                Object object = method.invoke((Object)this.em, args);
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
                if (tx != null) {
                    tx.commit();
                    this.transactionManager.suspend();
                }
            }
        }

        private boolean isTxRequired(Method method) {
            String n = method.getName();
            return "flush".equals(n) || "getLockMode".equals(n) || "lock".equals(n) || "merge".equals(n) || "persist".equals(n) || "refresh".equals(n) || "remove".equals(n);
        }
    }
}

