/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.picketlink.PicketLinkMessages;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.XMLElement;
import org.wildfly.extension.picketlink.common.parser.ModelXMLElementWriter;
import org.wildfly.extension.picketlink.idm.Namespace;

public class IDMSubsystemWriter
implements XMLStreamConstants,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final Map<String, ModelXMLElementWriter> writers = new HashMap<String, ModelXMLElementWriter>();

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        if (!context.getModelNode().isDefined()) {
            return;
        }
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        List identityManagement = context.getModelNode().asList();
        for (ModelNode modelNode : identityManagement) {
            String modelName = modelNode.asProperty().getName();
            if (modelName.equals(ModelElement.PARTITION_MANAGER.getName())) {
                writers.get(ModelElement.PARTITION_MANAGER.getName()).write(writer, modelNode);
                continue;
            }
            PicketLinkMessages.MESSAGES.parserUnexpectedElement(modelName);
        }
        writer.writeEndElement();
    }

    private static void registerWriter(ModelElement element, ModelElement keyAttribute) {
        writers.put(element.getName(), new ModelXMLElementWriter(element, keyAttribute.getName(), writers));
    }

    private static void registerWriter(ModelElement element) {
        writers.put(element.getName(), new ModelXMLElementWriter(element, writers));
    }

    private static void registerWriter(ModelElement element, XMLElement parent) {
        writers.put(element.getName(), new ModelXMLElementWriter(element, parent, writers));
    }

    static {
        IDMSubsystemWriter.registerWriter(ModelElement.PARTITION_MANAGER, ModelElement.COMMON_NAME);
        IDMSubsystemWriter.registerWriter(ModelElement.IDENTITY_CONFIGURATION, ModelElement.COMMON_NAME);
        IDMSubsystemWriter.registerWriter(ModelElement.JPA_STORE);
        IDMSubsystemWriter.registerWriter(ModelElement.FILE_STORE);
        IDMSubsystemWriter.registerWriter(ModelElement.LDAP_STORE);
        IDMSubsystemWriter.registerWriter(ModelElement.LDAP_STORE_MAPPING, XMLElement.LDAP_MAPPINGS);
        IDMSubsystemWriter.registerWriter(ModelElement.LDAP_STORE_ATTRIBUTE);
        IDMSubsystemWriter.registerWriter(ModelElement.SUPPORTED_TYPES);
        IDMSubsystemWriter.registerWriter(ModelElement.SUPPORTED_TYPE);
        IDMSubsystemWriter.registerWriter(ModelElement.IDENTITY_STORE_CREDENTIAL_HANDLER, XMLElement.IDENTITY_STORE_CREDENTIAL_HANDLERS);
    }
}

