/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.service;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.picketlink.config.federation.handler.Handler;
import org.wildfly.extension.picketlink.federation.service.EntityProviderService;

public class SAMLHandlerService
implements Service<SAMLHandlerService> {
    private static final String SERVICE_NAME = "SAMLHandlerService";
    private final Handler handler;
    private final InjectedValue<EntityProviderService> entityProviderService = new InjectedValue();

    public SAMLHandlerService(Handler handler) {
        this.handler = handler;
    }

    public static ServiceName createServiceName(String providerAlias, String handlerClazz) {
        return ServiceName.JBOSS.append(new String[]{"picketlink-federation", SERVICE_NAME, providerAlias + "." + handlerClazz});
    }

    public SAMLHandlerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        ((EntityProviderService)this.getEntityProviderService().getValue()).addHandler(this.handler);
    }

    public void stop(StopContext context) {
        ((EntityProviderService)this.getEntityProviderService().getValue()).removeHandler(this.handler);
    }

    public InjectedValue<EntityProviderService> getEntityProviderService() {
        return this.entityProviderService;
    }
}

