/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.service;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.picketlink.config.federation.KeyValueType;
import org.picketlink.config.federation.TrustType;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.web.handlers.saml2.RolesGenerationHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2AuthenticationHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2EncryptionHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2IssuerTrustHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2LogOutHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2SignatureValidationHandler;
import org.wildfly.extension.picketlink.federation.config.IDPConfiguration;
import org.wildfly.extension.picketlink.federation.service.EntityProviderService;
import org.wildfly.extension.picketlink.federation.service.FederationService;

public class IdentityProviderService
extends EntityProviderService<IdentityProviderService, IDPConfiguration> {
    private static final String SERVICE_NAME = "IDPConfigurationService";

    public IdentityProviderService(IDPConfiguration idpConfiguration) {
        super(idpConfiguration);
    }

    public static ServiceName createServiceName(String alias) {
        return ServiceName.JBOSS.append(new String[]{"picketlink-federation", SERVICE_NAME, alias});
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        ((FederationService)this.getFederationService().getValue()).setIdpConfiguration((IDPConfiguration)this.getConfiguration());
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        ((FederationService)this.getFederationService().getValue()).setIdpConfiguration(null);
    }

    @Override
    protected List<Class<? extends SAML2Handler>> getDefaultHandlers() {
        ArrayList<Class<? extends SAML2Handler>> defaultHandlers = new ArrayList<Class<? extends SAML2Handler>>();
        defaultHandlers.add(SAML2IssuerTrustHandler.class);
        defaultHandlers.add(SAML2LogOutHandler.class);
        defaultHandlers.add(SAML2AuthenticationHandler.class);
        defaultHandlers.add(RolesGenerationHandler.class);
        defaultHandlers.add(SAML2EncryptionHandler.class);
        defaultHandlers.add(SAML2SignatureValidationHandler.class);
        return defaultHandlers;
    }

    @Override
    protected void doConfigureDeployment(DeploymentUnit deploymentUnit) {
        String domainsStr;
        TrustType trustType;
        if (((IDPConfiguration)this.getConfiguration()).getKeyProvider() != null && (trustType = ((IDPConfiguration)this.getConfiguration()).getTrust()) != null && (domainsStr = trustType.getDomains()) != null) {
            String[] domains;
            for (String domain : domains = domainsStr.split(",")) {
                KeyValueType kv = new KeyValueType();
                kv.setKey(domain);
                String value = domain;
                if (((IDPConfiguration)this.getConfiguration()).getTrustDomainAlias() != null) {
                    value = ((IDPConfiguration)this.getConfiguration()).getTrustDomainAlias().get(domain);
                }
                kv.setValue(value);
                ((IDPConfiguration)this.getConfiguration()).getKeyProvider().remove(kv);
                ((IDPConfiguration)this.getConfiguration()).getKeyProvider().add(kv);
            }
        }
    }
}

