/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.service;

import java.util.ArrayList;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.picketlink.config.federation.KeyProviderType;
import org.picketlink.config.federation.KeyValueType;
import org.picketlink.config.federation.STSType;
import org.wildfly.extension.picketlink.federation.config.IDPConfiguration;

public class FederationService
implements Service<FederationService> {
    private static final String SERVICE_NAME = "FederationService";
    private volatile KeyProviderType keyProviderType;
    private volatile STSType stsType;
    private volatile IDPConfiguration idpConfiguration;
    private final String alias;

    public FederationService(String alias) {
        this.alias = alias;
    }

    public static ServiceName createServiceName(String alias) {
        return ServiceName.JBOSS.append(new String[]{"picketlink-federation", SERVICE_NAME, alias});
    }

    public FederationService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    void addTrustedDomain(String domainName, String domainCertAlias) {
        KeyProviderType keyProvider = this.getKeyProviderType();
        if (keyProvider != null) {
            KeyValueType keyValue = new KeyValueType();
            keyValue.setKey(domainName);
            if (domainCertAlias != null) {
                keyValue.setValue(domainCertAlias);
            } else {
                keyValue.setValue(domainName);
            }
            keyProvider.add(keyValue);
        }
        this.getIdpConfiguration().addTrustDomain(domainName, domainCertAlias);
    }

    void removeTrustedDomain(String domainName) {
        KeyProviderType keyProvider = this.getKeyProviderType();
        if (keyProvider != null) {
            for (KeyValueType validatingAlias : new ArrayList(keyProvider.getValidatingAlias())) {
                if (!validatingAlias.getKey().equals(domainName)) continue;
                keyProvider.remove(validatingAlias);
            }
        }
        this.getIdpConfiguration().removeTrustDomain(domainName);
    }

    KeyProviderType getKeyProviderType() {
        return this.keyProviderType;
    }

    void setKeyProviderType(KeyProviderType keyProviderType) {
        this.keyProviderType = keyProviderType;
    }

    void setSTSType(STSType STSType2) {
        this.stsType = STSType2;
    }

    STSType getStsType() {
        return this.stsType;
    }

    IDPConfiguration getIdpConfiguration() {
        return this.idpConfiguration;
    }

    void setIdpConfiguration(IDPConfiguration idpConfiguration) {
        this.idpConfiguration = idpConfiguration;
    }

    public String getAlias() {
        return this.alias;
    }
}

