/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.saml;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.picketlink.config.federation.STSType;
import org.wildfly.extension.picketlink.federation.model.saml.SAMLResourceDefinition;
import org.wildfly.extension.picketlink.federation.service.FederationService;
import org.wildfly.extension.picketlink.federation.service.SAMLService;

public class SAMLAddHandler
extends AbstractAddStepHandler {
    static final SAMLAddHandler INSTANCE = new SAMLAddHandler();

    private SAMLAddHandler() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attribute : SAMLResourceDefinition.INSTANCE.getAttributes()) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        SAMLAddHandler.launchServices(context, operation, model, verificationHandler, newControllers);
    }

    static void launchServices(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String federationAlias = pathAddress.subAddress(0, pathAddress.size() - 1).getLastElement().getValue();
        SAMLService service = new SAMLService(SAMLAddHandler.toSAMLConfig(context, model));
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(SAMLService.createServiceName(federationAlias), (Service)service);
        serviceBuilder.addDependency(FederationService.createServiceName(federationAlias), FederationService.class, service.getFederationService());
        if (verificationHandler != null) {
            serviceBuilder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = serviceBuilder.setInitialMode(ServiceController.Mode.PASSIVE).install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }

    private static STSType toSAMLConfig(OperationContext context, ModelNode fromModel) throws OperationFailedException {
        int tokenTimeout = SAMLResourceDefinition.TOKEN_TIMEOUT.resolveModelAttribute(context, fromModel).asInt();
        int clockSkew = SAMLResourceDefinition.CLOCK_SKEW.resolveModelAttribute(context, fromModel).asInt();
        STSType stsType = new STSType();
        stsType.setTokenTimeout(Integer.valueOf(tokenTimeout));
        stsType.setClockSkew(Integer.valueOf(clockSkew));
        return stsType;
    }
}

