/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.handlers;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.picketlink.config.federation.KeyValueType;
import org.picketlink.config.federation.handler.Handler;
import org.wildfly.extension.picketlink.PicketLinkMessages;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerParameterResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerTypeEnum;
import org.wildfly.extension.picketlink.federation.service.EntityProviderService;
import org.wildfly.extension.picketlink.federation.service.IdentityProviderService;
import org.wildfly.extension.picketlink.federation.service.SAMLHandlerService;
import org.wildfly.extension.picketlink.federation.service.ServiceProviderService;

public class HandlerAddHandler
extends AbstractAddStepHandler {
    static final HandlerAddHandler INSTANCE = new HandlerAddHandler();

    private HandlerAddHandler() {
    }

    static void launchServices(OperationContext context, PathAddress pathAddress, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String typeName;
        Handler newHandler = new Handler();
        ModelNode classNameNode = HandlerResourceDefinition.CLASS.resolveModelAttribute(context, model);
        ModelNode codeNode = HandlerResourceDefinition.CODE.resolveModelAttribute(context, model);
        if (classNameNode.isDefined()) {
            typeName = classNameNode.asString();
        } else if (codeNode.isDefined()) {
            typeName = HandlerTypeEnum.forType(codeNode.asString());
        } else {
            throw PicketLinkMessages.MESSAGES.federationHandlerTypeNotProvided();
        }
        newHandler.setClazz(typeName);
        ModelNode handler = Resource.Tools.readModel((Resource)context.readResourceFromRoot(pathAddress));
        if (handler.hasDefined(ModelElement.COMMON_HANDLER_PARAMETER.getName())) {
            for (Property handlerParameter : handler.get(ModelElement.COMMON_HANDLER_PARAMETER.getName()).asPropertyList()) {
                String paramName = handlerParameter.getName();
                String paramValue = HandlerParameterResourceDefinition.VALUE.resolveModelAttribute(context, handlerParameter.getValue()).asString();
                KeyValueType kv = new KeyValueType();
                kv.setKey(paramName);
                kv.setValue(paramValue);
                newHandler.add(kv);
            }
        }
        SAMLHandlerService service = new SAMLHandlerService(newHandler);
        PathElement providerAlias = pathAddress.subAddress(0, pathAddress.size() - 1).getLastElement();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceBuilder serviceBuilder = serviceTarget.addService(SAMLHandlerService.createServiceName(providerAlias.getValue(), newHandler.getClazz()), (Service)service);
        ServiceName serviceName = providerAlias.getKey().equals(ModelElement.IDENTITY_PROVIDER.getName()) ? IdentityProviderService.createServiceName(providerAlias.getValue()) : ServiceProviderService.createServiceName(providerAlias.getValue());
        serviceBuilder.addDependency(serviceName, EntityProviderService.class, service.getEntityProviderService());
        if (verificationHandler != null) {
            serviceBuilder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = serviceBuilder.setInitialMode(ServiceController.Mode.PASSIVE).install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
        if (!context.isBooting()) {
            context.reloadRequired();
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attribute : HandlerResourceDefinition.INSTANCE.getAttributes()) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        HandlerAddHandler.launchServices(context, PathAddress.pathAddress((ModelNode)operation.get("address")), model, verificationHandler, newControllers);
    }
}

