/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.KeyProviderType;
import org.picketlink.config.federation.TrustType;
import org.wildfly.extension.picketlink.federation.config.ProviderConfiguration;

public class IDPConfiguration
extends IDPType
implements ProviderConfiguration {
    private final String alias;
    private volatile String securityDomain;
    private final Map<String, String> trustDomainAlias = new HashMap<String, String>();
    private volatile boolean external;
    private volatile boolean supportMetadata;

    public IDPConfiguration(String alias) {
        this.alias = alias;
        this.setTrust(new TrustType());
        this.getTrust().setDomains("");
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String getSecurityDomain() {
        return this.securityDomain;
    }

    @Override
    public void setKeyProvider(KeyProviderType keyProviderType) {
        super.setKeyProvider(keyProviderType);
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public void addTrustDomain(String domain, String certAlias) {
        String domainsList = this.getDomains();
        if (!StringUtil.isNullOrEmpty((String)domainsList)) {
            domainsList = domainsList + ",";
        }
        this.getTrust().setDomains(domainsList + domain);
        if (!StringUtil.isNullOrEmpty((String)certAlias)) {
            this.trustDomainAlias.put(domain.trim(), certAlias.trim());
        } else {
            this.trustDomainAlias.put(domain.trim(), domain.trim());
        }
    }

    public void removeTrustDomain(String domain) {
        String domainsList = this.getDomains();
        if (!StringUtil.isNullOrEmpty((String)domainsList)) {
            this.getTrust().setDomains("");
            for (String currentDomain : domainsList.split(",")) {
                if (domain.equals(currentDomain) || StringUtil.isNullOrEmpty((String)currentDomain)) continue;
                this.addTrustDomain(currentDomain, this.trustDomainAlias.get(currentDomain));
            }
        }
    }

    private String getDomains() {
        if (this.getTrust().getDomains() == null) {
            this.getTrust().setDomains("");
        }
        return this.getTrust().getDomains();
    }

    public Map<String, String> getTrustDomainAlias() {
        return Collections.unmodifiableMap(this.trustDomainAlias);
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setSupportMetadata(boolean supportMetadata) {
        this.supportMetadata = supportMetadata;
    }

    public boolean isSupportMetadata() {
        return this.supportMetadata;
    }
}

