/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.wildfly.extension.picketlink.federation.FederationSubsystemRootResourceDefinition;
import org.wildfly.extension.picketlink.federation.Namespace;

public class FederationExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "picketlink-federation";
    private static final String RESOURCE_NAME = FederationExtension.class.getPackage().getName() + ".LocalDescriptions";

    public static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, FederationExtension.class.getClassLoader(), true, true);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, Namespace.CURRENT.getMajor(), Namespace.CURRENT.getMinor());
        subsystem.registerSubsystemModel((ResourceDefinition)new FederationSubsystemRootResourceDefinition(context));
        subsystem.registerXMLElementWriter(Namespace.CURRENT.getXMLWriter());
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.CURRENT.getUri(), Namespace.CURRENT.getXMLReader());
    }
}

