/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.extension.picketlink.common.model.ModelElement;

public abstract class AbstractResourceDefinition
extends SimpleResourceDefinition {
    private static final Map<ModelElement, List<SimpleAttributeDefinition>> attributeDefinitions = new HashMap<ModelElement, List<SimpleAttributeDefinition>>();
    private static final Map<ModelElement, List<ResourceDefinition>> childResourceDefinitions = new HashMap<ModelElement, List<ResourceDefinition>>();
    private final ModelElement modelElement;
    private final List<SimpleAttributeDefinition> attributes = new ArrayList<SimpleAttributeDefinition>();

    protected AbstractResourceDefinition(ModelElement modelElement, OperationStepHandler addHandler, OperationStepHandler removeHandler, ResourceDescriptionResolver resourceDescriptor, SimpleAttributeDefinition ... attributes) {
        super(PathElement.pathElement((String)modelElement.getName()), resourceDescriptor, addHandler, removeHandler);
        this.modelElement = modelElement;
        Collections.addAll(this.attributes, attributes);
    }

    protected AbstractResourceDefinition(ModelElement modelElement, String name, OperationStepHandler addHandler, OperationStepHandler removeHandler, ResourceDescriptionResolver resourceDescriptor, SimpleAttributeDefinition ... attributes) {
        super(PathElement.pathElement((String)modelElement.getName(), (String)name), resourceDescriptor, addHandler, removeHandler);
        this.modelElement = modelElement;
        Collections.addAll(this.attributes, attributes);
    }

    public static List<SimpleAttributeDefinition> getAttributeDefinition(ModelElement modelElement) {
        List<SimpleAttributeDefinition> definitions = attributeDefinitions.get((Object)modelElement);
        if (definitions == null) {
            return Collections.emptyList();
        }
        return definitions;
    }

    public static Map<ModelElement, List<ResourceDefinition>> getChildResourceDefinitions() {
        return Collections.unmodifiableMap(childResourceDefinitions);
    }

    private void addAttributeDefinition(ModelElement resourceDefinitionKey, SimpleAttributeDefinition attribute) {
        List<SimpleAttributeDefinition> resourceAttributes = attributeDefinitions.get((Object)resourceDefinitionKey);
        if (resourceAttributes == null) {
            resourceAttributes = new ArrayList<SimpleAttributeDefinition>();
            attributeDefinitions.put(resourceDefinitionKey, resourceAttributes);
        }
        if (!resourceAttributes.contains(attribute)) {
            resourceAttributes.add(attribute);
        }
    }

    private void addChildResourceDefinition(ModelElement resourceDefinitionKey, ResourceDefinition resourceDefinition) {
        List<ResourceDefinition> childResources = childResourceDefinitions.get((Object)resourceDefinitionKey);
        if (childResources == null) {
            childResources = new ArrayList<ResourceDefinition>();
            childResourceDefinitions.put(resourceDefinitionKey, childResources);
        }
        if (!childResources.contains((Object)resourceDefinitionKey)) {
            for (ResourceDefinition childResource : childResources) {
                if (!childResource.getPathElement().getKey().equals(resourceDefinition.getPathElement().getKey())) continue;
                return;
            }
            childResources.add(resourceDefinition);
        }
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (SimpleAttributeDefinition attribute : this.getAttributes()) {
            this.addAttributeDefinition(attribute, this.createAttributeWriterHandler(), resourceRegistration);
        }
    }

    protected abstract OperationStepHandler createAttributeWriterHandler();

    public List<SimpleAttributeDefinition> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    private void addAttributeDefinition(SimpleAttributeDefinition definition, OperationStepHandler writeHandler, ManagementResourceRegistration resourceRegistration) {
        this.addAttributeDefinition(this.modelElement, definition);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)definition, null, writeHandler);
    }

    protected void addChildResourceDefinition(AbstractResourceDefinition definition, ManagementResourceRegistration resourceRegistration) {
        this.addChildResourceDefinition(this.modelElement, (ResourceDefinition)definition);
        resourceRegistration.registerSubModel((ResourceDefinition)definition);
    }
}

