/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.server;

import java.io.File;
import java.util.Arrays;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeCallback;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.util.StartScriptConfiguration;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.server.DiscoveryCallbackImpl;

public final class ResourceUpgradeCallbackImpl
implements ResourceUpgradeCallback<ResourceComponent<?>> {
    public void upgrade(ResourceUpgradeReport upgradeReport, ResourceUpgradeContext<ResourceComponent<?>> inventoriedResource) {
        ProcessInfo processInfo = inventoriedResource.getNativeProcess();
        if (DiscoveryCallbackImpl.isRhqServer(processInfo)) {
            StartScriptConfiguration startScriptConfig;
            File startScriptFile;
            String resourceName;
            boolean comingFromUpgradeReport = true;
            Configuration pluginConfiguration = upgradeReport.getNewPluginConfiguration();
            if (pluginConfiguration == null) {
                comingFromUpgradeReport = false;
                pluginConfiguration = inventoriedResource.getPluginConfiguration();
            }
            String currentValue = pluginConfiguration.getSimpleValue("supportsPatching");
            if (comingFromUpgradeReport || currentValue == null || currentValue.startsWith("__UNINITIALIZED_")) {
                pluginConfiguration.setSimpleValue("supportsPatching", "false");
                upgradeReport.setNewPluginConfiguration(pluginConfiguration);
            }
            if ((resourceName = upgradeReport.getNewName()) == null) {
                resourceName = inventoriedResource.getName();
            }
            if ((startScriptFile = (startScriptConfig = new StartScriptConfiguration(pluginConfiguration)).getStartScript()) != null && startScriptFile.getName().equals("standalone.sh")) {
                startScriptConfig.setStartScriptPrefix(null);
                startScriptConfig.setStartScriptArgs(Arrays.asList("start", "--server"));
                File homeDirFile = new File(pluginConfiguration.getSimpleValue("homeDir"));
                startScriptConfig.setStartScript(new File(new File(homeDirFile, "bin"), "rhqctl"));
                upgradeReport.setNewPluginConfiguration(pluginConfiguration);
            }
            if (!resourceName.endsWith(" RHQ Server")) {
                resourceName = resourceName + " RHQ Server";
                upgradeReport.setNewName(resourceName);
            }
        }
    }
}

