/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.server;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.ClassLoaderFacet;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.server.JBossAS7JMXComponent;

public class JBossAS7JMXDiscoveryComponent<T extends ResourceComponent<JBossAS7JMXComponent<?>>>
implements ResourceDiscoveryComponent<T>,
ClassLoaderFacet<ResourceComponent<JBossAS7JMXComponent<?>>> {
    private static final Log LOG = LogFactory.getLog(JBossAS7JMXDiscoveryComponent.class);

    @Deprecated
    public List<URL> getAdditionalClasspathUrls(ResourceDiscoveryContext<ResourceComponent<JBossAS7JMXComponent<?>>> context, DiscoveredResourceDetails details) throws Exception {
        return Collections.emptyList();
    }

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<T> context) {
        File homeDirFile;
        ResourceContext parentResourceContext = context.getParentResourceContext();
        Configuration parentPluginConfig = parentResourceContext.getPluginConfiguration();
        File rhqServerFile = null;
        File clientJarDir = null;
        String homeDirStr = parentPluginConfig.getSimpleValue("homeDir");
        if (homeDirStr != null && (homeDirFile = new File(homeDirStr)).exists()) {
            clientJarDir = new File(homeDirFile, "bin/client");
            if (!clientJarDir.exists()) {
                LOG.warn((Object)("The client jar location [" + clientJarDir.getAbsolutePath() + "] does not exist - will not be able to connect to the AS7 instance"));
            }
            rhqServerFile = new File(homeDirFile, "../bin/rhq-server.sh");
        }
        if (null == rhqServerFile || !rhqServerFile.exists() || !clientJarDir.exists()) {
            return Collections.emptySet();
        }
        String clientJarLocation = clientJarDir.getAbsolutePath();
        String key = "RHQServerSubsystems";
        String name = "RHQ Server Subsystems";
        String version = parentResourceContext.getVersion();
        String description = "Container for RHQ Server Subsystem services";
        Configuration pluginConfig = context.getDefaultPluginConfiguration();
        String hostname = parentPluginConfig.getSimpleValue("hostname", "127.0.0.1");
        pluginConfig.setSimpleValue("hostname", hostname);
        String port = parentPluginConfig.getSimpleValue("port", "9999");
        if (!"9999".equals(port)) {
            port = String.valueOf(Integer.valueOf(port) + 9);
        }
        pluginConfig.setSimpleValue("port", port);
        String user = parentPluginConfig.getSimpleValue("username", "rhqadmin");
        pluginConfig.setSimpleValue("username", user);
        String password = parentPluginConfig.getSimpleValue("password", "rhqadmin");
        pluginConfig.setSimpleValue("password", password);
        pluginConfig.setSimpleValue("clientJarLocation", clientJarLocation);
        DiscoveredResourceDetails resource = new DiscoveredResourceDetails(context.getResourceType(), key, name, version, description, pluginConfig, null);
        return Collections.singleton(resource);
    }
}

