/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertCli;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.bytecode.AccessFlag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.criteria.AlertDefinitionCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.PackageVersionCriteria;
import org.rhq.core.domain.resource.composite.DisambiguationReport;
import org.rhq.core.domain.util.DisambiguationReportRenderer;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.IntExtractor;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.plugin.pc.ControlFacet;
import org.rhq.enterprise.server.plugin.pc.ControlResults;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.disambiguation.DefaultDisambiguationUpdateStrategies;
import org.rhq.enterprise.server.resource.disambiguation.DisambiguationUpdateStrategy;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.alert.AlertPluginDescriptorType;

public class CliComponent
implements ServerPluginComponent,
ControlFacet {
    private static final Log LOG = LogFactory.getLog(CliComponent.class);
    public static final String PACKAGE_TYPE_NAME = "org.rhq.enterprise.server.plugins.packagetypeCli.SERVER_SIDE_CLI_SCRIPT";
    private static final String CONTROL_CHECK_ALERTS_VALIDITY = "checkAlertsValidity";
    private static final String CONTROL_REASSIGN_ALERTS = "reassignAlerts";
    private static final String PROP_ALERT_DEFINITION_NAME = "alertDefinitionName";
    private static final String PROP_RESOURCE_PATH = "resourcePath";
    private static final String PROP_RESOURCE_ID = "resourceId";
    private static final String PROP_MISSING_USERS = "missingUsers";
    private static final String PROP_MISSING_SCRIPTS = "missingScripts";
    private static final String PROP_ALERT_DEFINITION = "alertDefinition";
    private static final String PROP_ALERT_DEFINITION_ID = "alertDefinitionId";
    private static final String PROP_USER_NAME = "userName";
    private static final String PROP_ALERT_DEF_IDS = "alertDefIds";
    private static final String PROP_SCRIPT_TIMEOUT = "scriptTimeout";
    private static final String WARNING_MESSAGE_LOAD_CLASSES = "Could not load domain packages names. The CLI Alert Sender will only understand fully qualified domain classes names in CLI scripts.";
    private String pluginName;
    private PackageType packageType;
    private int scriptTimeout;
    private Set<String> domainPackagesNames;

    public void initialize(ServerPluginContext context) throws Exception {
        this.pluginName = ((AlertPluginDescriptorType)context.getPluginEnvironment().getPluginDescriptor()).getShortName();
        String timeoutValue = context.getPluginConfiguration() == null ? "60" : context.getPluginConfiguration().getSimpleValue(PROP_SCRIPT_TIMEOUT, "60");
        this.scriptTimeout = Integer.parseInt(timeoutValue);
    }

    public PackageType getScriptPackageType() {
        if (this.packageType == null) {
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            ContentManagerLocal cm = LookupUtil.getContentManager();
            this.packageType = cm.findPackageType(subjectManager.getOverlord(), null, PACKAGE_TYPE_NAME);
        }
        return this.packageType;
    }

    public int getScriptTimeout() {
        return this.scriptTimeout;
    }

    public void start() {
        this.domainPackagesNames = this.loadPackagesNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> loadPackagesNames() {
        List classChildren;
        VirtualFile virtualFile;
        Enumeration<URL> persistenceFileUrls;
        try {
            persistenceFileUrls = this.getClass().getClassLoader().getResources("META-INF/persistence.xml");
        }
        catch (IOException e) {
            LOG.warn((Object)WARNING_MESSAGE_LOAD_CLASSES, (Throwable)e);
            return Collections.emptySet();
        }
        URL coreDomainPersistenceFileUrl = null;
        while (persistenceFileUrls.hasMoreElements()) {
            URL url = persistenceFileUrls.nextElement();
            if (!url.getPath().contains("rhq-core-domain")) continue;
            if (coreDomainPersistenceFileUrl == null) {
                coreDomainPersistenceFileUrl = url;
                continue;
            }
            LOG.warn((Object)("Could not load domain packages names. The CLI Alert Sender will only understand fully qualified domain classes names in CLI scripts. Found more than one core domain JAR: [" + coreDomainPersistenceFileUrl + "] [" + url + "]"));
            return Collections.emptySet();
        }
        if (coreDomainPersistenceFileUrl == null) {
            LOG.warn((Object)"Could not load domain packages names. The CLI Alert Sender will only understand fully qualified domain classes names in CLI scripts. Core domain JAR not found");
            return Collections.emptySet();
        }
        try {
            virtualFile = (VirtualFile)coreDomainPersistenceFileUrl.openConnection().getContent();
        }
        catch (IOException e) {
            LOG.warn((Object)WARNING_MESSAGE_LOAD_CLASSES, (Throwable)e);
            return Collections.emptySet();
        }
        virtualFile = virtualFile.getParent().getParent();
        Indexer indexer = new Indexer();
        try {
            classChildren = virtualFile.getChildren((VirtualFileFilter)new SuffixMatchFilter(".class", VisitorAttributes.RECURSE_LEAVES_ONLY));
        }
        catch (IOException e) {
            LOG.warn((Object)WARNING_MESSAGE_LOAD_CLASSES, (Throwable)e);
            return Collections.emptySet();
        }
        for (VirtualFile classFile : classChildren) {
            InputStream inputStream = null;
            try {
                inputStream = classFile.openStream();
                indexer.index(inputStream);
            }
            catch (IOException e) {
                LOG.warn((Object)WARNING_MESSAGE_LOAD_CLASSES, (Throwable)e);
                Set<String> set = Collections.emptySet();
                return set;
            }
            finally {
                VFSUtils.safeClose((Closeable)inputStream);
            }
        }
        Index index = indexer.complete();
        Collection knownClasses = index.getKnownClasses();
        HashSet<String> domainPackagesNames = new HashSet<String>();
        for (ClassInfo knownClass : knownClasses) {
            String className;
            int i;
            if (!AccessFlag.isPublic((int)knownClass.flags()) || (i = (className = knownClass.name().toString()).lastIndexOf(46)) == -1) continue;
            domainPackagesNames.add(className.substring(0, i));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("domainPackagesNames = " + domainPackagesNames));
        }
        return domainPackagesNames;
    }

    public void stop() {
        this.domainPackagesNames = null;
    }

    public void shutdown() {
    }

    public ControlResults invoke(String name, Configuration parameters) {
        ControlResults results = new ControlResults();
        try {
            if (CONTROL_CHECK_ALERTS_VALIDITY.equals(name)) {
                this.checkAlertsValidity(results);
            } else if (CONTROL_REASSIGN_ALERTS.equals(name)) {
                this.reassignAlerts(parameters);
            }
        }
        catch (Exception e) {
            results.setError((Throwable)e);
        }
        return results;
    }

    private void checkAlertsValidity(ControlResults results) {
        List<AlertNotification> allCliNotifications = this.getAllCliNotifications(null);
        Configuration resConfig = results.getComplexResults();
        PropertyList missingUsersList = new PropertyList(PROP_MISSING_USERS);
        resConfig.put((Property)missingUsersList);
        List<AlertNotification> invalidNotifs = this.getCliNotificationsWithInvalidUser(allCliNotifications);
        this.convertNotificationsToInvalidAlertDefResults(missingUsersList, invalidNotifs);
        PropertyList missingScriptsList = new PropertyList(PROP_MISSING_SCRIPTS);
        resConfig.put((Property)missingScriptsList);
        invalidNotifs = this.getCliNotificationsWithInvalidPackage(allCliNotifications);
        this.convertNotificationsToInvalidAlertDefResults(missingScriptsList, invalidNotifs);
        ArrayList allMissing = new ArrayList();
        allMissing.addAll(missingUsersList.getList());
        allMissing.addAll(missingScriptsList.getList());
        if (allMissing.size() > 0) {
            ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
            List disambiguated = resourceManager.disambiguate(allMissing, (IntExtractor)new IntExtractor<Property>(){

                public int extract(Property object) {
                    PropertyMap map = (PropertyMap)object;
                    return map.getSimple(CliComponent.PROP_RESOURCE_ID).getIntegerValue();
                }
            }, (DisambiguationUpdateStrategy)DefaultDisambiguationUpdateStrategies.KEEP_ALL_PARENTS);
            DisambiguationReportRenderer renderer = new DisambiguationReportRenderer();
            for (DisambiguationReport r : disambiguated) {
                PropertyMap map = (PropertyMap)r.getOriginal();
                String resourcePath = renderer.render(r);
                map.put((Property)new PropertySimple(PROP_RESOURCE_PATH, (Object)resourcePath));
            }
        }
    }

    private void reassignAlerts(Configuration parameters) {
        List<AlertNotification> notifsToReAssign;
        PropertySimple userNameProp = parameters.getSimple(PROP_USER_NAME);
        PropertySimple alertDefIdsProp = parameters.getSimple(PROP_ALERT_DEF_IDS);
        if (userNameProp == null || userNameProp.getStringValue() == null || userNameProp.getStringValue().trim().length() == 0) {
            throw new IllegalArgumentException("User name not specified.");
        }
        String userName = userNameProp.getStringValue();
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        Subject subject = subjectManager.getSubjectByName(userName);
        if (subject == null) {
            throw new IllegalArgumentException("User '" + userName + "' doesn't exist.");
        }
        if (alertDefIdsProp == null || alertDefIdsProp.getStringValue() == null || alertDefIdsProp.getStringValue().trim().length() == 0) {
            notifsToReAssign = this.getCliNotificationsWithInvalidUser(this.getAllCliNotifications(null));
        } else {
            List<Integer> alertDefIds = this.asIdList(alertDefIdsProp.getStringValue().split("\\s*,\\s*"));
            List<AlertDefinition> defs = this.getAlertDefinitionsWithCliNotifications(alertDefIds);
            notifsToReAssign = new ArrayList<AlertNotification>();
            for (AlertDefinition def : defs) {
                for (AlertNotification cliNotif : this.getCliNotifications(def.getAlertNotifications())) {
                    notifsToReAssign.add(cliNotif);
                }
            }
        }
        AlertNotificationManagerLocal notificationManager = LookupUtil.getAlertNotificationManager();
        List<Integer> notifIds = this.asIdList(notifsToReAssign);
        Map<String, String> updates = Collections.singletonMap("userId", Integer.toString(subject.getId()));
        notificationManager.massReconfigure(notifIds, updates);
    }

    private List<AlertNotification> getCliNotifications(List<AlertNotification> notifications) {
        ArrayList<AlertNotification> ret = new ArrayList<AlertNotification>();
        for (AlertNotification n : notifications) {
            if (!this.pluginName.equals(n.getSenderName())) continue;
            ret.add(n);
        }
        return ret;
    }

    private List<AlertDefinition> getAlertDefinitionsWithCliNotifications(Collection<Integer> alertDefIds) {
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        AlertDefinitionManagerLocal manager = LookupUtil.getAlertDefinitionManager();
        Subject overlord = subjectManager.getOverlord();
        AlertDefinitionCriteria criteria = new AlertDefinitionCriteria();
        criteria.addFilterNotificationNames(new String[]{this.pluginName});
        criteria.setPageControl(PageControl.getUnlimitedInstance());
        criteria.fetchAlertNotifications(true);
        if (alertDefIds != null) {
            criteria.addFilterIds(alertDefIds.toArray(new Integer[alertDefIds.size()]));
        }
        return manager.findAlertDefinitionsByCriteria(overlord, criteria);
    }

    private List<AlertNotification> getAllCliNotifications(Collection<Integer> alertDefIds) {
        ArrayList<AlertNotification> ret = new ArrayList<AlertNotification>();
        List<AlertDefinition> defs = this.getAlertDefinitionsWithCliNotifications(alertDefIds);
        for (AlertDefinition def : defs) {
            List notifications = def.getAlertNotifications();
            ret.addAll(this.getCliNotifications(notifications));
        }
        return ret;
    }

    private List<AlertNotification> getCliNotificationsWithInvalidUser(List<AlertNotification> allNotifications) {
        ArrayList<AlertNotification> ret = new ArrayList<AlertNotification>();
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        for (AlertNotification cliNotification : allNotifications) {
            Subject checkSubject = null;
            PropertySimple subjectIdProperty = cliNotification.getConfiguration().getSimple("userId");
            if (subjectIdProperty != null) {
                int subjectId = subjectIdProperty.getIntegerValue();
                checkSubject = subjectManager.getSubjectById(subjectId);
            }
            if (checkSubject != null) continue;
            ret.add(cliNotification);
        }
        return ret;
    }

    private List<AlertNotification> getCliNotificationsWithInvalidPackage(List<AlertNotification> allNotifications) {
        ArrayList<AlertNotification> ret = new ArrayList<AlertNotification>();
        ContentManagerLocal contentManager = LookupUtil.getContentManager();
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        Subject overlord = subjectManager.getOverlord();
        PackageVersionCriteria crit = new PackageVersionCriteria();
        crit.setRestriction(Criteria.Restriction.COUNT_ONLY);
        for (AlertNotification cliNotification : allNotifications) {
            int count = 0;
            String packageId = cliNotification.getConfiguration().getSimpleValue("packageId", null);
            if (packageId != null) {
                crit.addFilterPackageId(Integer.valueOf(packageId));
                PageList res = contentManager.findPackageVersionsByCriteria(overlord, crit);
                count = res.getTotalSize();
            }
            if (count != 0) continue;
            ret.add(cliNotification);
        }
        return ret;
    }

    private void convertNotificationsToInvalidAlertDefResults(PropertyList results, List<AlertNotification> invalidNotifications) {
        HashSet<AlertDefinition> processedDefs = new HashSet<AlertDefinition>();
        for (AlertNotification cliNotification : invalidNotifications) {
            AlertDefinition def = cliNotification.getAlertDefinition();
            if (!processedDefs.add(def)) continue;
            PropertyMap alertDefinitionMap = new PropertyMap(PROP_ALERT_DEFINITION);
            alertDefinitionMap.put((Property)new PropertySimple(PROP_ALERT_DEFINITION_ID, (Object)def.getId()));
            alertDefinitionMap.put((Property)new PropertySimple(PROP_ALERT_DEFINITION_NAME, (Object)def.getName()));
            alertDefinitionMap.put((Property)new PropertySimple(PROP_RESOURCE_ID, (Object)def.getResource().getId()));
            results.add((Property)alertDefinitionMap);
        }
    }

    private List<Integer> asIdList(String ... ids) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (String id : ids) {
            ret.add(Integer.parseInt(id));
        }
        return ret;
    }

    private List<Integer> asIdList(Collection<AlertNotification> notifs) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (AlertNotification n : notifs) {
            ret.add(n.getId());
        }
        return ret;
    }

    public Set<String> getDomainPackagesNames() {
        return this.domainPackagesNames;
    }
}

