/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred.tether;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.avro.Schema;
import org.apache.avro.mapred.tether.TetherData;
import org.apache.avro.mapred.tether.TetherInputFormat;
import org.apache.avro.mapred.tether.TetherKeyComparator;
import org.apache.avro.mapred.tether.TetherKeySerialization;
import org.apache.avro.mapred.tether.TetherMapRunner;
import org.apache.avro.mapred.tether.TetherOutputFormat;
import org.apache.avro.mapred.tether.TetherPartitioner;
import org.apache.avro.mapred.tether.TetherReducer;
import org.apache.avro.tool.Tool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;

public class TetherJob
extends Configured
implements Tool {
    public static URI getExecutable(JobConf job) {
        try {
            return new URI(job.get("avro.tether.executable"));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setExecutable(JobConf job, URI executable) {
        job.set("avro.tether.executable", executable.toString());
    }

    public static RunningJob runJob(JobConf job) throws IOException {
        TetherJob.setupTetherJob(job);
        return JobClient.runJob((JobConf)job);
    }

    public static RunningJob submitJob(JobConf conf) throws IOException {
        TetherJob.setupTetherJob(conf);
        return new JobClient(conf).submitJob(conf);
    }

    private static void setupTetherJob(JobConf job) throws IOException {
        job.setMapRunnerClass(TetherMapRunner.class);
        job.setPartitionerClass(TetherPartitioner.class);
        job.setReducerClass(TetherReducer.class);
        job.setInputFormat(TetherInputFormat.class);
        job.setOutputFormat(TetherOutputFormat.class);
        job.setOutputKeyClass(TetherData.class);
        job.setOutputKeyComparatorClass(TetherKeyComparator.class);
        job.setMapOutputValueClass(NullWritable.class);
        Collection serializations = job.getStringCollection("io.serializations");
        if (!serializations.contains(TetherKeySerialization.class.getName())) {
            serializations.add(TetherKeySerialization.class.getName());
            job.setStrings("io.serializations", serializations.toArray(new String[0]));
        }
        DistributedCache.addCacheFile((URI)TetherJob.getExecutable(job), (Configuration)job);
    }

    @Override
    public String getName() {
        return "tether";
    }

    @Override
    public String getShortDescription() {
        return "Run a tethered mapreduce job.";
    }

    @Override
    public int run(InputStream ins, PrintStream outs, PrintStream err, List<String> args) throws Exception {
        OptionParser p = new OptionParser();
        ArgumentAcceptingOptionSpec exec = p.accepts("program", "executable program, usually in HDFS").withRequiredArg().ofType(URI.class);
        ArgumentAcceptingOptionSpec in = p.accepts("in", "comma-separated input paths").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec out = p.accepts("out", "output directory").withRequiredArg().ofType(Path.class);
        ArgumentAcceptingOptionSpec outSchema = p.accepts("outschema", "output schema file").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec mapOutSchema = p.accepts("outschemamap", "map output schema file, if different").withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec reduces = p.accepts("reduces", "number of reduces").withOptionalArg().ofType(Integer.class);
        JobConf job = new JobConf();
        try {
            OptionSet opts = p.parse(args.toArray(new String[0]));
            FileInputFormat.addInputPaths((JobConf)job, (String)((String)in.value(opts)));
            FileOutputFormat.setOutputPath((JobConf)job, (Path)((Path)out.value(opts)));
            TetherJob.setExecutable(job, (URI)exec.value(opts));
            job.set("avro.output.schema", Schema.parse((File)outSchema.value(opts)).toString());
            if (opts.hasArgument((OptionSpec)mapOutSchema)) {
                job.set("avro.map.output.schema", Schema.parse((File)mapOutSchema.value(opts)).toString());
            }
            if (opts.hasArgument((OptionSpec)reduces)) {
                job.setNumReduceTasks(((Integer)reduces.value(opts)).intValue());
            }
        }
        catch (Exception e) {
            p.printHelpOn((OutputStream)err);
            return -1;
        }
        TetherJob.runJob(job);
        return 0;
    }
}

