/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.service;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.acl.Group;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.as.core.security.UniqueIdUserInfo;
import org.jboss.as.domain.management.security.PasswordCredential;
import org.jboss.as.security.SecurityMessages;
import org.jboss.as.security.service.SecurityActions;
import org.jboss.as.security.service.ThreadLocalStack;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.remoting3.security.UserInfo;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SecurityContextUtil;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectInfo;
import org.jboss.security.audit.AuditEvent;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.resources.EJBResource;
import org.jboss.security.callbacks.SecurityContextCallbackHandler;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleIdentity;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.javaee.AbstractEJBAuthorizationHelper;
import org.jboss.security.javaee.SecurityHelperFactory;

public class SimpleSecurityManager
implements ServerSecurityManager {
    private ThreadLocalStack<SecurityContext> contexts = new ThreadLocalStack();
    private boolean propagate = true;
    private ISecurityManagement securityManagement = null;

    public SimpleSecurityManager() {
    }

    public SimpleSecurityManager(SimpleSecurityManager delegate) {
        this.securityManagement = delegate.securityManagement;
        this.propagate = false;
    }

    private PrivilegedAction<SecurityContext> securityContext() {
        return new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        };
    }

    private SecurityContext establishSecurityContext(String securityDomain) {
        try {
            SecurityContext securityContext = SecurityContextFactory.createSecurityContext((String)securityDomain);
            if (this.securityManagement == null) {
                throw SecurityMessages.MESSAGES.securityManagementNotInjected();
            }
            securityContext.setSecurityManagement(this.securityManagement);
            SecurityContextAssociation.setSecurityContext((SecurityContext)securityContext);
            return securityContext;
        }
        catch (Exception e) {
            throw SecurityMessages.MESSAGES.securityException(e);
        }
    }

    public void setSecurityManagement(ISecurityManagement iSecurityManagement) {
        this.securityManagement = iSecurityManagement;
    }

    public Principal getCallerPrincipal() {
        SecurityContext securityContext = AccessController.doPrivileged(this.securityContext());
        if (securityContext == null) {
            return this.getUnauthenticatedIdentity().asPrincipal();
        }
        Object principal = securityContext.getIncomingRunAs();
        if (principal == null) {
            principal = this.getPrincipal(securityContext.getSubjectInfo().getAuthenticatedSubject());
        }
        if (principal == null) {
            return this.getUnauthenticatedIdentity().asPrincipal();
        }
        return principal;
    }

    public Subject getSubject() {
        SecurityContext securityContext = AccessController.doPrivileged(this.securityContext());
        if (securityContext != null) {
            return securityContext.getSubjectInfo().getAuthenticatedSubject();
        }
        return null;
    }

    private Principal getPrincipal(Subject subject) {
        Set<Principal> principals;
        Principal principal = null;
        Principal callerPrincipal = null;
        if (subject != null && (principals = subject.getPrincipals()) != null && !principals.isEmpty()) {
            for (Principal p : principals) {
                Enumeration e;
                Group g;
                if (!(p instanceof Group) && principal == null) {
                    principal = p;
                }
                if (!(p instanceof Group) || !(g = (Group)Group.class.cast(p)).getName().equals("CallerPrincipal") || callerPrincipal != null || !(e = g.members()).hasMoreElements()) continue;
                callerPrincipal = (Principal)e.nextElement();
            }
        }
        return callerPrincipal == null ? principal : callerPrincipal;
    }

    public boolean isCallerInRole(Object incommingMappedRoles, Map<String, Collection<String>> roleLinks, String ... roleNames) {
        Principal callerPrincipal;
        Set mapped;
        SecurityRolesMetaData mappedRoles = (SecurityRolesMetaData)incommingMappedRoles;
        SecurityContext securityContext = AccessController.doPrivileged(this.securityContext());
        if (securityContext == null) {
            return false;
        }
        RoleGroup roleGroup = null;
        RunAs runAs = securityContext.getIncomingRunAs();
        if (runAs != null && runAs instanceof RunAsIdentity) {
            RunAsIdentity runAsIdentity = (RunAsIdentity)runAs;
            roleGroup = runAsIdentity.getRunAsRolesAsRoleGroup();
        } else {
            AuthorizationManager am = securityContext.getAuthorizationManager();
            SecurityContextCallbackHandler scb = new SecurityContextCallbackHandler(securityContext);
            roleGroup = am.getSubjectRoles(securityContext.getSubjectInfo().getAuthenticatedSubject(), (CallbackHandler)scb);
        }
        List roles = roleGroup.getRoles();
        HashSet<String> requiredRoles = new HashSet<String>();
        for (String current : roleNames) {
            requiredRoles.add(current);
        }
        HashSet<String> actualRoles = new HashSet<String>();
        for (Role current : roles) {
            actualRoles.add(current.getRoleName());
        }
        if (mappedRoles != null && (mapped = mappedRoles.getSecurityRoleNamesByPrincipal((callerPrincipal = this.getCallerPrincipal()).getName())) != null) {
            actualRoles.addAll(mapped);
        }
        if (!Collections.disjoint(requiredRoles, actualRoles)) {
            return true;
        }
        if (roleLinks != null) {
            for (String actualRole : actualRoles) {
                Set<String> aliases = this.getRoleAliases(actualRole, roleLinks);
                if (Collections.disjoint(requiredRoles, aliases)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean authorize(String ejbName, CodeSource ejbCodeSource, String ejbMethodIntf, Method ejbMethod, Set<Principal> methodRoles, String contextID) {
        SecurityContext securityContext = AccessController.doPrivileged(this.securityContext());
        if (securityContext == null) {
            return false;
        }
        EJBResource resource = new EJBResource(new HashMap());
        resource.setEjbName(ejbName);
        resource.setEjbMethod(ejbMethod);
        resource.setEjbMethodInterface(ejbMethodIntf);
        resource.setEjbMethodRoles((RoleGroup)new SimpleRoleGroup(methodRoles));
        resource.setCodeSource(ejbCodeSource);
        resource.setPolicyContextID(contextID);
        resource.setCallerRunAsIdentity(securityContext.getIncomingRunAs());
        resource.setCallerSubject(securityContext.getUtil().getSubject());
        Principal userPrincipal = securityContext.getUtil().getUserPrincipal();
        resource.setPrincipal(userPrincipal);
        try {
            AbstractEJBAuthorizationHelper helper = SecurityHelperFactory.getEJBAuthorizationHelper((SecurityContext)securityContext);
            return helper.authorize((Resource)resource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void push(String securityDomain, String runAs, String runAsPrincipal, Set<String> extraRoles) {
        boolean contextPushed = false;
        boolean securityContextEstablished = false;
        SecurityContext previous = SecurityContextAssociation.getSecurityContext();
        try {
            RunAs currentRunAs;
            boolean trusted;
            this.contexts.push(previous);
            contextPushed = true;
            SecurityContext current = this.establishSecurityContext(securityDomain);
            securityContextEstablished = true;
            if (this.propagate && previous != null) {
                current.setSubjectInfo(previous.getSubjectInfo());
                current.setIncomingRunAs(previous.getOutgoingRunAs());
            }
            boolean bl = trusted = (currentRunAs = current.getIncomingRunAs()) != null && currentRunAs instanceof RunAsIdentity;
            if (!trusted) {
                boolean authenticated = false;
                if (SecurityActions.remotingContextIsSet()) {
                    SecurityContextUtil util = current.getUtil();
                    UserInfo userInfo = SecurityActions.remotingContextGetConnection().getUserInfo();
                    SimplePrincipal p = null;
                    String credential = null;
                    Subject subject = null;
                    if (userInfo instanceof SubjectUserInfo) {
                        SubjectUserInfo sinfo = (SubjectUserInfo)userInfo;
                        subject = sinfo.getSubject();
                        Set<PasswordCredential> pcSet = subject.getPrivateCredentials(PasswordCredential.class);
                        if (pcSet.size() > 0) {
                            PasswordCredential pc = pcSet.iterator().next();
                            p = new SimplePrincipal(pc.getUserName());
                            credential = new String(pc.getCredential());
                            SecurityActions.remotingContextClear();
                        }
                        if ((p == null || credential == null) && userInfo instanceof UniqueIdUserInfo) {
                            UniqueIdUserInfo uinfo = (UniqueIdUserInfo)userInfo;
                            p = new SimplePrincipal(sinfo.getUserName());
                            credential = uinfo.getId();
                        }
                    }
                    if (p == null || credential == null) {
                        p = new SimplePrincipal(UUID.randomUUID().toString());
                        credential = UUID.randomUUID().toString();
                    }
                    util.createSubjectInfo((Principal)p, credential, subject);
                }
                if (!authenticated) {
                    authenticated = this.authenticate(current, null);
                }
                if (!authenticated) {
                    throw SecurityMessages.MESSAGES.invalidUserException();
                }
            }
            if (runAs != null) {
                RunAsIdentity runAsIdentity = new RunAsIdentity(runAs, runAsPrincipal, extraRoles);
                current.setOutgoingRunAs((RunAs)runAsIdentity);
            } else if (this.propagate && previous != null && previous.getOutgoingRunAs() != null) {
                current.setOutgoingRunAs(previous.getOutgoingRunAs());
            }
        }
        catch (Throwable t) {
            if (securityContextEstablished) {
                SecurityContextAssociation.setSecurityContext((SecurityContext)previous);
            }
            if (contextPushed) {
                this.contexts.pop();
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public void push(String securityDomain, String userName, char[] password, Subject subject) {
        boolean contextPushed = false;
        boolean securityContextEstablished = false;
        SecurityContext previous = SecurityContextAssociation.getSecurityContext();
        try {
            RunAs currentRunAs;
            boolean trusted;
            this.contexts.push(previous);
            contextPushed = true;
            SecurityContext current = this.establishSecurityContext(securityDomain);
            securityContextEstablished = true;
            if (this.propagate && previous != null) {
                current.setSubjectInfo(previous.getSubjectInfo());
                current.setIncomingRunAs(previous.getOutgoingRunAs());
            }
            boolean bl = trusted = (currentRunAs = current.getIncomingRunAs()) != null && currentRunAs instanceof RunAsIdentity;
            if (!trusted) {
                SecurityContextUtil util = current.getUtil();
                util.createSubjectInfo((Principal)new SimplePrincipal(userName), (Object)new String(password), subject);
                if (!this.authenticate(current, subject)) {
                    throw SecurityMessages.MESSAGES.invalidUserException();
                }
            }
            if (this.propagate && previous != null && previous.getOutgoingRunAs() != null) {
                current.setOutgoingRunAs(previous.getOutgoingRunAs());
            }
        }
        catch (Throwable t) {
            if (securityContextEstablished) {
                SecurityContextAssociation.setSecurityContext((SecurityContext)previous);
            }
            if (contextPushed) {
                this.contexts.pop();
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private boolean authenticate(SecurityContext context, Subject subject) {
        AuditManager auditManager;
        Principal principal;
        SecurityContextUtil util = context.getUtil();
        SubjectInfo subjectInfo = context.getSubjectInfo();
        if (subject == null) {
            subject = new Subject();
        }
        Principal auditPrincipal = principal = util.getUserPrincipal();
        Object credential = util.getCredential();
        Identity unauthenticatedIdentity = null;
        boolean authenticated = false;
        if (principal == null) {
            unauthenticatedIdentity = this.getUnauthenticatedIdentity();
            subjectInfo.addIdentity(unauthenticatedIdentity);
            auditPrincipal = unauthenticatedIdentity.asPrincipal();
            subject.getPrincipals().add(auditPrincipal);
            authenticated = true;
        }
        if (!authenticated) {
            AuthenticationManager authenticationManager = context.getAuthenticationManager();
            authenticated = authenticationManager.isValid(principal, credential, subject);
        }
        if (authenticated) {
            subjectInfo.setAuthenticatedSubject(subject);
        }
        if ((auditManager = context.getAuditManager()) != null) {
            this.audit(authenticated ? "Success" : "Failure", auditManager, auditPrincipal);
        }
        return authenticated;
    }

    private Identity getUnauthenticatedIdentity() {
        return new SimpleIdentity("anonymous");
    }

    public void pop() {
        SecurityContext sc = this.contexts.pop();
        SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
    }

    private Set<String> getRoleAliases(String roleName, Map<String, Collection<String>> roleLinks) {
        if (roleLinks == null || roleLinks.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> aliases = new HashSet<String>();
        for (Map.Entry<String, Collection<String>> roleLinkEntry : roleLinks.entrySet()) {
            String aliasRoleName = roleLinkEntry.getKey();
            Collection<String> realRoleNames = roleLinkEntry.getValue();
            if (realRoleNames == null || !realRoleNames.contains(roleName)) continue;
            aliases.add(aliasRoleName);
        }
        return aliases;
    }

    private void audit(String level, AuditManager auditManager, Principal userPrincipal) {
        AuditEvent auditEvent = new AuditEvent("Success");
        HashMap<String, Object> ctxMap = new HashMap<String, Object>();
        ctxMap.put("principal", userPrincipal != null ? userPrincipal : "null");
        ctxMap.put("Source", this.getClass().getCanonicalName());
        ctxMap.put("Action", "authentication");
        auditEvent.setContextMap(ctxMap);
        auditManager.audit(auditEvent);
    }
}

