/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.www.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.plugins.apache.AvailabilityResult;

public class WWWUtils {
    private static final Log LOG = LogFactory.getLog(WWWUtils.class);
    private static TrustManager NO_OP_TRUST_MANAGER = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    };
    private static HostnameVerifier NO_OP_HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    };

    private WWWUtils() {
    }

    @Deprecated
    public static boolean isAvailable(URL httpURL, int timeout) {
        return WWWUtils.checkAvailability(httpURL, timeout).getAvailabilityType() == AvailabilityType.UP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AvailabilityResult checkAvailability(URL httpURL, int timeout) {
        HttpURLConnection connection;
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout cannot be negative.");
        }
        if (timeout == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Pinging [" + httpURL + "] with no timeout..."));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Pinging [" + httpURL + "] with timeout of " + timeout + " milliseconds..."));
        }
        try {
            connection = (HttpURLConnection)httpURL.openConnection();
            connection.setInstanceFollowRedirects(false);
        }
        catch (IOException e) {
            String errorMessage = "Failed to open URLConnection for [" + httpURL + "].";
            LOG.error((Object)errorMessage, (Throwable)e);
            return AvailabilityResult.availabilityIsDown(errorMessage, e);
        }
        try {
            connection.setRequestMethod("HEAD");
        }
        catch (ProtocolException ignore) {
            try {
                connection.setRequestMethod("GET");
            }
            catch (ProtocolException e) {
                String errorMessage = "Failed to set request method to HEAD or GET on URLConnection for [" + httpURL + "].";
                LOG.error((Object)errorMessage, (Throwable)e);
                return AvailabilityResult.availabilityIsDown(errorMessage, e);
            }
        }
        connection.setConnectTimeout(timeout);
        if (connection instanceof HttpsURLConnection) {
            WWWUtils.disableCertificateVerification((HttpsURLConnection)connection);
        }
        long connectStartTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Connecting to [" + httpURL + "]..."));
        }
        try {
            connection.connect();
        }
        catch (IOException e) {
            String errorMessage;
            AvailabilityResult.ErrorType errorType = AvailabilityResult.ErrorType.UNKNOWN;
            if (e instanceof ConnectException) {
                errorMessage = "Failed to connect to [" + httpURL + "].";
                errorType = AvailabilityResult.ErrorType.CANNOT_CONNECT;
            } else if (e instanceof SocketTimeoutException) {
                long connectDuration = System.currentTimeMillis() - connectStartTime;
                errorMessage = "Attempt to connect to [" + httpURL + "] timed out after " + connectDuration + " milliseconds.";
                errorType = AvailabilityResult.ErrorType.CONNECTION_TIMEOUT;
            } else {
                errorMessage = "An error occurred while attempting to connect to [" + httpURL + "].";
            }
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)errorMessage, (Throwable)e);
            }
            return AvailabilityResult.availabilityIsDown(errorType, errorMessage, e);
        }
        int connectDuration = (int)(System.currentTimeMillis() - connectStartTime);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Connected to [" + httpURL + "] in " + connectDuration + " milliseconds."));
        }
        if (timeout > 0 && connectDuration >= timeout) {
            String errorMessage = "Attempt to ping [" + httpURL + "] timed out after " + connectDuration + " milliseconds.";
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)errorMessage);
            }
            return AvailabilityResult.availabilityIsDown(AvailabilityResult.ErrorType.CONNECTION_TIMEOUT, errorMessage);
        }
        try {
            int readTimeout = timeout > 0 ? timeout - connectDuration : 0;
            connection.setReadTimeout(readTimeout);
            if (connection.getReadTimeout() != readTimeout && LOG.isDebugEnabled()) {
                LOG.warn((Object)("Failed to set read timeout on URLConnection for [" + httpURL + "] - this most likely means we're running in a non-standard JRE."));
            }
            long readStartTime = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sending " + connection.getRequestMethod() + " request to [" + httpURL + "]..."));
            }
            try {
                int responseCode = connection.getResponseCode();
                if (LOG.isDebugEnabled()) {
                    if (responseCode == -1) {
                        LOG.warn((Object)("Ping request to [" + httpURL + "] returned an invalid response: " + WWWUtils.getResponseBody(connection)));
                    } else if (responseCode >= 500) {
                        LOG.warn((Object)("Ping request to [" + httpURL + "] returned a response with server error " + responseCode + " (" + connection.getResponseMessage() + "): " + WWWUtils.getResponseBody(connection)));
                    } else if (responseCode >= 400) {
                        LOG.warn((Object)("Ping request to [" + httpURL + "] returned a response with client error " + responseCode + " (" + connection.getResponseMessage() + ")."));
                    }
                }
            }
            catch (IOException e) {
                String errorMessage;
                AvailabilityResult.ErrorType errorType = AvailabilityResult.ErrorType.UNKNOWN;
                if (e instanceof SocketTimeoutException) {
                    long readDuration = System.currentTimeMillis() - readStartTime;
                    errorMessage = "Attempt to read response from " + connection.getRequestMethod() + " request to [" + httpURL + "] timed out after " + readDuration + " milliseconds.";
                    errorType = AvailabilityResult.ErrorType.CONNECTION_TIMEOUT;
                } else {
                    errorMessage = "An error occurred while attempting to read response from " + connection.getRequestMethod() + " to [" + httpURL + "].";
                }
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)errorMessage, (Throwable)e);
                }
                AvailabilityResult availabilityResult = AvailabilityResult.availabilityIsDown(errorType, errorMessage, e);
                connection.disconnect();
                return availabilityResult;
            }
            long readDuration = System.currentTimeMillis() - readStartTime;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Read response from " + connection.getRequestMethod() + " request to [" + httpURL + "] in " + readDuration + " milliseconds."));
            }
        }
        finally {
            connection.disconnect();
        }
        return AvailabilityResult.availabilityIsUp();
    }

    public static String getServerHeader(URL httpURL) {
        String ret;
        try {
            HttpURLConnection connection = (HttpURLConnection)httpURL.openConnection();
            connection.setRequestMethod("HEAD");
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(1000);
            connection.connect();
            connection.getResponseCode();
            ret = connection.getHeaderField("Server");
        }
        catch (IOException e) {
            ret = null;
        }
        return ret;
    }

    private static void disableCertificateVerification(HttpsURLConnection connection) {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{NO_OP_TRUST_MANAGER}, new SecureRandom());
            connection.setSSLSocketFactory(sslContext.getSocketFactory());
            connection.setHostnameVerifier(NO_OP_HOSTNAME_VERIFIER);
        }
        catch (Exception e) {
            WWWUtils.logWarnWithStackTraceOnlyIfDebugEnabled("Failed to disable certificate and hostname validation on URLConnection for [" + connection.getURL() + "].", e);
        }
    }

    private static void logWarnWithStackTraceOnlyIfDebugEnabled(String message, Exception e) {
        if (LOG.isDebugEnabled()) {
            LOG.warn((Object)message, (Throwable)e);
        } else {
            LOG.warn((Object)(message + " (enable DEBUG logging to see stack trace): " + e));
        }
    }

    private static String getResponseBody(HttpURLConnection connection) {
        String responseBody;
        try {
            InputStream inputStream = connection.getInputStream() != null ? connection.getInputStream() : connection.getErrorStream();
            responseBody = inputStream != null ? StreamUtil.slurp((Reader)new InputStreamReader(inputStream)) : "";
        }
        catch (IOException e) {
            responseBody = "";
        }
        return responseBody;
    }
}

