/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.rhq.plugins.apache.parser.ApacheDirective;

public class ApacheDirectiveTree
implements Cloneable {
    private ApacheDirective rootNode = new ApacheDirective();

    public ApacheDirectiveTree() {
        this.rootNode.setRootNode(true);
    }

    public ApacheDirective getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(ApacheDirective rootNode) {
        this.rootNode = rootNode;
    }

    public List<ApacheDirective> search(ApacheDirective nd, String name) {
        return this.parseExpr(nd, name);
    }

    public List<ApacheDirective> search(String name) {
        if (name.startsWith("/")) {
            return this.parseExpr(this.rootNode, name.substring(1));
        }
        return this.parseExpr(this.rootNode, name);
    }

    public List<ApacheDirective> findByName(ApacheDirective nd, String name, boolean recursively) {
        ArrayList<ApacheDirective> ret = new ArrayList<ApacheDirective>();
        this.findByName(nd, name, recursively, ret);
        return ret;
    }

    public List<ApacheDirective> findByName(String name, boolean recursively) {
        return this.findByName(this.rootNode, name, recursively);
    }

    public Set<String> getAllPaths() {
        HashSet<String> paths = new HashSet<String>();
        this.addPath(this.rootNode, paths);
        return paths;
    }

    private void addPath(ApacheDirective directive, Set<String> paths) {
        for (ApacheDirective c : directive.getChildDirectives()) {
            paths.add(c.getFile());
            this.addPath(c, paths);
        }
    }

    private void findByName(ApacheDirective root, String name, boolean recursively, List<ApacheDirective> results) {
        for (ApacheDirective child : root.getChildDirectives()) {
            if (name.equals(child.getName())) {
                results.add(child);
            }
            if (!recursively) continue;
            this.findByName(child, name, true, results);
        }
    }

    private List<ApacheDirective> parseExpr(ApacheDirective nd, String expr) {
        int index = expr.indexOf("/");
        String name = index == -1 ? expr : expr.substring(0, index);
        ArrayList<ApacheDirective> nds = new ArrayList<ApacheDirective>();
        for (ApacheDirective dir : nd.getChildByName(name)) {
            if (index == -1) {
                nds.add(dir);
                continue;
            }
            List<ApacheDirective> tempNodes = this.parseExpr(dir, expr.substring(index + 1));
            if (tempNodes == null) continue;
            nds.addAll(tempNodes);
        }
        return nds;
    }

    public ApacheDirective createNode(ApacheDirective parentNode, String name) {
        ApacheDirective dir = new ApacheDirective(name);
        dir.setParentNode(parentNode);
        parentNode.addChildDirective(dir);
        return dir;
    }

    public ApacheDirectiveTree clone() {
        ApacheDirectiveTree copy = new ApacheDirectiveTree();
        copy.rootNode = this.rootNode.clone();
        return copy;
    }
}

