/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.augeas.util.Glob;
import org.rhq.augeas.util.GlobFilter;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.apache.ApacheServerComponent;
import org.rhq.plugins.apache.parser.ApacheConfigReader;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;
import org.rhq.plugins.apache.parser.ApacheParserImpl;
import org.rhq.plugins.apache.util.ApacheBinaryInfo;
import org.rhq.plugins.apache.util.AugeasNodeValueUtil;
import org.rhq.plugins.apache.util.HttpdAddressUtility;
import org.rhq.plugins.apache.util.OsProcessUtility;
import org.rhq.plugins.apache.util.RuntimeApacheConfiguration;
import org.rhq.plugins.platform.PlatformComponent;

public class ApacheServerDiscoveryComponent
implements ResourceDiscoveryComponent<PlatformComponent>,
ManualAddFacet<PlatformComponent>,
ResourceUpgradeFacet<PlatformComponent> {
    private static final String PRODUCT_DESCRIPTION = "Apache Web Server";
    private static final Log log = LogFactory.getLog(ApacheServerDiscoveryComponent.class);
    public static final Map<String, String> MODULE_SOURCE_FILE_TO_MODULE_NAME_20 = new LinkedHashMap<String, String>();
    public static final Map<String, String> MODULE_SOURCE_FILE_TO_MODULE_NAME_13;

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<PlatformComponent> discoveryContext) throws Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        List processes = discoveryContext.getAutoDiscoveredProcesses();
        for (ProcessScanResult process : processes) {
            try {
                DiscoveredResourceDetails apache = this.discoverSingleProcess(discoveryContext, process);
                if (apache == null) continue;
                discoveredResources.add(apache);
            }
            catch (DiscoveryFailureException e) {
                log.warn((Object)("Discovery of Apache process [" + process.getProcessInfo() + "] failed: " + e.getMessage()));
            }
            catch (Exception e) {
                log.error((Object)("Discovery of Apache process [" + process.getProcessInfo() + "] failed with an exception."), (Throwable)e);
            }
        }
        return discoveredResources;
    }

    private DiscoveredResourceDetails discoverSingleProcess(ResourceDiscoveryContext<PlatformComponent> discoveryContext, ProcessScanResult process) throws DiscoveryFailureException, Exception {
        ApacheBinaryInfo binaryInfo;
        if (ApacheServerDiscoveryComponent.isWindowsServiceRootInstance(process)) {
            return null;
        }
        File executablePath = ApacheServerDiscoveryComponent.getExecutableAbsolutePath(process);
        log.debug((Object)("Apache executable path: " + executablePath));
        try {
            binaryInfo = ApacheBinaryInfo.getInfo(executablePath.getPath(), discoveryContext.getSystemInformation());
        }
        catch (Exception e) {
            throw new DiscoveryFailureException("'" + executablePath + "' is not a valid Apache executable (" + e + ").");
        }
        if (!this.isSupportedVersion(binaryInfo.getVersion())) {
            throw new DiscoveryFailureException("Apache " + binaryInfo.getVersion() + " is not supported.");
        }
        String serverRoot = this.getServerRoot(binaryInfo, process.getProcessInfo());
        if (serverRoot == null) {
            throw new DiscoveryFailureException("Unable to determine server root.");
        }
        File serverConfigFile = this.getServerConfigFile(binaryInfo, process.getProcessInfo(), serverRoot);
        if (serverConfigFile == null) {
            throw new DiscoveryFailureException("Unable to determine server config file.");
        }
        Configuration pluginConfig = discoveryContext.getDefaultPluginConfiguration();
        PropertySimple executablePathProp = new PropertySimple("executablePath", (Object)executablePath);
        pluginConfig.put((Property)executablePathProp);
        PropertySimple serverRootProp = new PropertySimple("serverRoot", (Object)serverRoot);
        pluginConfig.put((Property)serverRootProp);
        PropertySimple configFile = new PropertySimple("configFile", (Object)serverConfigFile);
        pluginConfig.put((Property)configFile);
        PropertySimple inclusionGlobs = new PropertySimple("configurationFilesInclusionPatterns", (Object)serverConfigFile);
        pluginConfig.put((Property)inclusionGlobs);
        pluginConfig.put((Property)new PropertyList("customModuleNames"));
        ApacheDirectiveTree serverConfig = ApacheServerDiscoveryComponent.parseRuntimeConfiguration(serverConfigFile.getAbsolutePath(), process.getProcessInfo(), binaryInfo);
        String serverUrl = null;
        String vhostsGlobInclude = null;
        List<ApacheDirective> serverRoots = serverConfig.search("/ServerRoot");
        if (!serverRoots.isEmpty()) {
            serverRoot = AugeasNodeValueUtil.unescape(serverRoots.get(0).getValuesAsString());
            serverRootProp.setValue((Object)serverRoot);
        }
        serverUrl = ApacheServerDiscoveryComponent.getUrl(serverConfig, binaryInfo.getVersion());
        vhostsGlobInclude = ApacheServerDiscoveryComponent.scanForGlobInclude(serverConfig);
        if (serverUrl != null) {
            PropertySimple urlProp = new PropertySimple("url", (Object)serverUrl);
            pluginConfig.put((Property)urlProp);
        }
        if (vhostsGlobInclude != null) {
            pluginConfig.put((Property)new PropertySimple("vhostFilesMask", (Object)vhostsGlobInclude));
        } else if (serverConfigFile.exists()) {
            pluginConfig.put((Property)new PropertySimple("vhostFilesMask", (Object)(serverConfigFile.getParent() + File.separator + "*")));
        }
        List<InetSocketAddress> snmpAddresses = ApacheServerDiscoveryComponent.findSNMPAddresses(serverConfig, new File(serverRoot));
        if (snmpAddresses != null && snmpAddresses.size() > 0) {
            InetSocketAddress addr = snmpAddresses.get(0);
            int port = addr.getPort();
            InetAddress host = addr.getAddress() == null || addr.getAddress().isAnyLocalAddress() ? InetAddress.getLocalHost() : addr.getAddress();
            pluginConfig.put((Property)new PropertySimple("snmpAgentHost", (Object)host.getHostAddress()));
            pluginConfig.put((Property)new PropertySimple("snmpAgentPort", (Object)port));
        } else {
            String bmxURL = ApacheServerDiscoveryComponent.findBMXURL(serverConfig);
            if (bmxURL != null) {
                pluginConfig.put((Property)new PropertySimple("bmxUrl", (Object)bmxURL));
            }
        }
        return this.createResourceDetails(discoveryContext, pluginConfig, process.getProcessInfo(), binaryInfo);
    }

    public ResourceUpgradeReport upgrade(ResourceUpgradeContext<PlatformComponent> context) {
        String inventoriedResourceKey = context.getResourceKey();
        if (inventoriedResourceKey.contains("||")) {
            return null;
        }
        String resourceKey = ApacheServerDiscoveryComponent.formatResourceKey(context.getPluginConfiguration());
        ResourceUpgradeReport rep = new ResourceUpgradeReport();
        rep.setNewResourceKey(resourceKey);
        return rep;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext<PlatformComponent> discoveryContext) throws InvalidPluginConfigurationException {
        ApacheBinaryInfo binaryInfo;
        ApacheServerDiscoveryComponent.validateServerRootAndServerConfigFile(pluginConfig);
        String executablePath = pluginConfig.getSimpleValue("executablePath", ApacheServerComponent.DEFAULT_EXECUTABLE_PATH);
        String absoluteExecutablePath = ApacheServerComponent.resolvePathRelativeToServerRoot(pluginConfig, executablePath).getPath();
        try {
            binaryInfo = ApacheBinaryInfo.getInfo(absoluteExecutablePath, discoveryContext.getSystemInformation());
        }
        catch (Exception e) {
            throw new InvalidPluginConfigurationException("'" + absoluteExecutablePath + "' is not a valid Apache executable (" + e + "). Please make sure the '" + "executablePath" + "' connection property is set correctly.");
        }
        if (!this.isSupportedVersion(binaryInfo.getVersion())) {
            throw new InvalidPluginConfigurationException("Version of Apache executable (" + binaryInfo.getVersion() + ") is not a supported version; supported versions are 1.3.x and 2.x.");
        }
        ProcessInfo processInfo = null;
        try {
            DiscoveredResourceDetails resourceDetails = this.createResourceDetails(discoveryContext, pluginConfig, processInfo, binaryInfo);
            return resourceDetails;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create resource details during manual add.");
        }
    }

    private boolean isSupportedVersion(String version) {
        return version != null && (version.startsWith("1.3") || version.startsWith("2."));
    }

    private DiscoveredResourceDetails createResourceDetails(ResourceDiscoveryContext<PlatformComponent> discoveryContext, Configuration pluginConfig, ProcessInfo processInfo, ApacheBinaryInfo binaryInfo) throws Exception {
        String name;
        String httpdConf = pluginConfig.getSimple("configFile").getStringValue();
        String version = binaryInfo.getVersion();
        String serverUrl = pluginConfig.getSimpleValue("url", null);
        if (serverUrl == null) {
            name = httpdConf;
        } else {
            URI uri = new URI(serverUrl);
            name = uri.getHost() + ":" + uri.getPort();
        }
        String key = ApacheServerDiscoveryComponent.formatResourceKey(pluginConfig);
        DiscoveredResourceDetails resourceDetails = new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, version, PRODUCT_DESCRIPTION, pluginConfig, processInfo);
        log.debug((Object)("Apache Server resource details created: " + resourceDetails));
        return resourceDetails;
    }

    private static String getUrl(ApacheDirectiveTree serverConfig, String version) throws Exception {
        HttpdAddressUtility.Address addr = HttpdAddressUtility.get(version).getMainServerSampleAddress(serverConfig, null, 0);
        return addr == null ? null : addr.toString();
    }

    @Nullable
    private String getServerRoot(@NotNull ApacheBinaryInfo binaryInfo, @NotNull ProcessInfo processInfo) {
        String[] cmdLine = processInfo.getCommandLine();
        String root = ApacheServerDiscoveryComponent.getCommandLineOption(cmdLine, "-d");
        if (root == null) {
            root = binaryInfo.getRoot();
        }
        if (root == null) {
            return null;
        }
        File rootFile = new File(root);
        if (!rootFile.isAbsolute()) {
            String currentWorkingDir;
            try {
                currentWorkingDir = processInfo.getCurrentWorkingDirectory();
            }
            catch (Exception e) {
                log.error((Object)("Unable to determine current working directory of Apache process [" + processInfo + "], which is needed to determine the server root of the Apache instance."), (Throwable)e);
                return null;
            }
            if (currentWorkingDir == null) {
                log.error((Object)("Unable to determine current working directory of Apache process [" + processInfo + "], which is needed to determine the server root of the Apache instance."));
                return null;
            }
            rootFile = new File(currentWorkingDir, root);
            root = rootFile.getPath();
        }
        root = FileUtils.getCanonicalPath((String)root);
        return root;
    }

    @Nullable
    private File getServerConfigFile(ApacheBinaryInfo binaryInfo, ProcessInfo processInfo, String serverRoot) {
        String[] cmdLine = processInfo.getCommandLine();
        String serverConfigFile = ApacheServerDiscoveryComponent.getCommandLineOption(cmdLine, "-f");
        if (serverConfigFile == null) {
            serverConfigFile = binaryInfo.getCtl();
        }
        if (serverConfigFile == null) {
            return null;
        }
        File file = new File(serverConfigFile);
        if (!file.isAbsolute()) {
            file = new File(serverRoot, serverConfigFile);
            serverConfigFile = file.getPath();
        }
        serverConfigFile = FileUtils.getCanonicalPath((String)serverConfigFile);
        return new File(serverConfigFile);
    }

    private static String getCommandLineOption(String[] cmdLine, String option) {
        String root = null;
        for (int i = 1; i < cmdLine.length; ++i) {
            String arg = cmdLine[i];
            if (!arg.startsWith(option)) continue;
            root = arg.substring(2, arg.length());
            if (root.length() != 0) break;
            root = cmdLine[i + 1];
            break;
        }
        return root;
    }

    private static String getExecutableName(ProcessScanResult processScanResult) {
        String query = processScanResult.getProcessScan().getQuery().toLowerCase();
        String executableName = query.contains("apache.exe") ? "apache.exe" : (query.contains("httpd.exe") ? "httpd.exe" : (query.contains("apache2") ? "apache2" : (query.contains("httpd") ? "httpd" : null)));
        return executableName;
    }

    private static File getExecutableAbsolutePath(ProcessScanResult process) throws DiscoveryFailureException {
        String executableName = ApacheServerDiscoveryComponent.getExecutableName(process);
        File executablePath = OsProcessUtility.getProcExe(process.getProcessInfo().getPid(), executableName);
        if (executablePath == null) {
            throw new DiscoveryFailureException("Executable path could not be determined.");
        }
        if (!executablePath.isAbsolute()) {
            String errorMessage = "Executable path (" + executablePath + ") is not absolute. " + "Please restart Apache specifying an absolute path for the executable or " + "make sure that the user running the RHQ agent is able to access the commandline parameters of the " + executableName + " process.";
            Exception cause = null;
            boolean success = false;
            try {
                String cwd = process.getProcessInfo().getCurrentWorkingDirectory();
                if (cwd != null) {
                    success = (executablePath = new File(cwd, executablePath.getPath())).isAbsolute() && executablePath.isFile();
                }
            }
            catch (Exception e) {
                cause = e;
            }
            if (!success) {
                throw new DiscoveryFailureException(errorMessage, cause);
            }
        }
        return executablePath;
    }

    private static void validateServerRootAndServerConfigFile(Configuration pluginConfig) {
        File httpdConfFile;
        File serverRootFile;
        String serverRoot = pluginConfig.getSimple("serverRoot").getStringValue();
        try {
            serverRootFile = new File(serverRoot).getCanonicalFile();
        }
        catch (IOException e) {
            serverRootFile = null;
        }
        if (serverRootFile == null || !serverRootFile.isDirectory()) {
            throw new InvalidPluginConfigurationException("'" + serverRoot + "' does not exist or is not a directory. Please make sure the '" + "serverRoot" + "' connection property is set correctly.");
        }
        String httpdConf = pluginConfig.getSimple("configFile").getStringValue();
        try {
            httpdConfFile = new File(httpdConf).getCanonicalFile();
        }
        catch (IOException e) {
            httpdConfFile = null;
        }
        if (httpdConfFile == null || !httpdConfFile.isFile()) {
            throw new InvalidPluginConfigurationException("'" + httpdConf + "' does not exist or is not a regular file. Please make sure the '" + "configFile" + "' connection property is set correctly.");
        }
    }

    public static ApacheDirectiveTree parseFullConfiguration(String path, String serverRoot) {
        ApacheDirectiveTree tree = new ApacheDirectiveTree();
        ApacheParserImpl parser = new ApacheParserImpl(tree, serverRoot, null);
        ApacheConfigReader.buildTree(path, parser);
        return tree;
    }

    public static ApacheDirectiveTree parseRuntimeConfiguration(String path, ProcessInfo processInfo, ApacheBinaryInfo binaryInfo) {
        String httpdVersion = binaryInfo.getVersion();
        Map<String, String> defaultModuleNames = ApacheServerDiscoveryComponent.getDefaultModuleNames(httpdVersion);
        return ApacheServerDiscoveryComponent.parseRuntimeConfiguration(path, processInfo, binaryInfo, defaultModuleNames, true, false);
    }

    public static ApacheDirectiveTree parseRuntimeConfiguration(String path, ProcessInfo processInfo, ApacheBinaryInfo binaryInfo, Map<String, String> moduleNames, boolean suppressUnknownModuleWarnings, boolean keepConditional) {
        String defaultServerRoot = binaryInfo.getRoot();
        RuntimeApacheConfiguration.NodeInspector insp = RuntimeApacheConfiguration.getNodeInspector(processInfo, binaryInfo, moduleNames, suppressUnknownModuleWarnings, keepConditional);
        ApacheDirectiveTree tree = new ApacheDirectiveTree();
        ApacheParserImpl parser = new ApacheParserImpl(tree, defaultServerRoot, insp);
        ApacheConfigReader.buildTree(path, parser);
        return tree;
    }

    public static String scanForGlobInclude(ApacheDirectiveTree tree) {
        try {
            List<ApacheDirective> includes = tree.search("/Include");
            block2: for (ApacheDirective n : includes) {
                String include = n.getValuesAsString();
                if (!Glob.isWildcard((String)include)) continue;
                for (char specialChar : GlobFilter.WILDCARD_CHARS) {
                    if (specialChar == '*') {
                        if (include.indexOf(specialChar) != include.lastIndexOf(specialChar)) continue block2;
                        return include;
                    }
                    if (include.indexOf(specialChar) >= 0) continue block2;
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to detect glob includes in httpd.conf.", (Throwable)e);
        }
        return null;
    }

    public static String formatResourceKey(Configuration pluginConfiguration) {
        String serverRoot = pluginConfiguration.getSimple("serverRoot").getStringValue();
        String httpdConf = pluginConfiguration.getSimple("configFile").getStringValue();
        return ApacheServerDiscoveryComponent.formatResourceKey(serverRoot, httpdConf);
    }

    public static String formatResourceKey(String serverRoot, String httpdConf) {
        serverRoot = FileUtils.getCanonicalPath((String)serverRoot);
        File httpdConfF = new File(httpdConf);
        if (!httpdConfF.isAbsolute()) {
            httpdConfF = new File(serverRoot, httpdConf);
            httpdConf = httpdConfF.getAbsolutePath();
        }
        httpdConf = FileUtils.getCanonicalPath((String)httpdConf);
        return serverRoot + "||" + httpdConf;
    }

    private static List<InetSocketAddress> findSNMPAddresses(ApacheDirectiveTree tree, File serverRoot) {
        File snmpdConf;
        ArrayList<InetSocketAddress> ret = new ArrayList<InetSocketAddress>();
        List<ApacheDirective> confs = tree.search("/SNMPConf");
        if (confs.size() == 0) {
            log.info((Object)"SNMPConf directive not found. Skipping SNMP configuration.");
            return ret;
        }
        String confDirName = confs.get(0).getValuesAsString();
        if (confDirName == null || confDirName.isEmpty()) {
            log.warn((Object)"The SNMPConf directive seems to not have a value. Skipping SNMP configuration.");
            return ret;
        }
        File confDir = new File(confDirName);
        if (!confDir.isAbsolute()) {
            confDir = new File(serverRoot, confDirName);
        }
        if (!(snmpdConf = new File(confDir, "snmpd.conf")).exists()) {
            log.warn((Object)("Could not find a snmpd.conf file under the configured directory '" + confDirName + "'. Skipping SNMP configuration."));
            return ret;
        }
        try {
            String agentAddressLine = ApacheServerDiscoveryComponent.findSNMPAgentAddressConfigLine(snmpdConf);
            if (agentAddressLine == null) {
                log.warn((Object)"Could not find the 'agentaddress' property in the snmpd.conf. Skipping SNMP configuration.");
                return ret;
            }
            int specStartIdx = agentAddressLine.indexOf("agentaddress") + "agentaddress".length() + 1;
            while (Character.isWhitespace(agentAddressLine.charAt(specStartIdx))) {
                ++specStartIdx;
            }
            String spec = agentAddressLine.substring(specStartIdx);
            String[] addrs = spec.split(",");
            try {
                for (String addr : addrs) {
                    if (addr.startsWith("udp") || addr.startsWith("tcp")) {
                        addr = addr.substring(4);
                    }
                    int atIdx = addr.indexOf(64);
                    String port = addr;
                    String host = null;
                    if (atIdx > 0) {
                        host = addr.substring(atIdx + 1);
                        port = addr.substring(0, atIdx);
                    }
                    InetSocketAddress address = host != null ? new InetSocketAddress(host, Integer.parseInt(port)) : new InetSocketAddress(Integer.parseInt(port));
                    ret.add(address);
                }
            }
            catch (Exception e) {
                log.warn((Object)("Failed to parse the SNMP 'agentaddress' configuration property: " + agentAddressLine), (Throwable)e);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Failed to read in the configured snmpd.conf file: " + snmpdConf.getAbsolutePath()), (Throwable)e);
        }
        return ret;
    }

    private static String findBMXURL(ApacheDirectiveTree tree) {
        List<ApacheDirective> locations;
        List<ApacheDirective> virtualhosts = tree.getRootNode().getChildByName("<VirtualHost");
        if (!virtualhosts.isEmpty()) {
            log.debug((Object)"findBMXURL: Looking in VirtualHosts");
            for (ApacheDirective virtualhost : virtualhosts) {
                List<ApacheDirective> locations2 = virtualhost.getChildByName("<Location");
                if (locations2.isEmpty()) continue;
                for (ApacheDirective location : locations2) {
                    List<ApacheDirective> handlers = location.getChildByName("SetHandler");
                    if (handlers.isEmpty()) continue;
                    for (ApacheDirective handler : handlers) {
                        for (String val : handler.getValues()) {
                            int index;
                            if (!"bmx-handler".equalsIgnoreCase(val)) continue;
                            String servername = null;
                            String port = null;
                            port = virtualhost.getValues().get(0);
                            if (port.startsWith("*:")) {
                                port = port.substring(2);
                            } else {
                                index = port.lastIndexOf(58);
                                servername = port.substring(0, index);
                                port = port.substring(index + 1);
                            }
                            if (!virtualhost.getChildByName("ServerName").isEmpty() && (index = (servername = virtualhost.getChildByName("ServerName").get(0).getValues().get(0)).lastIndexOf(58)) > 0) {
                                servername = servername.substring(0, index);
                            }
                            if (servername == null) {
                                servername = "localhost";
                            }
                            return "http://" + servername + ":" + port + location.getValues().get(0);
                        }
                    }
                }
            }
        }
        if (!(locations = tree.getRootNode().getChildByName("<Location")).isEmpty()) {
            log.debug((Object)"findBMXURL: Looking outside VirtualHosts");
            for (ApacheDirective location : locations) {
                List<ApacheDirective> handlers = location.getChildByName("SetHandler");
                if (handlers.isEmpty()) continue;
                for (ApacheDirective handler : handlers) {
                    for (String val : handler.getValues()) {
                        if (!"bmx-handler".equalsIgnoreCase(val)) continue;
                        String servername = null;
                        String port = null;
                        List<ApacheDirective> ports = tree.getRootNode().getChildByName("Listen");
                        if (ports.isEmpty()) {
                            log.error((Object)"findBMXURL: Can't find Listen directive");
                            return null;
                        }
                        port = ports.get(0).getValues().get(0);
                        int index = port.lastIndexOf(58);
                        if (index > 0) {
                            servername = port.substring(0, index);
                            port = port.substring(index + 1);
                        }
                        if (!tree.getRootNode().getChildByName("ServerName").isEmpty() && (index = (servername = tree.getRootNode().getChildByName("ServerName").get(0).getValues().get(0)).lastIndexOf(58)) > 0) {
                            servername = servername.substring(0, index);
                        }
                        if (servername == null) {
                            servername = "localhost";
                        }
                        return "http://" + servername + ":" + port + location.getValues().get(0);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findSNMPAgentAddressConfigLine(File snmpdConf) throws IOException {
        BufferedReader rdr = new BufferedReader(new FileReader(snmpdConf));
        try {
            String line;
            Pattern search = Pattern.compile("^\\s*agentaddress.*");
            while ((line = rdr.readLine()) != null) {
                if (!search.matcher(line).matches()) continue;
                String string = line;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            rdr.close();
        }
    }

    public static Map<String, String> getDefaultModuleNames(String version) {
        switch (HttpdAddressUtility.get(version)) {
            case APACHE_1_3: {
                return MODULE_SOURCE_FILE_TO_MODULE_NAME_13;
            }
            case APACHE_2_x: {
                return MODULE_SOURCE_FILE_TO_MODULE_NAME_20;
            }
        }
        throw new IllegalStateException("Unknown HttpdAddressUtility instance.");
    }

    private static boolean isWindowsServiceRootInstance(ProcessScanResult process) {
        String kArg = ApacheServerDiscoveryComponent.getCommandLineOption(process.getProcessInfo().getCommandLine(), "-k");
        return kArg != null && kArg.equalsIgnoreCase("runservice");
    }

    static {
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("beos.c", "mpm_beos_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("event.c", "mpm_event_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mpm_netware.c", "mpm_netware_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mpmt_os2.c", "mpm_mpmt_os2_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("prefork.c", "mpm_prefork_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mpm_winnt.c", "mpm_winnt_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("worker.c", "mpm_worker_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_actions.c", "actions_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_alias.c", "alias_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_asis.c", "asis_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_auth_basic.c", "auth_basic_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_auth_digest.c", "auth_digest_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_authn_alias.c", "authn_alias_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_authn_anon.c", "authn_anon_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_authn_dbd.c", "authn_dbd_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_authn_dbm.c", "authn_dbm_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_authn_default.c", "authn_default_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_authn_file.c", "authn_file_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_authnz_ldap.c", "authnz_ldap_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_authz_dbm.c", "authz_dbm_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_authz_default.c", "authz_default_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_authz_groupfile.c", "authz_groupfile_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_authz_host.c", "authz_host_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_authz_owner.c", "authz_owner_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_authz_user.c", "authz_user_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_autoindex.c", "autoindex_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_cache.c", "cache_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_cern_meta.c", "cern_meta_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_cgi.c", "cgi_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_cgid.c", "cgid_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_charset_lite.c", "charset_lite_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_dav.c", "dav_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_dav_fs.c", "dav_fs_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_dav_lock.c", "dav_lock_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_dbd.c", "dbd_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_deflate.c", "deflate_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_dir.c", "dir_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_disk_cache.c", "disk_cache_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_dumpio.c", "dumpio_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_echo.c", "echo_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_env.c", "env_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_example.c", "example_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_expires.c", "expires_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_ext_filter.c", "ext_filter_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_file_cache.c", "file_cache_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_filter.c", "filter_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_headers.c", "headers_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_ident.c", "ident_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_imagemap.c", "imagemap_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_include.c", "include_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_info.c", "info_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_isapi.c", "isapi_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("util_ldap.c", "ldap_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_log_config.c", "log_config_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_log_forensic.c", "log_forensic_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_logio.c", "logio_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_mem_cache.c", "mem_cache_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_mime.c", "mime_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_mime_magic.c", "mime_magic_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_negotiation.c", "negotiation_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_nw_ssl.c", "nwssl_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_proxy.c", "proxy_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_proxy_ajp.c", "proxy_ajp_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_proxy_balancer.c", "proxy_balancer_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_proxy_connect.c", "proxy_connect_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_proxy_ftp.c", "proxy_ftp_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_proxy_http.c", "proxy_http_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_proxy_scgi.c", "proxy_scgi_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_reqtimeout.c", "reqtimeout_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_rewrite.c", "rewrite_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_setenvif.c", "setenvif_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_so.c", "so_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_speling.c", "speling_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_ssl.c", "ssl_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_status.c", "status_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_substitute.c", "substitute_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_suexec.c", "suexec_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_unique_id.c", "unique_id_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_userdir.c", "userdir_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_usertrack.c", "usertrack_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_version.c", "version_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_vhost_alias.c", "vhost_alias_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_jk.c", "jk_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod-snmpcommon.c", "snmpcommon_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod-snmpagt.c", "snmpagt_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("covalent-snmp-v20.c", "snmp_agt_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_20.put("mod_bmx.c", "bmx_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13 = new LinkedHashMap<String, String>();
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_access.c", "access_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_actions.c", "action_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_alias.c", "alias_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_asis.c", "asis_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_auth.c", "auth_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_auth_anon.c", "anon_auth_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_auth_db.c", "db_auth_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_auth_dbm.c", "dbm_auth_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_auth_digest.c", "digest_auth_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_autoindex.c", "autoindex_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_cern_meta.c", "cern_meta_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_cgi.c", "cgi_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_digest.c", "digest_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_dir.c", "dir_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_env.c", "env_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_example.c", "example_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_expires.c", "expires_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_headers.c", "headers_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_imap.c", "imap_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_include.c", "includes_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_info.c", "info_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_isapi.c", "isapi_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_log_agent.c", "agent_log_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_log_config.c", "config_log_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_log_forensic.c", "log_forensic_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_log_referer.c", "referer_log_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_mime.c", "mime_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_mime_magic.c", "mime_magic_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_mmap_static.c", "mmap_static_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_negotiation.c", "negotiation_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_proxy.c", "proxy_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_rewrite.c", "rewrite_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_setenvif.c", "setenvif_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_so.c", "so_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_speling.c", "speling_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_status.c", "status_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_unique_id.c", "unique_id_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_userdir.c", "userdir_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_usertrack.c", "usertrack_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_vhost_alias.c", "vhost_alias_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("mod_jk.c", "jk_module");
        MODULE_SOURCE_FILE_TO_MODULE_NAME_13.put("covalent-snmp-v13.c", "snmp_agt_module");
    }

    private static class DiscoveryFailureException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DiscoveryFailureException(String message) {
            super(message);
        }

        public DiscoveryFailureException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

