/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.msc;

import java.util.EnumMap;
import java.util.Map;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartException;

public class ServiceContainerHelper {
    private static final Map<ServiceController.State, Map<ServiceController.Mode, ServiceController.Mode>> modeToggle = new EnumMap<ServiceController.State, Map<ServiceController.Mode, ServiceController.Mode>>(ServiceController.State.class);

    public static <T> T getValue(ServiceController<?> controller, Class<T> targetClass) throws StartException {
        return targetClass.cast(ServiceContainerHelper.getValue(controller));
    }

    public static <T> T getValue(ServiceController<T> controller) throws StartException {
        ServiceContainerHelper.start(controller);
        return (T)controller.getValue();
    }

    public static void start(ServiceController<?> controller) throws StartException {
        ServiceContainerHelper.transition(controller, ServiceController.State.UP);
    }

    public static void stop(ServiceController<?> controller) {
        try {
            ServiceContainerHelper.transition(controller, ServiceController.State.DOWN);
        }
        catch (StartException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void remove(ServiceController<?> controller) {
        try {
            ServiceContainerHelper.transition(controller, ServiceController.State.REMOVED);
        }
        catch (StartException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transition(ServiceController<?> targetController, ServiceController.State targetState) throws StartException {
        if (targetController.getState() == targetState) {
            return;
        }
        StabilityMonitor monitor = new StabilityMonitor();
        try {
            StartException exception;
            ServiceController.Mode targetMode;
            if (targetController.getSubstate().isRestState() && (targetMode = modeToggle.get(targetState).get(targetController.getMode())) != null) {
                targetController.setMode(targetMode);
            }
            monitor.addController(targetController);
            monitor.awaitStability();
            if (targetState == ServiceController.State.UP && (exception = targetController.getStartException()) != null) {
                throw exception;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            monitor.removeController(targetController);
        }
    }

    private ServiceContainerHelper() {
    }

    static {
        EnumMap<ServiceController.Mode, ServiceController.Mode> map = new EnumMap<ServiceController.Mode, ServiceController.Mode>(ServiceController.Mode.class);
        map.put(ServiceController.Mode.NEVER, ServiceController.Mode.ACTIVE);
        map.put(ServiceController.Mode.ON_DEMAND, ServiceController.Mode.PASSIVE);
        modeToggle.put(ServiceController.State.UP, map);
        map = new EnumMap(ServiceController.Mode.class);
        map.put(ServiceController.Mode.ACTIVE, ServiceController.Mode.NEVER);
        map.put(ServiceController.Mode.PASSIVE, ServiceController.Mode.ON_DEMAND);
        modeToggle.put(ServiceController.State.DOWN, map);
        map = new EnumMap(ServiceController.Mode.class);
        for (ServiceController.Mode mode : ServiceController.Mode.values()) {
            if (mode == ServiceController.Mode.REMOVE) continue;
            map.put(mode, ServiceController.Mode.REMOVE);
        }
        modeToggle.put(ServiceController.State.REMOVED, map);
    }
}

