/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.mapping;

import java.util.ArrayList;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SecurityUtil;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.mapping.MappingContext;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.config.MappingModuleEntry;
import org.jboss.security.plugins.ClassLoaderLocator;
import org.jboss.security.plugins.ClassLoaderLocatorFactory;
import org.jboss.security.plugins.mapping.SecurityActions;

public class JBossMappingManager
implements MappingManager {
    private String securityDomain;

    public JBossMappingManager(String domain) {
        this.securityDomain = SecurityUtil.unprefixSecurityDomain(domain);
    }

    @Override
    public <T> MappingContext<T> getMappingContext(String mappingType) {
        ApplicationPolicy aPolicy = SecurityConfiguration.getApplicationPolicy(this.securityDomain);
        if (aPolicy == null) {
            String defaultDomain = "other";
            aPolicy = SecurityConfiguration.getApplicationPolicy(defaultDomain);
        }
        if (aPolicy == null) {
            throw PicketBoxMessages.MESSAGES.failedToObtainApplicationPolicy(this.securityDomain);
        }
        MappingContext<T> mc = null;
        MappingInfo rmi = aPolicy.getMappingInfo(mappingType);
        if (rmi != null) {
            mc = this.generateMappingContext(mc, rmi);
        }
        return mc;
    }

    @Override
    public <T> MappingContext<T> getMappingContext(Class<T> mappingType) {
        ApplicationPolicy aPolicy = SecurityConfiguration.getApplicationPolicy(this.securityDomain);
        if (aPolicy == null) {
            String defaultDomain = "other";
            aPolicy = SecurityConfiguration.getApplicationPolicy(defaultDomain);
        }
        if (aPolicy == null) {
            throw PicketBoxMessages.MESSAGES.failedToObtainApplicationPolicy(this.securityDomain);
        }
        MappingContext<T> mc = null;
        MappingInfo rmi = aPolicy.getMappingInfo(mappingType);
        if (rmi != null) {
            mc = this.generateMappingContext(mc, rmi);
        }
        return mc;
    }

    private <T> MappingContext<T> generateMappingContext(MappingContext<T> mc, MappingInfo rmi) {
        ClassLoaderLocator cll;
        ClassLoader moduleCL = null;
        String jbossModuleName = rmi.getJBossModuleName();
        if (jbossModuleName != null && (cll = ClassLoaderLocatorFactory.get()) != null) {
            moduleCL = cll.get(jbossModuleName);
        }
        MappingModuleEntry[] mpe = rmi.getMappingModuleEntry();
        ArrayList al = new ArrayList();
        for (int i = 0; i < mpe.length; ++i) {
            MappingProvider<T> mp = this.getMappingProvider(moduleCL, mpe[i]);
            if (mp == null) continue;
            al.add(mp);
        }
        return new MappingContext(al);
    }

    @Override
    public String getSecurityDomain() {
        return this.securityDomain;
    }

    private <T> MappingProvider<T> getMappingProvider(ClassLoader cl, MappingModuleEntry mme) {
        MappingProvider mp = null;
        try {
            String fqn = mme.getMappingModuleName();
            Class<?> clazz = SecurityActions.loadClass(cl, fqn);
            mp = (MappingProvider)clazz.newInstance();
            mp.init(mme.getOptions());
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.debugIgnoredException(e);
        }
        return mp;
    }
}

