/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers.attribute;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.Util;
import org.jboss.security.identity.AttributeFactory;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.MappingResult;
import org.jboss.security.mapping.providers.attribute.MappingProvidersDecodeAction;
import org.jboss.security.mapping.providers.attribute.SecurityActions;

public class LdapAttributeMappingProvider
implements MappingProvider<List<org.jboss.security.identity.Attribute<String>>> {
    private Map<String, Object> options;
    protected int searchTimeLimit = 10000;
    private static final String BIND_DN = "bindDN";
    private static final String BIND_CREDENTIAL = "bindCredential";
    private static final String BASE_CTX_DN = "baseCtxDN";
    private static final String BASE_FILTER_OPT = "baseFilter";
    private static final String SEARCH_TIME_LIMIT_OPT = "searchTimeLimit";
    private static final String ATTRIBUTE_LIST_OPT = "attributeList";
    private static final String SECURITY_DOMAIN_OPT = "jaasSecurityDomain";
    private MappingResult<List<org.jboss.security.identity.Attribute<String>>> mappingResult;

    @Override
    public void init(Map<String, Object> options) {
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performMapping(Map<String, Object> map, List<org.jboss.security.identity.Attribute<String>> mappedObject) {
        ArrayList<org.jboss.security.identity.Attribute<String>> attributeList = new ArrayList<org.jboss.security.identity.Attribute<String>>();
        Principal principal = (Principal)map.get("Principal");
        if (principal != null) {
            InitialLdapContext ctx;
            String securityDomain;
            String user = principal.getName();
            String bindDN = (String)this.options.get(BIND_DN);
            if (bindDN == null || bindDN.length() == 0) {
                PicketBoxLogger.LOGGER.traceBindDNNotFound();
                return;
            }
            String bindCredential = (String)this.options.get(BIND_CREDENTIAL);
            if (bindCredential.startsWith("{EXT}")) {
                try {
                    bindCredential = new String(Util.loadPassword(bindCredential));
                }
                catch (Exception e1) {
                    PicketBoxLogger.LOGGER.errorDecryptingBindCredential(e1);
                    return;
                }
            }
            if ((securityDomain = (String)this.options.get(SECURITY_DOMAIN_OPT)) != null) {
                try {
                    ObjectName serviceName = new ObjectName(securityDomain);
                    char[] tmp = MappingProvidersDecodeAction.decode(bindCredential, serviceName);
                    bindCredential = new String(tmp);
                }
                catch (Exception e) {
                    PicketBoxLogger.LOGGER.errorDecryptingBindCredential(e);
                    return;
                }
            }
            ClassLoader currentTCCL = SecurityActions.getContextClassLoader();
            try {
                if (currentTCCL != null) {
                    SecurityActions.setContextClassLoader(null);
                }
                ctx = this.constructInitialLdapContext(bindDN, bindCredential);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
            String timeLimit = (String)this.options.get(SEARCH_TIME_LIMIT_OPT);
            if (timeLimit != null) {
                try {
                    this.searchTimeLimit = Integer.parseInt(timeLimit);
                }
                catch (NumberFormatException e) {
                    PicketBoxLogger.LOGGER.debugFailureToParseNumberProperty(SEARCH_TIME_LIMIT_OPT, this.searchTimeLimit);
                }
            }
            if (this.searchTimeLimit == 0) {
                this.searchTimeLimit = 10000;
            }
            String baseDN = (String)this.options.get(BASE_CTX_DN);
            String baseFilter = (String)this.options.get(BASE_FILTER_OPT);
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            constraints.setTimeLimit(this.searchTimeLimit);
            String attributePattern = (String)this.options.get(ATTRIBUTE_LIST_OPT);
            String[] neededAttributes = this.getNeededAttributes(attributePattern);
            constraints.setReturningAttributes(neededAttributes);
            NamingEnumeration<SearchResult> results = null;
            Object[] filterArgs = new Object[]{user};
            try {
                if (baseDN == null) {
                    throw PicketBoxMessages.MESSAGES.invalidNullArgument(BASE_CTX_DN);
                }
                results = ctx.search(baseDN, baseFilter, filterArgs, constraints);
                if (!results.hasMore()) {
                    results.close();
                    throw PicketBoxMessages.MESSAGES.failedToFindBaseContextDN(baseDN);
                }
                SearchResult sr = results.next();
                String name = sr.getName();
                String userDN = null;
                if (!sr.isRelative()) {
                    throw PicketBoxMessages.MESSAGES.unableToFollowReferralForAuth(name);
                }
                userDN = name + "," + baseDN;
                results.close();
                filterArgs = new Object[]{user, userDN};
                results = ctx.search(userDN, baseFilter, filterArgs, constraints);
                try {
                    while (results.hasMore()) {
                        sr = results.next();
                        Attributes attributes = sr.getAttributes();
                        NamingEnumeration<? extends Attribute> ne = attributes.getAll();
                        while (ne != null && ne.hasMoreElements()) {
                            Attribute ldapAtt = ne.next();
                            if ("mail".equalsIgnoreCase(ldapAtt.getID())) {
                                attributeList.add(AttributeFactory.createEmailAddress((String)ldapAtt.get()));
                                continue;
                            }
                            attributeList.add(AttributeFactory.createAttribute(ldapAtt.getID(), (String)ldapAtt.get()));
                        }
                    }
                }
                finally {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                    if (currentTCCL != null) {
                        SecurityActions.setContextClassLoader(currentTCCL);
                    }
                }
            }
            catch (NamingException ne) {
                PicketBoxLogger.LOGGER.debugIgnoredException(ne);
                return;
            }
            results = null;
        }
        mappedObject.addAll(attributeList);
        this.mappingResult.setMappedObject(mappedObject);
    }

    @Override
    public void setMappingResult(MappingResult<List<org.jboss.security.identity.Attribute<String>>> result) {
        this.mappingResult = result;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return org.jboss.security.identity.Attribute.class.isAssignableFrom(clazz);
    }

    private InitialLdapContext constructInitialLdapContext(String dn, Object credential) throws NamingException {
        String authType;
        Properties env = new Properties();
        for (Map.Entry<String, Object> entry : this.options.entrySet()) {
            env.put(entry.getKey(), entry.getValue());
        }
        String factoryName = env.getProperty("java.naming.factory.initial");
        if (factoryName == null) {
            factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
            env.setProperty("java.naming.factory.initial", factoryName);
        }
        if ((authType = env.getProperty("java.naming.security.authentication")) == null) {
            env.setProperty("java.naming.security.authentication", "simple");
        }
        String protocol = env.getProperty("java.naming.security.protocol");
        String providerURL = (String)this.options.get("java.naming.provider.url");
        if (providerURL == null) {
            providerURL = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "636" : "389");
        }
        env.setProperty("java.naming.provider.url", providerURL);
        if (dn != null) {
            env.setProperty("java.naming.security.principal", dn);
        }
        if (credential != null) {
            env.put("java.naming.security.credentials", credential);
        }
        this.traceLDAPEnv(env);
        return new InitialLdapContext(env, null);
    }

    private void traceLDAPEnv(Properties env) {
        Properties tmp = new Properties();
        tmp.putAll((Map<?, ?>)env);
        if (tmp.containsKey("java.naming.security.credentials")) {
            tmp.setProperty("java.naming.security.credentials", "******");
        }
        if (tmp.containsKey(BIND_CREDENTIAL)) {
            tmp.setProperty(BIND_CREDENTIAL, "******");
        }
        PicketBoxLogger.LOGGER.traceLDAPConnectionEnv(tmp);
    }

    private String[] getNeededAttributes(String commaSeparatedList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (commaSeparatedList != null) {
            StringTokenizer st = new StringTokenizer(commaSeparatedList, ",");
            while (st.hasMoreTokens()) {
                arrayList.add(st.nextToken());
            }
        }
        String[] strArr = new String[arrayList.size()];
        return arrayList.toArray(strArr);
    }
}

