/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingState;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;

public class StateParser {
    private final DefaultParsingState initialState = new DefaultParsingState("INITIAL");

    public void addState(char ch, ParsingState state) {
        this.initialState.enterState(ch, state);
    }

    public void parse(String str, ParsingStateCallbackHandler callbackHandler) throws CommandFormatException {
        StateParser.parse(str, callbackHandler, this.initialState);
    }

    public static void parse(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState) throws CommandFormatException {
        StateParser.parse(str, callbackHandler, initialState, true);
    }

    public static void parse(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState, boolean strict) throws CommandFormatException {
        try {
            StateParser.doParse(str, callbackHandler, initialState, strict);
        }
        catch (CommandFormatException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CommandFormatException("Failed to parse '" + str + "'", t);
        }
    }

    protected static void doParse(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState, boolean strict) throws CommandFormatException {
        if (str == null || str.isEmpty()) {
            return;
        }
        ParsingContextImpl ctx = new ParsingContextImpl();
        ctx.initialState = initialState;
        ctx.callbackHandler = callbackHandler;
        ctx.input = str;
        ctx.strict = strict;
        ctx.ch = str.charAt(0);
        ctx.location = 0;
        initialState.getEnterHandler().handle(ctx);
        while (ctx.location < str.length()) {
            ctx.ch = str.charAt(ctx.location);
            CharacterHandler handler = ctx.getState().getHandler(ctx.ch);
            handler.handle(ctx);
            ++ctx.location;
        }
        ParsingState state = ctx.getState();
        while (state != ctx.initialState) {
            state.getEndContentHandler().handle(ctx);
            ctx.leaveState();
            state = ctx.getState();
        }
        initialState.getEndContentHandler().handle(ctx);
        initialState.getLeaveHandler().handle(ctx);
    }

    static class ParsingContextImpl
    implements ParsingContext {
        private final Deque<ParsingState> stack = new ArrayDeque<ParsingState>();
        String input;
        int location;
        char ch;
        ParsingStateCallbackHandler callbackHandler;
        ParsingState initialState;
        boolean strict;
        CommandFormatException error;

        ParsingContextImpl() {
        }

        @Override
        public boolean isStrict() {
            return this.strict;
        }

        @Override
        public ParsingState getState() {
            return this.stack.isEmpty() ? this.initialState : this.stack.peek();
        }

        @Override
        public void enterState(ParsingState state) throws CommandFormatException {
            this.stack.push(state);
            this.callbackHandler.enteredState(this);
            state.getEnterHandler().handle(this);
        }

        @Override
        public ParsingState leaveState() throws CommandFormatException {
            this.stack.peek().getLeaveHandler().handle(this);
            this.callbackHandler.leavingState(this);
            ParsingState pop = this.stack.pop();
            if (!this.stack.isEmpty()) {
                this.stack.peek().getReturnHandler().handle(this);
            } else {
                this.initialState.getReturnHandler().handle(this);
            }
            return pop;
        }

        @Override
        public ParsingStateCallbackHandler getCallbackHandler() {
            return this.callbackHandler;
        }

        @Override
        public char getCharacter() {
            return this.ch;
        }

        @Override
        public int getLocation() {
            return this.location;
        }

        @Override
        public void reenterState() throws CommandFormatException {
            this.callbackHandler.leavingState(this);
            ParsingState state = this.stack.peek();
            state.getLeaveHandler().handle(this);
            this.callbackHandler.enteredState(this);
            state.getEnterHandler().handle(this);
        }

        @Override
        public boolean isEndOfContent() {
            return this.location >= this.input.length();
        }

        @Override
        public String getInput() {
            return this.input;
        }

        @Override
        public void advanceLocation(int offset) throws IndexOutOfBoundsException {
            if (this.isEndOfContent()) {
                throw new IndexOutOfBoundsException("Location=" + this.location + ", offset=" + offset + ", length=" + this.input.length());
            }
            this.location += offset;
            if (this.location < this.input.length()) {
                this.ch = this.input.charAt(this.location);
            }
        }

        @Override
        public CommandFormatException getError() {
            return this.error;
        }

        @Override
        public void setError(CommandFormatException e) {
            if (this.error == null) {
                this.error = e;
            }
        }
    }
}

