/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.resources;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.NoopOperationStepHandler;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.operations.common.InterfaceAddHandler;
import org.jboss.as.controller.operations.common.InterfaceRemoveHandler;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.resource.InterfaceDefinition;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.host.controller.model.jvm.JvmResourceDefinition;
import org.jboss.as.host.controller.operations.ServerAddHandler;
import org.jboss.as.host.controller.operations.ServerProcessHandlers;
import org.jboss.as.host.controller.operations.ServerRemoveHandler;
import org.jboss.as.host.controller.operations.ServerRestartHandler;
import org.jboss.as.host.controller.operations.ServerRestartRequiredServerConfigWriteAttributeHandler;
import org.jboss.as.host.controller.operations.ServerStartHandler;
import org.jboss.as.host.controller.operations.ServerStatusHandler;
import org.jboss.as.host.controller.operations.ServerStopHandler;
import org.jboss.as.server.controller.resources.SystemPropertyResourceDefinition;
import org.jboss.as.server.services.net.SpecifiedInterfaceAddHandler;
import org.jboss.as.server.services.net.SpecifiedInterfaceRemoveHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ServerConfigResourceDefinition
extends SimpleResourceDefinition {
    public static final AttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING).setResourceOnly()).build();
    public static final SimpleAttributeDefinition AUTO_START = SimpleAttributeDefinitionBuilder.create((String)"auto-start", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(true)).build();
    public static final SimpleAttributeDefinition SOCKET_BINDING_GROUP = SimpleAttributeDefinitionBuilder.create((String)"socket-binding-group", (ModelType)ModelType.STRING, (boolean)true).build();
    public static final SimpleAttributeDefinition SOCKET_BINDING_PORT_OFFSET = SimpleAttributeDefinitionBuilder.create((String)"socket-binding-port-offset", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(0)).setXmlName(Attribute.PORT_OFFSET.getLocalName()).setValidator((ParameterValidator)new IntRangeValidator(-65535, 65535, true, true)).build();
    public static final SimpleAttributeDefinition GROUP = SimpleAttributeDefinitionBuilder.create((String)"group", (ModelType)ModelType.STRING).build();
    public static final SimpleAttributeDefinition STATUS = SimpleAttributeDefinitionBuilder.create((String)"status", (ModelType)ModelType.STRING).setValidator((ParameterValidator)new EnumValidator(ServerStatus.class, false, false)).build();
    public static final AttributeDefinition PRIORITY = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"priority", (ModelType)ModelType.INT, (boolean)true).setDeprecated(ModelVersion.create((int)1, (int)4))).build();
    public static final AttributeDefinition CPU_AFFINITY = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"cpu-affinity", (ModelType)ModelType.STRING, (boolean)true).setDeprecated(ModelVersion.create((int)1, (int)4))).build();
    public static final List<SimpleAttributeDefinition> WRITABLE_ATTRIBUTES = Arrays.asList(AUTO_START, SOCKET_BINDING_GROUP, SOCKET_BINDING_PORT_OFFSET, GROUP);
    private final ServerInventory serverInventory;
    private final PathManagerService pathManager;

    public ServerConfigResourceDefinition(ServerInventory serverInventory, PathManagerService pathManager) {
        super(PathElement.pathElement((String)"server-config"), HostResolver.getResolver("server-config", false), (OperationStepHandler)ServerAddHandler.INSTANCE, (OperationStepHandler)ServerRemoveHandler.INSTANCE);
        assert (pathManager != null) : "pathManager is null";
        this.serverInventory = serverInventory;
        this.pathManager = pathManager;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute(NAME, (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)AUTO_START, null, (OperationStepHandler)new ModelOnlyWriteAttributeHandler(new AttributeDefinition[]{AUTO_START}));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SOCKET_BINDING_GROUP, null, (OperationStepHandler)ServerRestartRequiredServerConfigWriteAttributeHandler.SOCKET_BINDING_GROUP_INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SOCKET_BINDING_PORT_OFFSET, null, (OperationStepHandler)ServerRestartRequiredServerConfigWriteAttributeHandler.SOCKET_BINDING_PORT_OFFSET_INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)GROUP, null, (OperationStepHandler)ServerRestartRequiredServerConfigWriteAttributeHandler.GROUP_INSTANCE);
        resourceRegistration.registerReadWriteAttribute(PRIORITY, (OperationStepHandler)NoopOperationStepHandler.WITH_RESULT, (OperationStepHandler)NoopOperationStepHandler.WITHOUT_RESULT);
        resourceRegistration.registerReadWriteAttribute(CPU_AFFINITY, (OperationStepHandler)NoopOperationStepHandler.WITH_RESULT, (OperationStepHandler)NoopOperationStepHandler.WITHOUT_RESULT);
        if (this.serverInventory != null) {
            resourceRegistration.registerMetric((AttributeDefinition)STATUS, (OperationStepHandler)new ServerStatusHandler(this.serverInventory));
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.serverInventory != null) {
            ServerStartHandler startHandler = new ServerStartHandler(this.serverInventory);
            resourceRegistration.registerOperationHandler(ServerStartHandler.DEFINITION, (OperationStepHandler)startHandler);
            ServerRestartHandler restartHandler = new ServerRestartHandler(this.serverInventory);
            resourceRegistration.registerOperationHandler(ServerRestartHandler.DEFINITION, (OperationStepHandler)restartHandler);
            ServerStopHandler stopHandler = new ServerStopHandler(this.serverInventory);
            resourceRegistration.registerOperationHandler(ServerStopHandler.DEFINITION, (OperationStepHandler)stopHandler);
            ServerProcessHandlers.ServerDestroyHandler destroyHandler = new ServerProcessHandlers.ServerDestroyHandler(this.serverInventory);
            resourceRegistration.registerOperationHandler(ServerProcessHandlers.DESTROY_OPERATION, (OperationStepHandler)destroyHandler);
            ServerProcessHandlers.ServerKillHandler killHandler = new ServerProcessHandlers.ServerKillHandler(this.serverInventory);
            resourceRegistration.registerOperationHandler(ServerProcessHandlers.KILL_OPERATION, (OperationStepHandler)killHandler);
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)PathResourceDefinition.createSpecifiedNoServices((PathManagerService)this.pathManager));
        resourceRegistration.registerSubModel((ResourceDefinition)new InterfaceDefinition((InterfaceAddHandler)SpecifiedInterfaceAddHandler.INSTANCE, (InterfaceRemoveHandler)SpecifiedInterfaceRemoveHandler.INSTANCE, true));
        resourceRegistration.registerSubModel((ResourceDefinition)SystemPropertyResourceDefinition.createForDomainOrHost((SystemPropertyResourceDefinition.Location)SystemPropertyResourceDefinition.Location.SERVER_CONFIG));
        resourceRegistration.registerSubModel((ResourceDefinition)JvmResourceDefinition.SERVER);
    }
}

