/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.HashMap;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.HostControllerConfigurationPersister;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.host.controller.discovery.StaticDiscovery;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.host.controller.model.host.AdminOnlyDomainConfigPolicy;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class RemoteDomainControllerAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "write-remote-domain-controller";
    public static final SimpleAttributeDefinition PORT = new SimpleAttributeDefinitionBuilder("port", ModelType.INT).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new IntRangeValidator(1, 65535, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition HOST = new SimpleAttributeDefinitionBuilder("host", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition USERNAME = new SimpleAttributeDefinitionBuilder("username", ModelType.STRING, true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM}).build();
    public static final SimpleAttributeDefinition SECURITY_REALM = new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).build();
    public static final SimpleAttributeDefinition ADMIN_ONLY_POLICY = new SimpleAttributeDefinitionBuilder("admin-only-policy", ModelType.STRING, true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM}).setValidator((ParameterValidator)new EnumValidator(AdminOnlyDomainConfigPolicy.class, true, true)).setDefaultValue(new ModelNode(AdminOnlyDomainConfigPolicy.ALLOW_NO_CONFIG.toString())).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("write-remote-domain-controller", HostResolver.getResolver("host")).setParameters(new AttributeDefinition[]{PORT, HOST, USERNAME, SECURITY_REALM, ADMIN_ONLY_POLICY}).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.DOMAIN_CONTROLLER).build();
    private final ManagementResourceRegistration rootRegistration;
    private final DomainController domainController;
    private final HostControllerConfigurationPersister overallConfigPersister;
    private final ContentRepository contentRepository;
    private final HostFileRepository fileRepository;
    private final LocalHostControllerInfoImpl hostControllerInfo;
    private final ExtensionRegistry extensionRegistry;
    private final IgnoredDomainResourceRegistry ignoredDomainResourceRegistry;
    private final PathManagerService pathManager;

    public RemoteDomainControllerAddHandler(ManagementResourceRegistration rootRegistration, LocalHostControllerInfoImpl hostControllerInfo, DomainController domainController, HostControllerConfigurationPersister overallConfigPersister, ContentRepository contentRepository, HostFileRepository fileRepository, ExtensionRegistry extensionRegistry, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, PathManagerService pathManager) {
        this.rootRegistration = rootRegistration;
        this.domainController = domainController;
        this.overallConfigPersister = overallConfigPersister;
        this.contentRepository = contentRepository;
        this.fileRepository = fileRepository;
        this.hostControllerInfo = hostControllerInfo;
        this.extensionRegistry = extensionRegistry;
        this.ignoredDomainResourceRegistry = ignoredDomainResourceRegistry;
        this.pathManager = pathManager;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        ModelNode dc = model.get("domain-controller");
        ModelNode remoteDC = dc.get("remote");
        PORT.validateAndSet(operation, remoteDC);
        HOST.validateAndSet(operation, remoteDC);
        USERNAME.validateAndSet(operation, remoteDC);
        ADMIN_ONLY_POLICY.validateAndSet(operation, remoteDC);
        if (operation.has(SECURITY_REALM.getName())) {
            SECURITY_REALM.validateAndSet(operation, remoteDC);
            this.hostControllerInfo.setRemoteDomainControllerSecurityRealm(SECURITY_REALM.resolveModelAttribute(context, operation).asString());
        } else {
            remoteDC.get(SECURITY_REALM.getName()).clear();
        }
        if (dc.has("local")) {
            dc.remove("local");
        }
        if (context.isBooting()) {
            this.initializeDomain(context, remoteDC);
        } else {
            context.reloadRequired();
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (!context.isBooting()) {
                    context.revertReloadRequired();
                }
            }
        });
    }

    protected void initializeDomain(OperationContext context, ModelNode remoteDC) throws OperationFailedException {
        ModelNode usernameNode;
        this.hostControllerInfo.setMasterDomainController(false);
        ModelNode hostNode = HOST.resolveModelAttribute(context, remoteDC);
        ModelNode portNode = PORT.resolveModelAttribute(context, remoteDC);
        if (hostNode.isDefined() && portNode.isDefined()) {
            HashMap<String, ModelNode> properties = new HashMap<String, ModelNode>();
            properties.put("host", hostNode);
            properties.put("port", portNode);
            StaticDiscovery staticDiscoveryOption = new StaticDiscovery(properties);
            this.hostControllerInfo.addRemoteDomainControllerDiscoveryOption(staticDiscoveryOption);
        }
        if ((usernameNode = USERNAME.resolveModelAttribute(context, remoteDC)).isDefined()) {
            this.hostControllerInfo.setRemoteDomainControllerUsername(usernameNode.asString());
        }
        AdminOnlyDomainConfigPolicy domainConfigPolicy = AdminOnlyDomainConfigPolicy.getPolicy(ADMIN_ONLY_POLICY.resolveModelAttribute(context, remoteDC).asString());
        this.hostControllerInfo.setAdminOnlyDomainConfigPolicy(domainConfigPolicy);
        this.overallConfigPersister.initializeDomainConfigurationPersister(true);
        this.domainController.initializeSlaveDomainRegistry(this.rootRegistration, this.overallConfigPersister.getDomainPersister(), this.contentRepository, this.fileRepository, this.hostControllerInfo, this.extensionRegistry, this.ignoredDomainResourceRegistry, this.pathManager);
    }
}

