/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.TransformingProxyController;
import org.jboss.as.controller.operations.DomainOperationTransformer;
import org.jboss.as.controller.operations.OperationAttachments;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.operations.coordination.DomainOperationContext;
import org.jboss.as.domain.controller.operations.coordination.HostControllerUpdateTask;
import org.jboss.dmr.ModelNode;

public class DomainSlaveHandler
implements OperationStepHandler {
    private final DomainOperationContext domainOperationContext;
    private final Map<String, ProxyController> hostProxies;

    public DomainSlaveHandler(Map<String, ProxyController> hostProxies, DomainOperationContext domainOperationContext) {
        this.hostProxies = hostProxies;
        this.domainOperationContext = domainOperationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.hasFailureDescription()) {
            context.setRollbackOnly();
            context.stepCompleted();
            return;
        }
        context.attachIfAbsent(CompositeOperationHandler.DOMAIN_EXECUTION_KEY, (Object)Boolean.TRUE);
        HashSet<String> outstanding = new HashSet<String>(this.hostProxies.keySet());
        final ArrayList<TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation>> results = new ArrayList<TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation>>();
        final HashMap<String, HostControllerUpdateTask.ExecutedHostRequest> finalResults = new HashMap<String, HostControllerUpdateTask.ExecutedHostRequest>();
        HostControllerUpdateTask.ProxyOperationListener listener = new HostControllerUpdateTask.ProxyOperationListener();
        for (Map.Entry<String, ProxyController> entry : this.hostProxies.entrySet()) {
            String host = entry.getKey();
            TransformingProxyController proxyController = (TransformingProxyController)entry.getValue();
            List list = (List)context.getAttachment(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSFORMERS);
            ModelNode op = operation;
            if (list != null) {
                for (DomainOperationTransformer transformer : list) {
                    op = transformer.transform(context, op);
                }
            }
            HostControllerUpdateTask task = new HostControllerUpdateTask(host, op.clone(), context, proxyController);
            HostControllerUpdateTask.ExecutedHostRequest finalResult = task.execute(listener);
            this.domainOperationContext.recordHostRequest(host, finalResult);
            finalResults.put(host, finalResult);
        }
        boolean interrupted = false;
        boolean completeStepCalled = false;
        try {
            try {
                while (outstanding.size() > 0) {
                    HostControllerUpdateTask.ExecutedHostRequest request;
                    boolean reject;
                    TransactionalProtocolClient.PreparedOperation prepared = listener.retrievePreparedOperation();
                    String hostName = ((HostControllerUpdateTask.ProxyOperation)prepared.getOperation()).getName();
                    if (!outstanding.remove(hostName)) continue;
                    ModelNode modelNode = prepared.getPreparedResult();
                    if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
                        DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Preliminary result for remote host %s is %s", hostName, modelNode);
                    }
                    if (reject = (request = (HostControllerUpdateTask.ExecutedHostRequest)finalResults.get(hostName)).rejectOperation(modelNode)) {
                        if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isDebugEnabled()) {
                            DomainControllerLogger.HOST_CONTROLLER_LOGGER.debugf("Rejecting result for remote host %s is %s", hostName, modelNode);
                        }
                        ModelNode failedResult = new ModelNode();
                        failedResult.get("outcome").set("failed");
                        failedResult.get("failure-description").set(request.getFailureDescription());
                        this.domainOperationContext.addHostControllerResult(hostName, failedResult);
                    } else {
                        this.domainOperationContext.addHostControllerResult(hostName, modelNode);
                    }
                    results.add((TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation>)prepared);
                }
            }
            catch (InterruptedException ie) {
                interrupted = true;
                this.domainOperationContext.setFailureReported(true);
                for (HostControllerUpdateTask.ExecutedHostRequest executedHostRequest : finalResults.values()) {
                    executedHostRequest.asyncCancel();
                }
                for (Map.Entry entry : finalResults.entrySet()) {
                    ModelNode result;
                    String hostName = (String)entry.getKey();
                    try {
                        HostControllerUpdateTask.ExecutedHostRequest request = (HostControllerUpdateTask.ExecutedHostRequest)entry.getValue();
                        result = request.getFinalResult().get();
                        ModelNode transformedResult = request.transformResult(result);
                        this.domainOperationContext.addHostControllerResult(hostName, transformedResult);
                    }
                    catch (Exception e) {
                        result = new ModelNode();
                        result.get("outcome").set("failed");
                        if (e instanceof InterruptedException) {
                            result.get("failure-description").set(DomainControllerMessages.MESSAGES.interruptedAwaitingResultFromHost((String)entry.getKey()));
                            interrupted = true;
                        } else {
                            result.get("failure-description").set(DomainControllerMessages.MESSAGES.exceptionAwaitingResultFromHost((String)entry.getKey(), e.getMessage()));
                        }
                        this.domainOperationContext.addHostControllerResult(hostName, result);
                    }
                }
            }
            final boolean interruptThread = interrupted;
            context.completeStep(new OperationContext.ResultHandler(){

                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    DomainSlaveHandler.this.finalizeOp(results, finalResults, interruptThread);
                }
            });
            completeStepCalled = true;
        }
        finally {
            if (!completeStepCalled) {
                this.finalizeOp(results, finalResults, interrupted);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeOp(List<TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation>> results, Map<String, HostControllerUpdateTask.ExecutedHostRequest> finalResults, boolean interrupted) {
        boolean interruptThread = interrupted;
        try {
            boolean rollback = this.domainOperationContext.isCompleteRollback();
            for (TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation> prepared : results) {
                if (prepared.isDone()) continue;
                if (!rollback) {
                    prepared.commit();
                    continue;
                }
                prepared.rollback();
            }
            for (TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation> prepared : results) {
                String hostName = ((HostControllerUpdateTask.ProxyOperation)prepared.getOperation()).getName();
                try {
                    HostControllerUpdateTask.ExecutedHostRequest request = finalResults.get(hostName);
                    ModelNode finalResult = (ModelNode)prepared.getFinalResult().get();
                    ModelNode transformedResult = request.transformResult(finalResult);
                    this.domainOperationContext.addHostControllerResult(hostName, transformedResult);
                    if (!DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) continue;
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Final result for remote host %s is %s", hostName, finalResult);
                }
                catch (InterruptedException e) {
                    interruptThread = true;
                    DomainControllerLogger.CONTROLLER_LOGGER.interruptedAwaitingFinalResponse(hostName);
                }
                catch (ExecutionException e) {
                    DomainControllerLogger.CONTROLLER_LOGGER.caughtExceptionAwaitingFinalResponse(e.getCause(), hostName);
                }
            }
        }
        finally {
            if (interruptThread) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

