/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.operations.coordination.DomainServerUtils;
import org.jboss.as.domain.management.CoreManagementResourceDefinition;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.access.AccessConstraintResources;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.management.client.content.ManagedDMRContentTypeResource;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ApplyRemoteMasterDomainModelHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "apply-remote-domain-model";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("apply-remote-domain-model", null).withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).setPrivateEntry().build();
    private final HostFileRepository fileRepository;
    private final ContentRepository contentRepository;
    private final IgnoredDomainResourceRegistry ignoredResourceRegistry;
    private final LocalHostControllerInfo localHostInfo;
    private final WritableAuthorizerConfiguration authorizerConfiguration;

    public ApplyRemoteMasterDomainModelHandler(HostFileRepository fileRepository, ContentRepository contentRepository, LocalHostControllerInfo localHostInfo, IgnoredDomainResourceRegistry ignoredResourceRegistry, WritableAuthorizerConfiguration authorizerConfiguration) {
        this.fileRepository = fileRepository;
        this.contentRepository = contentRepository;
        this.localHostInfo = localHostInfo;
        this.ignoredResourceRegistry = ignoredResourceRegistry;
        this.authorizerConfiguration = authorizerConfiguration;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode domainModel = operation.get("domain-model");
        final ModelNode startRoot = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS));
        Set<String> ourServerGroups = this.getOurServerGroups(context);
        HashMap<String, HashSet<byte[]>> deploymentHashes = new HashMap<String, HashSet<byte[]>>();
        HashSet<String> relevantDeployments = new HashSet<String>();
        HashSet<byte[]> requiredContent = new HashSet<byte[]>();
        Resource rootResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        this.clearDomain(rootResource);
        if (!context.isBooting()) {
            this.authorizerConfiguration.reset();
        }
        ArrayList<ModelNode> addOps = new ArrayList<ModelNode>();
        for (ModelNode resourceDescription : domainModel.asList()) {
            PathAddress resourceAddress = PathAddress.pathAddress((ModelNode)resourceDescription.require("domain-resource-address"));
            if (this.ignoredResourceRegistry.isResourceExcluded(resourceAddress) || resourceAddress.size() == 1 && resourceAddress.getElement(0).getKey().equals("extension")) continue;
            ModelNode resourceModel = resourceDescription.get("domain-resource-model");
            Resource resource = this.getResource(resourceAddress, rootResource, resourceModel, context, addOps);
            if (resource != null && resourceAddress.size() == 1) {
                ModelNode model;
                PathElement pe = resourceAddress.getElement(0);
                String peKey = pe.getKey();
                if (peKey.equals("deployment")) {
                    model = resource.getModel();
                    String id = resourceAddress.getElement(0).getValue();
                    if (!model.hasDefined("content")) continue;
                    for (ModelNode contentItem : model.get("content").asList()) {
                        if (!contentItem.hasDefined("hash")) continue;
                        HashSet<byte[]> hashes = (HashSet<byte[]>)deploymentHashes.get(id);
                        if (hashes == null) {
                            hashes = new HashSet<byte[]>();
                            deploymentHashes.put(id, hashes);
                        }
                        hashes.add(contentItem.get("hash").asBytes());
                    }
                    continue;
                }
                if (!peKey.equals("management-client-content") || !(model = resource.getModel()).hasDefined("hash")) continue;
                requiredContent.add(model.get("hash").asBytes());
                continue;
            }
            if (resourceAddress.size() != 2 || !resourceAddress.getElement(0).getKey().equals("server-group") || !ourServerGroups.contains(resourceAddress.getElement(0).getValue()) || !resourceAddress.getElement(1).getKey().equals("deployment")) continue;
            relevantDeployments.add(resourceAddress.getElement(1).getValue());
        }
        for (String id : relevantDeployments) {
            Set hashes = (Set)deploymentHashes.remove(id);
            if (hashes == null) continue;
            requiredContent.addAll(hashes);
        }
        for (byte[] hash : requiredContent) {
            this.fileRepository.getDeploymentFiles(hash);
        }
        if (!context.isBooting()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ApplyRemoteMasterDomainModelHandler.this.makeAffectedServersRestartRequired(context, startRoot);
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.MODEL, true);
        }
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        for (int i = addOps.size() - 1; i >= 0; --i) {
            String stepOpName;
            ModelNode subOperation = (ModelNode)addOps.get(i);
            PathAddress stepAddress = PathAddress.pathAddress((ModelNode)subOperation.get("address"));
            OperationStepHandler stepHandler = registry.getOperationHandler(stepAddress, stepOpName = subOperation.require("operation").asString());
            if (stepHandler == null) {
                ImmutableManagementResourceRegistration child = registry.getSubModel(stepAddress);
                if (child == null) {
                    throw new IllegalStateException(ControllerMessages.MESSAGES.noSuchResourceType(stepAddress));
                }
                throw new IllegalStateException(ControllerMessages.MESSAGES.noHandlerForOperation(stepOpName, stepAddress));
            }
            context.addStep(subOperation, stepHandler, OperationContext.Stage.MODEL, true);
        }
        context.stepCompleted();
    }

    private void clearDomain(Resource rootResource) {
        for (Resource.ResourceEntry entry : rootResource.getChildren("path")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("system-property")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("profile")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("interface")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("socket-binding-group")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("deployment")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("server-group")) {
            rootResource.removeChild(entry.getPathElement());
        }
        Resource accessControl = rootResource.navigate(PathAddress.pathAddress((PathElement[])new PathElement[]{CoreManagementResourceDefinition.PATH_ELEMENT, AccessAuthorizationResourceDefinition.PATH_ELEMENT}));
        accessControl.writeModel(new ModelNode());
        for (Resource.ResourceEntry entry : accessControl.getChildren("server-group-scoped-role")) {
            accessControl.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : accessControl.getChildren("host-scoped-role")) {
            accessControl.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : accessControl.getChildren("role-mapping")) {
            accessControl.removeChild(entry.getPathElement());
        }
    }

    protected Resource getResource(PathAddress resourceAddress, Resource rootResource, ModelNode resourceModel, OperationContext context, List<ModelNode> addOps) {
        if (resourceAddress.size() == 0) {
            return rootResource;
        }
        boolean allowCreate = true;
        boolean writeResourceModel = true;
        boolean coreService = false;
        boolean accessControl = false;
        PathElement created = null;
        Resource temp = rootResource;
        int idx = 0;
        for (PathElement element : resourceAddress) {
            temp = temp == null ? null : temp.getChild(element);
            String type = element.getKey();
            assert (!"extension".equals(type)) : "extension resources should be excluded";
            String value = element.getValue();
            if (temp == null) {
                if (idx == 0) {
                    if ("management-client-content".equals(type) && "rollout-plans".equals(value)) {
                        temp = new ManagedDMRContentTypeResource(element, "rollout-plan", null, this.contentRepository);
                        context.addResource(resourceAddress, temp);
                    }
                } else if (accessControl) {
                    allowCreate = false;
                    if (idx == resourceAddress.size() - 1) {
                        ModelNode addOp = Util.createAddOperation((PathAddress)resourceAddress);
                        if (resourceModel.isDefined()) {
                            for (Property property : resourceModel.asPropertyList()) {
                                addOp.get(property.getName()).set(property.getValue());
                            }
                        }
                        addOps.add(addOp);
                    }
                }
                if (temp == null && allowCreate) {
                    assert (created == null) : "already created " + created;
                    temp = context.createResource(resourceAddress);
                    created = element;
                }
            } else if ("core-service".equals(type) && "management".equals(value)) {
                coreService = true;
            } else if (coreService && idx == 1 && element.equals(AccessAuthorizationResourceDefinition.PATH_ELEMENT)) {
                accessControl = true;
                if (idx == resourceAddress.size() - 1) {
                    writeResourceModel = false;
                    ModelNode configureOp = Util.createEmptyOperation((String)"configure-from-domain", (PathAddress)resourceAddress);
                    for (AttributeDefinition ad : AccessAuthorizationResourceDefinition.CONFIG_ATTRIBUTES) {
                        String attrName = ad.getName();
                        if (!resourceModel.hasDefined(attrName)) continue;
                        configureOp.get(attrName).set(resourceModel.get(attrName));
                    }
                    addOps.add(configureOp);
                }
            } else if (accessControl && idx == 2 && (AccessConstraintResources.APPLICATION_PATH_ELEMENT.equals(element) || AccessConstraintResources.SENSITIVITY_PATH_ELEMENT.equals(element) || AccessConstraintResources.VAULT_PATH_ELEMENT.equals(element))) {
                accessControl = false;
                allowCreate = false;
            }
            ++idx;
        }
        if (writeResourceModel && temp != null) {
            temp.writeModel(resourceModel);
        }
        return temp;
    }

    private Collection<ServerIdentity> getServersAffectedByPath(String pathName, ModelNode hostModel, boolean forDomain) {
        if (forDomain && hostModel.hasDefined("path") && hostModel.get("path").keys().contains(pathName)) {
            return Collections.emptySet();
        }
        if (hostModel.hasDefined("server-config")) {
            HashSet<ServerIdentity> servers = new HashSet<ServerIdentity>();
            for (Property prop : hostModel.get("server-config").asPropertyList()) {
                String serverName = prop.getName();
                ModelNode server = prop.getValue();
                String serverGroupName = server.require("group").asString();
                if (server.hasDefined("path") && server.get("path").keys().contains(pathName)) continue;
                ServerIdentity groupedServer = new ServerIdentity(this.localHostInfo.getLocalHostName(), serverGroupName, serverName);
                servers.add(groupedServer);
            }
            return servers;
        }
        return Collections.emptySet();
    }

    private Collection<ServerIdentity> getServerAffectedBySystemProperty(String propName, boolean isDomain, ModelNode domain, String affectedGroup, ModelNode host) {
        boolean overridden = false;
        Set<String> groups = null;
        if (isDomain) {
            if (this.hasSystemProperty(host, propName)) {
                overridden = true;
            } else if (affectedGroup != null) {
                groups = Collections.singleton(affectedGroup);
            } else if (domain.hasDefined("server-group")) {
                groups = new HashSet<String>();
                for (Property groupProp : domain.get("server-group").asPropertyList()) {
                    String groupName = groupProp.getName();
                    if (this.hasSystemProperty(groupProp.getValue(), propName)) continue;
                    groups.add(groupName);
                }
            }
        }
        HashSet<ServerIdentity> servers = null;
        if (!overridden && host.hasDefined("server-config")) {
            servers = new HashSet<ServerIdentity>();
            for (Property serverProp : host.get("server-config").asPropertyList()) {
                String serverName = serverProp.getName();
                ModelNode server = serverProp.getValue();
                if (this.hasSystemProperty(server, propName)) continue;
                String groupName = server.require("group").asString();
                if (groups != null && !groups.contains(groupName)) continue;
                servers.add(new ServerIdentity(this.localHostInfo.getLocalHostName(), groupName, serverName));
            }
        }
        if (servers != null) {
            return servers;
        }
        return Collections.emptySet();
    }

    private boolean hasSystemProperty(ModelNode resource, String propName) {
        return resource.hasDefined("system-property") && resource.get("system-property").hasDefined(propName);
    }

    private Collection<ServerIdentity> getServerAffectedByProfile(String profileName, ModelNode domain, ModelNode host, Map<String, ProxyController> serverProxies) {
        Set<String> relatedProfiles = DomainServerUtils.getRelatedElements("profile", profileName, domain);
        HashSet<ServerIdentity> allServers = new HashSet<ServerIdentity>();
        for (String profile : relatedProfiles) {
            allServers.addAll(DomainServerUtils.getServersForType("profile", profile, domain, host, this.localHostInfo.getLocalHostName(), serverProxies));
        }
        return allServers;
    }

    private Collection<ServerIdentity> getServersAffectedByInterface(String interfaceName, ModelNode hostModel, boolean forDomain) {
        if (forDomain && hostModel.hasDefined("interface") && hostModel.get("interface").keys().contains(interfaceName)) {
            return Collections.emptySet();
        }
        if (hostModel.hasDefined("server-config")) {
            HashSet<ServerIdentity> servers = new HashSet<ServerIdentity>();
            for (Property prop : hostModel.get("server-config").asPropertyList()) {
                String serverName = prop.getName();
                ModelNode server = prop.getValue();
                String serverGroupName = server.require("group").asString();
                if (server.hasDefined("interface") && server.get("interface").keys().contains(interfaceName)) continue;
                ServerIdentity groupedServer = new ServerIdentity(this.localHostInfo.getLocalHostName(), serverGroupName, serverName);
                servers.add(groupedServer);
            }
            return servers;
        }
        return Collections.emptySet();
    }

    private Collection<ServerIdentity> getServersAffectedBySocketBindingGroup(String bindingGroupName, ModelNode domain, ModelNode host, Map<String, ProxyController> serverProxies) {
        Set<String> relatedBindingGroups = DomainServerUtils.getRelatedElements("socket-binding-group", bindingGroupName, domain);
        HashSet<ServerIdentity> result = new HashSet<ServerIdentity>();
        for (String bindingGroup : relatedBindingGroups) {
            result.addAll(DomainServerUtils.getServersForType("socket-binding-group", bindingGroup, domain, host, this.localHostInfo.getLocalHostName(), serverProxies));
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            ServerIdentity gs = (ServerIdentity)iter.next();
            ModelNode server = host.get(new String[]{"server-config", gs.getServerName()});
            if (!server.hasDefined("socket-binding-group") || bindingGroupName.equals(server.get("socket-binding-group").asString())) continue;
            iter.remove();
        }
        return result;
    }

    private Set<String> getOurServerGroups(OperationContext context) {
        HashSet<String> result = new HashSet<String>();
        Resource root = context.readResource(PathAddress.EMPTY_ADDRESS);
        Resource host = (Resource)root.getChildren("host").iterator().next();
        for (Resource.ResourceEntry server : host.getChildren("server-config")) {
            ModelNode model = server.getModel();
            result.add(model.get("group").asString());
        }
        return result;
    }

    private void makeAffectedServersRestartRequired(OperationContext context, ModelNode startRoot) {
        Resource domainRootResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode endRoot = Resource.Tools.readModel((Resource)domainRootResource);
        HashSet<ServerIdentity> affectedServers = new HashSet<ServerIdentity>();
        ModelNode hostModel = ((Property)endRoot.require("host").asPropertyList().iterator().next()).getValue();
        ModelNode existingHostModel = ((Property)startRoot.require("host").asPropertyList().iterator().next()).getValue();
        Map<String, ProxyController> serverProxies = DomainServerUtils.getServerProxies(this.localHostInfo.getLocalHostName(), domainRootResource, context.getResourceRegistration());
        ModelNode startPaths = startRoot.get("path");
        ModelNode endPaths = endRoot.get("path");
        HashMap<String, ModelNode> existingPaths = new HashMap<String, ModelNode>();
        if (startPaths.isDefined()) {
            for (Property property : startPaths.asPropertyList()) {
                existingPaths.put(property.getName(), property.getValue());
            }
        }
        if (endPaths.isDefined()) {
            for (Property property : endPaths.asPropertyList()) {
                String pathName = property.getName();
                if (existingPaths.containsKey(pathName)) {
                    if (!property.getValue().equals((ModelNode)existingPaths.get(pathName))) {
                        affectedServers.addAll(this.getServersAffectedByPath(pathName, hostModel, true));
                    }
                    existingPaths.remove(pathName);
                    continue;
                }
                affectedServers.addAll(this.getServersAffectedByPath(pathName, hostModel, true));
            }
        }
        for (Map.Entry entry : existingPaths.entrySet()) {
            affectedServers.addAll(this.getServersAffectedByPath((String)entry.getKey(), existingHostModel, true));
        }
        ModelNode startSysProps = startRoot.get("system-property");
        ModelNode modelNode = endRoot.get("system-property");
        HashMap<String, ModelNode> existingProps = new HashMap<String, ModelNode>();
        if (startSysProps.isDefined()) {
            for (Property property : startSysProps.asPropertyList()) {
                existingProps.put(property.getName(), property.getValue());
            }
        }
        if (modelNode.isDefined()) {
            for (Property property : modelNode.asPropertyList()) {
                if (existingProps.containsKey(property.getName())) {
                    if (!property.getValue().equals((ModelNode)existingProps.get(property.getName()))) {
                        affectedServers.addAll(this.getServerAffectedBySystemProperty(property.getName(), true, endRoot, null, hostModel));
                    }
                    existingProps.remove(property.getName());
                    continue;
                }
                affectedServers.addAll(this.getServerAffectedBySystemProperty(property.getName(), true, endRoot, null, hostModel));
            }
        }
        for (Map.Entry entry : existingProps.entrySet()) {
            affectedServers.addAll(this.getServerAffectedBySystemProperty((String)entry.getKey(), true, startRoot, null, existingHostModel));
        }
        ModelNode startProfiles = startRoot.get("profile");
        ModelNode modelNode2 = endRoot.get("profile");
        HashMap<String, ModelNode> existingProfiles = new HashMap<String, ModelNode>();
        if (startProfiles.isDefined()) {
            for (Property property : startProfiles.asPropertyList()) {
                existingProfiles.put(property.getName(), property.getValue());
            }
        }
        if (modelNode2.isDefined()) {
            for (Property property : modelNode2.asPropertyList()) {
                if (existingProfiles.containsKey(property.getName())) {
                    if (!property.getValue().equals((ModelNode)existingProfiles.get(property.getName()))) {
                        affectedServers.addAll(this.getServerAffectedByProfile(property.getName(), endRoot, hostModel, serverProxies));
                    }
                    existingProfiles.remove(property.getName());
                    continue;
                }
                affectedServers.addAll(this.getServerAffectedByProfile(property.getName(), endRoot, hostModel, serverProxies));
            }
        }
        for (Map.Entry entry : existingProfiles.entrySet()) {
            affectedServers.addAll(this.getServerAffectedByProfile((String)entry.getKey(), startRoot, existingHostModel, serverProxies));
        }
        ModelNode startInterfaces = startRoot.get("interface");
        ModelNode modelNode3 = endRoot.get("interface");
        HashMap<String, ModelNode> existingInterfaces = new HashMap<String, ModelNode>();
        if (startInterfaces.isDefined()) {
            for (Property property : startInterfaces.asPropertyList()) {
                existingInterfaces.put(property.getName(), property.getValue());
            }
        }
        if (modelNode3.isDefined()) {
            for (Property property : modelNode3.asPropertyList()) {
                if (existingInterfaces.containsKey(property.getName())) {
                    if (!property.getValue().equals((ModelNode)existingInterfaces.get(property.getName()))) {
                        affectedServers.addAll(this.getServersAffectedByInterface(property.getName(), hostModel, true));
                    }
                    existingInterfaces.remove(property.getName());
                    continue;
                }
                affectedServers.addAll(this.getServersAffectedByInterface(property.getName(), hostModel, true));
            }
        }
        for (Map.Entry entry : existingInterfaces.entrySet()) {
            affectedServers.addAll(this.getServersAffectedByInterface((String)entry.getKey(), existingHostModel, true));
        }
        ModelNode startBindingGroups = startRoot.get("socket-binding-group");
        ModelNode modelNode4 = endRoot.get("socket-binding-group");
        HashMap<String, ModelNode> existingBindingGroups = new HashMap<String, ModelNode>();
        if (startBindingGroups.isDefined()) {
            for (Property property : startBindingGroups.asPropertyList()) {
                existingBindingGroups.put(property.getName(), property.getValue());
            }
        }
        if (modelNode4.isDefined()) {
            for (Property property : modelNode4.asPropertyList()) {
                if (existingBindingGroups.containsKey(property.getName())) {
                    if (!property.getValue().equals((ModelNode)existingBindingGroups.get(property.getName()))) {
                        affectedServers.addAll(this.getServersAffectedBySocketBindingGroup(property.getName(), endRoot, hostModel, serverProxies));
                    }
                    existingBindingGroups.remove(property.getName());
                    continue;
                }
                affectedServers.addAll(this.getServersAffectedBySocketBindingGroup(property.getName(), endRoot, hostModel, serverProxies));
            }
        }
        for (Map.Entry entry : existingBindingGroups.entrySet()) {
            affectedServers.addAll(this.getServersAffectedBySocketBindingGroup((String)entry.getKey(), startRoot, existingHostModel, serverProxies));
        }
        ModelNode startServerGroups = startRoot.get("server-group");
        ModelNode modelNode5 = endRoot.get("server-group");
        HashMap<String, ModelNode> existingServerGroups = new HashMap<String, ModelNode>();
        if (startServerGroups.isDefined()) {
            for (Property property : startServerGroups.asPropertyList()) {
                existingServerGroups.put(property.getName(), property.getValue());
            }
        }
        if (modelNode5.isDefined()) {
            for (Property property : modelNode5.asPropertyList()) {
                if (existingServerGroups.containsKey(property.getName())) {
                    if (!property.getValue().equals((ModelNode)existingServerGroups.get(property.getName()))) {
                        affectedServers.addAll(DomainServerUtils.getServersForGroup(property.getName(), hostModel, this.localHostInfo.getLocalHostName(), serverProxies));
                    }
                    existingServerGroups.remove(property.getName());
                    continue;
                }
                affectedServers.addAll(DomainServerUtils.getServersForGroup(property.getName(), hostModel, this.localHostInfo.getLocalHostName(), serverProxies));
            }
        }
        for (Map.Entry entry : existingServerGroups.entrySet()) {
            affectedServers.addAll(DomainServerUtils.getServersForGroup((String)entry.getKey(), hostModel, this.localHostInfo.getLocalHostName(), serverProxies));
        }
        if (!affectedServers.isEmpty()) {
            DomainControllerLogger.ROOT_LOGGER.domainModelChangedOnReConnect(affectedServers);
            Set<ServerIdentity> runningServers = DomainServerUtils.getAllRunningServers(hostModel, this.localHostInfo.getLocalHostName(), serverProxies);
            for (ServerIdentity serverIdentity : affectedServers) {
                if (!runningServers.contains(serverIdentity)) continue;
                PathAddress serverAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)serverIdentity.getHostName()), PathElement.pathElement((String)"server", (String)serverIdentity.getServerName())});
                OperationStepHandler handler = context.getResourceRegistration().getOperationHandler(serverAddress, "server-set-restart-required");
                ModelNode op = new ModelNode();
                op.get("operation").set("server-set-restart-required");
                op.get("address").set(serverAddress.toModelNode());
                context.addStep(op, handler, OperationContext.Stage.IMMEDIATE);
            }
        }
    }
}

