/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.streaming.StreamOut;
import org.apache.cassandra.streaming.StreamOutSession;
import org.apache.cassandra.streaming.StreamRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamRequestVerbHandler
implements IVerbHandler<StreamRequest> {
    private static final Logger logger = LoggerFactory.getLogger(StreamRequestVerbHandler.class);

    @Override
    public void doVerb(MessageIn<StreamRequest> message, String id) {
        if (logger.isDebugEnabled()) {
            logger.debug("Received a StreamRequestMessage from {}", (Object)message.from);
        }
        StreamRequest srm = (StreamRequest)message.payload;
        if (logger.isDebugEnabled()) {
            logger.debug(srm.toString());
        }
        StreamOutSession session = StreamOutSession.create(srm.table, message.from, srm.sessionId);
        StreamOut.transferRanges(session, srm.columnFamilies, srm.ranges, srm.type);
    }
}

