/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.exceptions;

import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.ExceptionCode;

public class AlreadyExistsException
extends ConfigurationException {
    public final String ksName;
    public final String cfName;

    private AlreadyExistsException(String ksName, String cfName, String msg) {
        super(ExceptionCode.ALREADY_EXISTS, msg);
        this.ksName = ksName;
        this.cfName = cfName;
    }

    public AlreadyExistsException(String ksName, String cfName) {
        this(ksName, cfName, String.format("Cannot add already existing column family \"%s\" to keyspace \"%s\"", cfName, ksName));
    }

    public AlreadyExistsException(String ksName) {
        this(ksName, "", String.format("Cannot add existing keyspace \"%s\"", ksName));
    }
}

