/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.cassandra.cql.jdbc.JdbcDate;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang.time.DateUtils;

public class DateType
extends AbstractType<Date> {
    public static final DateType instance = new DateType();
    static final String DEFAULT_FORMAT = JdbcDate.iso8601Patterns[3];
    static final SimpleDateFormat FORMATTER = new SimpleDateFormat(DEFAULT_FORMAT);

    DateType() {
    }

    @Override
    public Date compose(ByteBuffer bytes) {
        return JdbcDate.instance.compose(bytes);
    }

    @Override
    public ByteBuffer decompose(Date value) {
        return JdbcDate.instance.decompose(value);
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1.remaining() == 0) {
            return o2.remaining() == 0 ? 0 : -1;
        }
        if (o2.remaining() == 0) {
            return 1;
        }
        return ByteBufferUtil.compareUnsigned(o1, o2);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        try {
            return JdbcDate.instance.getString(bytes);
        }
        catch (org.apache.cassandra.cql.jdbc.MarshalException e) {
            throw new MarshalException(e.getMessage());
        }
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        return ByteBufferUtil.bytes(DateType.dateStringToTimestamp(source));
    }

    public static long dateStringToTimestamp(String source) throws MarshalException {
        long millis;
        if (source.toLowerCase().equals("now")) {
            millis = System.currentTimeMillis();
        } else {
            if (source.matches("^-?\\d+$")) {
                try {
                    millis = Long.parseLong(source);
                }
                catch (NumberFormatException e) {
                    throw new MarshalException(String.format("unable to make long (for date) from: '%s'", source), e);
                }
            }
            try {
                millis = DateUtils.parseDateStrictly((String)source, (String[])JdbcDate.iso8601Patterns).getTime();
            }
            catch (ParseException e1) {
                throw new MarshalException(String.format("unable to coerce '%s' to a  formatted date (long)", source), e1);
            }
        }
        return millis;
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 8 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("Expected 8 or 0 byte long for date (%d)", bytes.remaining()));
        }
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.TIMESTAMP;
    }
}

