/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.query;

import javax.transaction.Transaction;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.impl.BaseTransactionalDataRegion;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;

public class QueryResultsRegionImpl
extends BaseTransactionalDataRegion
implements QueryResultsRegion {
    private final AdvancedCache evictCache;
    private final AdvancedCache putCache;
    private final AdvancedCache getCache;

    public QueryResultsRegionImpl(AdvancedCache cache, String name, RegionFactory factory) {
        super(cache, name, null, factory);
        boolean localOnly = Caches.isInvalidationCache(cache);
        this.evictCache = localOnly ? Caches.localCache(cache) : cache;
        this.putCache = localOnly ? Caches.failSilentWriteCache(cache, Flag.CACHE_MODE_LOCAL) : Caches.failSilentWriteCache(cache);
        this.getCache = Caches.failSilentReadCache(cache);
    }

    public void evict(Object key) throws CacheException {
        this.evictCache.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() throws CacheException {
        Transaction tx = this.suspend();
        try {
            this.invalidateRegion();
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.resume(tx);
        }
    }

    public Object get(Object key) throws CacheException {
        boolean skipCacheStore = false;
        if (!this.isValid()) {
            skipCacheStore = true;
        }
        if (!this.checkValid()) {
            return null;
        }
        if (skipCacheStore) {
            return this.getCache.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).get(key);
        }
        return this.getCache.get(key);
    }

    public void put(Object key, Object value) throws CacheException {
        if (this.checkValid()) {
            this.putCache.put(key, value);
        }
    }
}

