/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.as.remoting.RemotingMessages;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Sequence;

public class RemoteOutboundConnectionService
extends AbstractOutboundConnectionService<RemoteOutboundConnectionService> {
    public static final ServiceName REMOTE_OUTBOUND_CONNECTION_BASE_SERVICE_NAME = RemotingServices.SUBSYSTEM_ENDPOINT.append(new String[]{"remote-outbound-connection"});
    private static final String REMOTE_URI_SCHEME = "remote://";
    private static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    private final InjectedValue<OutboundSocketBinding> destinationOutboundSocketBindingInjectedValue = new InjectedValue();
    private final InjectedValue<SecurityRealm> securityRealmInjectedValue = new InjectedValue();
    private final String username;
    private URI connectionURI;

    public RemoteOutboundConnectionService(String connectionName, OptionMap connectionCreationOptions, String username) {
        super(connectionName, connectionCreationOptions);
        this.username = username;
    }

    @Override
    public IoFuture<Connection> connect() throws IOException {
        CallbackHandlerFactory cbhFactory;
        URI uri;
        try {
            uri = this.getConnectionURI();
        }
        catch (URISyntaxException e) {
            throw RemotingMessages.MESSAGES.couldNotConnect(e);
        }
        Endpoint endpoint = (Endpoint)this.endpointInjectedValue.getValue();
        SSLContext sslContext = null;
        SecurityRealm realm = (SecurityRealm)this.securityRealmInjectedValue.getOptionalValue();
        CallbackHandler callbackHandler = realm != null && (cbhFactory = realm.getSecretCallbackHandlerFactory()) != null && this.username != null ? cbhFactory.getCallbackHandler(this.username) : this.getCallbackHandler();
        if (realm != null) {
            sslContext = realm.getSSLContext();
        }
        OptionMap.Builder builder = OptionMap.builder();
        builder.set(Options.SASL_POLICY_NOANONYMOUS, (Object)Boolean.FALSE);
        builder.set(Options.SASL_POLICY_NOPLAINTEXT, (Object)Boolean.FALSE);
        builder.set(Options.SASL_DISALLOWED_MECHANISMS, (Object)Sequence.of((Object[])new String[]{JBOSS_LOCAL_USER}));
        builder.set(Options.SSL_ENABLED, true);
        builder.set(Options.SSL_STARTTLS, true);
        builder.addAll(this.connectionCreationOptions);
        return endpoint.connect(uri, builder.getMap(), callbackHandler, sslContext);
    }

    Injector<OutboundSocketBinding> getDestinationOutboundSocketBindingInjector() {
        return this.destinationOutboundSocketBindingInjectedValue;
    }

    Injector<SecurityRealm> getSecurityRealmInjector() {
        return this.securityRealmInjectedValue;
    }

    private synchronized URI getConnectionURI() throws IOException, URISyntaxException {
        if (this.connectionURI != null) {
            return this.connectionURI;
        }
        OutboundSocketBinding destinationOutboundSocket = (OutboundSocketBinding)this.destinationOutboundSocketBindingInjectedValue.getValue();
        InetAddress destinationAddress = destinationOutboundSocket.getDestinationAddress();
        int port = destinationOutboundSocket.getDestinationPort();
        this.connectionURI = new URI(REMOTE_URI_SCHEME + NetworkUtils.formatPossibleIpv6Address((String)destinationAddress.getHostAddress()) + ":" + port);
        return this.connectionURI;
    }

    public RemoteOutboundConnectionService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

