/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.protocol.mgmt.support.ManagementChannelInitialization;
import org.jboss.as.remoting.RemotingMessages;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.SecurityActions;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.xnio.OptionMap;

public abstract class AbstractChannelOpenListenerService
implements Service<Void>,
OpenListener {
    protected static final int CHANNEL_SHUTDOWN_TIMEOUT;
    protected final Logger log = Logger.getLogger((String)"org.jboss.as.remoting");
    private final InjectedValue<Endpoint> endpointValue = new InjectedValue();
    private final InjectedValue<ManagementChannelRegistryService> registry = new InjectedValue();
    protected final String channelName;
    private final OptionMap optionMap;
    private final Set<ManagementChannelInitialization.ManagementChannelShutdownHandle> handles = Collections.synchronizedSet(new HashSet());
    private volatile boolean closed = true;

    public AbstractChannelOpenListenerService(String channelName, OptionMap optionMap) {
        this.channelName = channelName;
        this.optionMap = optionMap;
    }

    public ServiceName getServiceName(ServiceName endpointName) {
        return RemotingServices.channelServiceName(endpointName, this.channelName);
    }

    public InjectedValue<Endpoint> getEndpointInjector() {
        return this.endpointValue;
    }

    public InjectedValue<ManagementChannelRegistryService> getRegistry() {
        return this.registry;
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            this.closed = false;
            this.log.debugf("Registering channel listener for %s", (Object)this.channelName);
            Registration registration = ((Endpoint)this.endpointValue.getValue()).registerService(this.channelName, (OpenListener)this, this.optionMap);
            ((ManagementChannelRegistryService)this.registry.getValue()).register(registration);
        }
        catch (Exception e) {
            throw RemotingMessages.MESSAGES.couldNotStartChanelListener(e);
        }
    }

    public synchronized void stop(final StopContext context) {
        this.closed = true;
        final Set<ManagementChannelInitialization.ManagementChannelShutdownHandle> handlesCopy = this.copyHandles();
        for (ManagementChannelInitialization.ManagementChannelShutdownHandle handle : handlesCopy) {
            handle.shutdown();
        }
        Runnable shutdownTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long end = System.currentTimeMillis() + (long)CHANNEL_SHUTDOWN_TIMEOUT;
                boolean interrupted = Thread.currentThread().isInterrupted();
                try {
                    for (ManagementChannelInitialization.ManagementChannelShutdownHandle handle : handlesCopy) {
                        long remaining = end - System.currentTimeMillis();
                        try {
                            if (interrupted || handle.awaitCompletion(remaining, TimeUnit.MILLISECONDS)) continue;
                            ControllerLogger.ROOT_LOGGER.gracefulManagementChannelHandlerShutdownTimedOut(CHANNEL_SHUTDOWN_TIMEOUT);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                            ControllerLogger.ROOT_LOGGER.gracefulManagementChannelHandlerShutdownFailed((Throwable)e);
                        }
                        catch (Exception e) {
                            ControllerLogger.ROOT_LOGGER.gracefulManagementChannelHandlerShutdownFailed((Throwable)e);
                        }
                        finally {
                            handle.shutdownNow();
                        }
                    }
                }
                finally {
                    context.complete();
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        context.asynchronous();
        this.execute(shutdownTask);
    }

    public void channelOpened(Channel channel) {
        if (this.closed) {
            this.log.debugf("server shutting down, closing channel %s.", (Object)channel);
            channel.closeAsync();
            return;
        }
        final ManagementChannelInitialization.ManagementChannelShutdownHandle handle = this.handleChannelOpened(channel);
        this.handles.add(handle);
        channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

            public void handleClose(Channel closed, IOException exception) {
                AbstractChannelOpenListenerService.this.handles.remove(handle);
                handle.shutdownNow();
                AbstractChannelOpenListenerService.this.log.tracef("Handling close for %s", (Object)handle);
            }
        });
    }

    public void registrationTerminated() {
        Set<ManagementChannelInitialization.ManagementChannelShutdownHandle> copy = this.copyHandles();
        for (ManagementChannelInitialization.ManagementChannelShutdownHandle channel : copy) {
            channel.shutdownNow();
        }
    }

    protected abstract ManagementChannelInitialization.ManagementChannelShutdownHandle handleChannelOpened(Channel var1);

    protected abstract void execute(Runnable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ManagementChannelInitialization.ManagementChannelShutdownHandle> copyHandles() {
        Set<ManagementChannelInitialization.ManagementChannelShutdownHandle> set = this.handles;
        synchronized (set) {
            return new HashSet<ManagementChannelInitialization.ManagementChannelShutdownHandle>(this.handles);
        }
    }

    static {
        int timeout;
        String prop = null;
        try {
            prop = SecurityActions.getSystemProperty("jboss.as.management.channel.close.timeout", "15000");
            timeout = Integer.parseInt(prop);
        }
        catch (NumberFormatException e) {
            ControllerLogger.ROOT_LOGGER.invalidChannelCloseTimeout(e, "jboss.as.management.channel.close.timeout", prop);
            timeout = 15000;
        }
        CHANNEL_SHUTDOWN_TIMEOUT = timeout;
    }
}

