/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr;

import java.util.HashMap;
import java.util.Map;

public interface JAXRConstants {
    public static final String JAXR_FACTORY_IMPLEMENTATION = "javax.xml.registry.ConnectionFactory";
    public static final String QUERYMANAGER = "javax.xml.registry.queryManagerURL";
    public static final String LIFECYCLEMANAGER = "javax.xml.registry.lifeCycleManagerURL";
    public static final String SECURITYMANAGER = "javax.xml.registry.securityManagerURL";
    public static final String DEFAULT_JAXR_FACTORY_IMPL = "org.apache.ws.scout.registry.ConnectionFactoryImpl";
    public static final String DEFAULT_QUERYMANAGER = "http://localhost:8080/juddi/inquiry";
    public static final String DEFAULT_LIFECYCLEMANAGER = "http://localhost:8080/juddi/publish";
    public static final String DEFAULT_V3_QUERYMANAGER = "http://localhost:8880/juddiv3/inquiry";
    public static final String DEFAULT_V3_LIFECYCLEMANAGER = "http://localhost:8880/juddiv3/publish";
    public static final String DEFAULT_V3_SECURITYMANAGER = "http://localhost:8880/juddiv3/security";
    public static final String UDDI_VERSION_PROPERTY_NAME = "scout.proxy.uddiVersion";
    public static final String UDDI_NAMESPACE_PROPERTY_NAME = "scout.proxy.uddiNamespace";
    public static final String SCOUT_TRANSPORT = "scout.proxy.transportClass";
    public static final String UDDI_V2_VERSION = "2.0";
    public static final String UDDI_V3_VERSION = "3.0";
    public static final String UDDI_V2_NAMESPACE = "urn:uddi-org:api_v2";
    public static final String UDDI_V3_NAMESPACE = "urn:uddi-org:api_v3";
    public static final String SCOUT_SAAJ_TRANSPORT = "org.apache.ws.scout.transport.SaajTransport";
    public static final String SCOUT_JAXWS_TRANSPORT = "org.apache.juddi.v3.client.transport.JAXWSTransport";
    public static final String SCOUT_JUDDI_CLIENT_CONFIG = "scout.juddi.client.config.file";
    public static final String DEFAULT_JUDDI_CLIENT_CONFIG = "jaxr-uddi.xml";
    public static final String SUBSYSTEM_NAME = "jaxr";
    public static final String RESOURCE_NAME = "org.jboss.as.jaxr.LocalDescriptions";

    public static enum Element {
        UNKNOWN(null),
        CONNECTION_FACTORY("connection-factory"),
        PROPERTIES("properties"),
        PROPERTY("property"),
        JUDDI_SERVER("juddi-server");

        private final String name;
        private static final Map<String, Element> MAP;

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Element forName(String localName) {
            Element element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Element> map = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    public static enum Attribute {
        UNKNOWN(null),
        JNDI_NAME("jndi-name"),
        CLASS("class"),
        NAME("name"),
        VALUE("value"),
        PUBLISH_URL("publish-url"),
        QUERY_URL("query-url");

        private final String name;
        private static final Map<String, Attribute> MAP;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Attribute forName(String localName) {
            Attribute element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        public String toString() {
            return this.getLocalName();
        }

        static {
            HashMap<String, Attribute> map = new HashMap<String, Attribute>();
            for (Attribute element : Attribute.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    public static enum Namespace {
        UNKNOWN(null),
        JAXR_1_0("urn:jboss:domain:jaxr:1.0"),
        JAXR_1_1("urn:jboss:domain:jaxr:1.1");

        public static final Namespace CURRENT;
        private final String name;
        private static final Map<String, Namespace> MAP;

        private Namespace(String name) {
            this.name = name;
        }

        public String getUriString() {
            return this.name;
        }

        public static Namespace forUri(String uri) {
            Namespace element = MAP.get(uri);
            return element == null ? UNKNOWN : element;
        }

        static {
            CURRENT = JAXR_1_1;
            HashMap<String, Namespace> map = new HashMap<String, Namespace>();
            for (Namespace namespace : Namespace.values()) {
                String name = namespace.getUriString();
                if (name == null) continue;
                map.put(name, namespace);
            }
            MAP = map;
        }
    }
}

