/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bindings.script.BaseRhqSchemeScriptSourceProvider;
import org.rhq.enterprise.server.core.CoreServerMBean;
import org.rhq.enterprise.server.util.LookupUtil;

public class RhqDownloadsScriptSourceProvider
extends BaseRhqSchemeScriptSourceProvider {
    private static final Log LOG = LogFactory.getLog(RhqDownloadsScriptSourceProvider.class);
    private static final String AUTHORITY = "downloads";
    private CoreServerMBean coreServer;

    public RhqDownloadsScriptSourceProvider() {
        this(SecurityActions.lookupCoreServer());
    }

    public RhqDownloadsScriptSourceProvider(CoreServerMBean coreServerMBean) {
        super(AUTHORITY);
        this.coreServer = coreServerMBean;
    }

    protected Reader doGetScriptSource(URI scriptUri) {
        String path = scriptUri.getPath().substring(1);
        File downloadsDir = SecurityActions.getDownloadDir(this.coreServer);
        File scriptDownloads = new File(downloadsDir, "script-modules");
        File file = new File(scriptDownloads, path);
        try {
            return new InputStreamReader(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            LOG.debug((Object)("Failed to locate the download file: " + scriptUri), (Throwable)e);
            return null;
        }
    }

    private static class SecurityActions {
        private SecurityActions() {
        }

        private static CoreServerMBean lookupCoreServer() {
            if (System.getSecurityManager() == null) {
                return LookupUtil.getCoreServer();
            }
            return AccessController.doPrivileged(new PrivilegedAction<CoreServerMBean>(){

                @Override
                public CoreServerMBean run() {
                    return LookupUtil.getCoreServer();
                }
            });
        }

        private static File getDownloadDir(final CoreServerMBean coreServer) {
            File earDeployDir = System.getSecurityManager() == null ? coreServer.getEarDeploymentDir() : AccessController.doPrivileged(new PrivilegedAction<File>(){

                @Override
                public File run() {
                    return coreServer.getEarDeploymentDir();
                }
            });
            File downloadDir = new File(earDeployDir, "rhq-downloads");
            return downloadDir;
        }
    }
}

