/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.lock.ThreadLocalMap;
import org.jboss.cache.lock.UpgradeException;

public class ReadWriteLockWithUpgrade
implements ReadWriteLock {
    private long activeReaders_ = 0L;
    protected Thread activeWriter_ = null;
    private long waitingReaders_ = 0L;
    private long waitingWriters_ = 0L;
    private long waitingUpgrader_ = 0L;
    protected static final Map upgraderLocal_ = new ThreadLocalMap();
    protected static final Object dummy_ = new Object();
    protected final ReaderLock readerLock_ = new ReaderLock();
    protected final WriterLock writerLock_ = new WriterLock();
    protected static final Log log_ = LogFactory.getLog((Class)ReadWriteLockWithUpgrade.class);

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("activeReaders=").append(this.activeReaders_).append(", activeWriter=").append(this.activeWriter_);
        sb.append(", waitingReaders=").append(this.waitingReaders_).append(", waitingWriters=").append(this.waitingWriters_);
        sb.append(", waitingUpgrader=").append(this.waitingUpgrader_);
        return sb.toString();
    }

    public Sync writeLock() {
        return this.writerLock_;
    }

    public Sync readLock() {
        return this.readerLock_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sync upgradeLockAttempt(long msecs) throws UpgradeException {
        if (this.activeReaders_ == 0L) {
            throw new RuntimeException("No reader lock available for upgrade");
        }
        WriterLock writerLock = this.writerLock_;
        synchronized (writerLock) {
            if (this.waitingUpgrader_ >= 1L) {
                String errStr = "upgradeLockAttempt(): more than one reader trying to simultaneously upgrade to write lock";
                log_.error((Object)errStr);
                throw new UpgradeException(errStr);
            }
            ++this.waitingUpgrader_;
            upgraderLocal_.put(this, dummy_);
        }
        if (this.activeReaders_ == 1L) {
            this.resetWaitingUpgrader();
            return this.changeLock();
        }
        this.readerLock_.release();
        try {
            if (!this.writerLock_.attempt(msecs)) {
                log_.error((Object)"upgradeLock(): failed");
                this.resetWaitingUpgrader();
                if (!this.readerLock_.attempt(msecs)) {
                    String errStr = "ReadWriteLockWithUpgrade.upgradeLockAttempt(): failed to upgrade to write lock and also failed to re-obtain the read lock";
                    log_.error((Object)errStr);
                    throw new IllegalStateException(errStr);
                }
                return null;
            }
            this.resetWaitingUpgrader();
        }
        catch (InterruptedException ex) {
            this.resetWaitingUpgrader();
            return null;
        }
        return this.writerLock_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetWaitingUpgrader() {
        WriterLock writerLock = this.writerLock_;
        synchronized (writerLock) {
            --this.waitingUpgrader_;
            upgraderLocal_.remove(this);
        }
    }

    protected synchronized Sync changeLock() {
        --this.activeReaders_;
        if (!this.startWrite()) {
            return null;
        }
        return this.writerLock_;
    }

    protected synchronized void cancelledWaitingReader() {
        --this.waitingReaders_;
    }

    protected synchronized void cancelledWaitingWriter() {
        --this.waitingWriters_;
    }

    protected boolean allowReader() {
        return this.activeWriter_ == null && this.waitingWriters_ == 0L && this.waitingUpgrader_ == 0L;
    }

    protected synchronized boolean startRead() {
        boolean allowRead = this.allowReader();
        if (allowRead) {
            ++this.activeReaders_;
        }
        return allowRead;
    }

    protected synchronized boolean startWrite() {
        boolean allowWrite;
        boolean bl = allowWrite = this.activeWriter_ == null && this.activeReaders_ == 0L;
        if (allowWrite) {
            this.activeWriter_ = Thread.currentThread();
        }
        return allowWrite;
    }

    protected synchronized boolean startReadFromNewReader() {
        boolean pass = this.startRead();
        if (!pass) {
            ++this.waitingReaders_;
        }
        return pass;
    }

    protected synchronized boolean startWriteFromNewWriter() {
        boolean pass = this.startWrite();
        if (!pass) {
            ++this.waitingWriters_;
        }
        return pass;
    }

    protected synchronized boolean startReadFromWaitingReader() {
        boolean pass = this.startRead();
        if (pass) {
            --this.waitingReaders_;
        }
        return pass;
    }

    protected synchronized boolean startWriteFromWaitingWriter() {
        boolean pass = this.startWrite();
        if (pass) {
            --this.waitingWriters_;
        }
        return pass;
    }

    protected synchronized Signaller endRead() {
        if (this.activeReaders_ != 0L && --this.activeReaders_ == 0L && this.waitingWriters_ > 0L) {
            return this.writerLock_;
        }
        return null;
    }

    protected synchronized Signaller endWrite() {
        this.activeWriter_ = null;
        if (this.waitingReaders_ > 0L && this.allowReader()) {
            return this.readerLock_;
        }
        if (this.waitingWriters_ > 0L) {
            return this.writerLock_;
        }
        return null;
    }

    protected class WriterLock
    implements Signaller,
    Sync {
        protected WriterLock() {
        }

        public void acquire() throws InterruptedException {
            throw new RuntimeException("acquire(): Operation currently not supported.");
        }

        public void release() {
            Signaller s = ReadWriteLockWithUpgrade.this.endWrite();
            if (s != null) {
                s.signalWaiters();
            }
        }

        public synchronized void signalWaiters() {
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean attempt(long msecs) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            WriterLock writerLock = this;
            synchronized (writerLock) {
                block16: {
                    if (msecs <= 0L) {
                        if (ReadWriteLockWithUpgrade.this.waitingUpgrader_ != 0L) {
                            if (upgraderLocal_.get(ReadWriteLockWithUpgrade.this) != null) {
                                log_.info((Object)"attempt(): upgrade to write lock");
                                return ReadWriteLockWithUpgrade.this.startWrite();
                            }
                            return false;
                        }
                        return ReadWriteLockWithUpgrade.this.startWrite();
                    }
                    if (ReadWriteLockWithUpgrade.this.startWriteFromNewWriter()) {
                        return true;
                    }
                    long waitTime = msecs;
                    long start = System.currentTimeMillis();
                    while (true) {
                        try {
                            this.wait(waitTime);
                        }
                        catch (InterruptedException ex) {
                            ReadWriteLockWithUpgrade.this.cancelledWaitingWriter();
                            this.notifyAll();
                            ie = ex;
                            break block16;
                        }
                        if (ReadWriteLockWithUpgrade.this.waitingUpgrader_ != 0L) {
                            if (upgraderLocal_.get(ReadWriteLockWithUpgrade.this) == null) continue;
                            if (ReadWriteLockWithUpgrade.this.startWriteFromWaitingWriter()) {
                                return true;
                            }
                        } else if (ReadWriteLockWithUpgrade.this.startWriteFromWaitingWriter()) {
                            return true;
                        }
                        if ((waitTime = msecs - (System.currentTimeMillis() - start)) <= 0L) break;
                    }
                    ReadWriteLockWithUpgrade.this.cancelledWaitingWriter();
                    this.notifyAll();
                }
            }
            ReadWriteLockWithUpgrade.this.readerLock_.signalWaiters();
            if (ie != null) {
                throw ie;
            }
            return false;
        }
    }

    protected class ReaderLock
    implements Signaller,
    Sync {
        protected ReaderLock() {
        }

        public void acquire() throws InterruptedException {
            throw new RuntimeException("acquire(): Operation currently not supported.");
        }

        public void release() {
            Signaller s = ReadWriteLockWithUpgrade.this.endRead();
            if (s != null) {
                s.signalWaiters();
            }
        }

        public synchronized void signalWaiters() {
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean attempt(long msecs) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            ReaderLock readerLock = this;
            synchronized (readerLock) {
                block10: {
                    if (msecs <= 0L) {
                        return ReadWriteLockWithUpgrade.this.startRead();
                    }
                    if (ReadWriteLockWithUpgrade.this.startReadFromNewReader()) {
                        return true;
                    }
                    long waitTime = msecs;
                    long start = System.currentTimeMillis();
                    do {
                        try {
                            this.wait(waitTime);
                        }
                        catch (InterruptedException ex) {
                            ReadWriteLockWithUpgrade.this.cancelledWaitingReader();
                            ie = ex;
                            break block10;
                        }
                        if (!ReadWriteLockWithUpgrade.this.startReadFromWaitingReader()) continue;
                        return true;
                    } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                    ReadWriteLockWithUpgrade.this.cancelledWaitingReader();
                }
            }
            ReadWriteLockWithUpgrade.this.writerLock_.signalWaiters();
            if (ie != null) {
                throw ie;
            }
            return false;
        }
    }

    static interface Signaller {
        public void signalWaiters();
    }
}

