/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.util;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.xb.binding.JBossXBRuntimeException;

public abstract class CollectionFactory {
    private static TypeInfo SET_INFO;
    public static CollectionFactory LIST;
    public static CollectionFactory SET;

    public abstract Collection<Object> createCollection() throws Throwable;

    public static CollectionFactory getFactory(ClassInfo collectionType) {
        if (Modifier.isAbstract(collectionType.getModifiers())) {
            if (SET_INFO == null) {
                SET_INFO = collectionType.getTypeInfoFactory().getTypeInfo(Set.class);
            }
            if (SET_INFO.isAssignableFrom((TypeInfo)collectionType)) {
                return SET;
            }
            return LIST;
        }
        ConstructorInfo constructor = collectionType.getDeclaredConstructor(null);
        if (constructor == null) {
            for (ConstructorInfo ctor : collectionType.getDeclaredConstructors()) {
                if (ctor.getParameterTypes().length != 0) continue;
                constructor = ctor;
                break;
            }
            if (constructor == null) {
                throw new JBossXBRuntimeException("Default constructor not found for " + collectionType.getName());
            }
        }
        final ConstructorInfo ctor = constructor;
        return new CollectionFactory(){

            @Override
            public Collection<Object> createCollection() throws Throwable {
                return (Collection)ctor.newInstance(null);
            }
        };
    }

    static {
        LIST = new CollectionFactory(){

            @Override
            public Collection<Object> createCollection() throws Throwable {
                return new ArrayList<Object>();
            }
        };
        SET = new CollectionFactory(){

            @Override
            public Collection<Object> createCollection() throws Throwable {
                return new HashSet<Object>();
            }
        };
    }
}

