/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.xb.binding.sunday.unmarshalling.AnyAttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AnyAttributeHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
import org.jboss.xb.builder.runtime.BuilderUtil;
import org.jboss.xb.spi.BeanAdapter;

public class AnyAttributePropertyHandler
extends AnyAttributeHandler {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected boolean trace = this.log.isTraceEnabled();
    private PropertyInfo propertyInfo;
    private TypeInfo propertyType;

    public AnyAttributePropertyHandler(PropertyInfo propertyInfo, TypeInfo propertyType) {
        if (propertyInfo == null) {
            throw new IllegalArgumentException("Null propertyInfo");
        }
        if (propertyType == null) {
            throw new IllegalArgumentException("Null propertyType");
        }
        if (!propertyType.isMap()) {
            throw new IllegalStateException("Current implementation expects property bound to anyAttribute to be of type Map<QName, Object>. Property name is " + propertyInfo.getName() + ", property type is " + propertyType.getName());
        }
        this.propertyInfo = propertyInfo;
    }

    public PropertyInfo getPropertyInfo() {
        return this.propertyInfo;
    }

    public void doHandle(Object parent, Object child, QName qName) {
        if (this.trace) {
            this.log.trace((Object)("QName " + qName + " handle " + BuilderUtil.toDebugString(child) + " to " + BuilderUtil.toDebugString(parent) + " property=" + this.propertyInfo.getName()));
        }
        try {
            this.handle(this.propertyInfo, this.propertyType, parent, child, qName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("QName " + qName + "error setting property " + this.propertyInfo.getName() + " with value " + BuilderUtil.toDebugString(child) + " to " + BuilderUtil.toDebugString(parent));
        }
    }

    @Override
    public void attribute(QName elemName, QName attrName, AnyAttributeBinding binding, Object owner, Object value) {
        ValueAdapter valueAdapter = binding.getValueAdapter();
        if (valueAdapter != null) {
            value = valueAdapter.cast(value, null);
        }
        BeanAdapter parent = (BeanAdapter)owner;
        this.doHandle(parent, value, attrName);
    }

    public void handle(PropertyInfo propertyInfo, TypeInfo propertyType, Object parent, Object child, QName name) {
        BeanAdapter beanAdapter = (BeanAdapter)parent;
        HashMap<QName, Object> map = null;
        try {
            if (propertyInfo.getGetter() != null) {
                map = (HashMap<QName, Object>)beanAdapter.get(propertyInfo);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Error getting map for property " + propertyInfo.getName() + " bound to any attribute from " + BuilderUtil.toDebugString(parent), t);
        }
        if (map == null) {
            map = new HashMap<QName, Object>();
            try {
                beanAdapter.set(propertyInfo, map);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error setting map property " + propertyInfo.getName() + " bound to any attribute for " + BuilderUtil.toDebugString(parent) + " with value " + BuilderUtil.toDebugString(map), t);
            }
        }
        map.put(name, child);
    }
}

