/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.sunday.unmarshalling.AnyAttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AnyAttributeHandler;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeHandler;
import org.jboss.xb.binding.sunday.unmarshalling.AttributesHandler;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.xml.sax.Attributes;

public class RegisteredAttributesHandler
extends AttributesHandler {
    private Map<QName, AttributeBinding> registered;
    private AnyAttributeBinding any;
    private Map<QName, AttributeBinding> defaultAttrs;

    @Override
    public void attributes(Object o, QName elementName, TypeBinding type, Attributes attrs, NamespaceContext nsCtx) {
        if (this.registered == null) {
            return;
        }
        HashMap<QName, AttributeBinding> notSetDefaultAttrs = null;
        if (this.defaultAttrs != null) {
            notSetDefaultAttrs = new HashMap<QName, AttributeBinding>(this.defaultAttrs);
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            Object value;
            Object handler;
            QName qName = new QName(attrs.getURI(i), attrs.getLocalName(i));
            AttributeBinding binding = this.registered.get(qName);
            if (binding != null) {
                handler = binding.getHandler();
                value = ((AttributeHandler)handler).unmarshal(elementName, qName, binding, nsCtx, attrs.getValue(i));
                ((AttributeHandler)handler).attribute(elementName, qName, binding, o, value);
                if (notSetDefaultAttrs == null || binding.getDefaultConstraint() == null) continue;
                notSetDefaultAttrs.remove(qName);
                continue;
            }
            if (this.any == null) continue;
            handler = this.any.getHandler();
            value = ((AnyAttributeHandler)handler).unmarshal(elementName, qName, this.any, nsCtx, attrs.getValue(i));
            ((AnyAttributeHandler)handler).attribute(elementName, qName, this.any, o, value);
        }
        if (notSetDefaultAttrs != null && !notSetDefaultAttrs.isEmpty()) {
            for (AttributeBinding binding : notSetDefaultAttrs.values()) {
                AttributeHandler handler = binding.getHandler();
                Object value = handler.unmarshal(elementName, binding.getQName(), binding, nsCtx, binding.getDefaultConstraint());
                handler.attribute(elementName, binding.getQName(), binding, o, value);
            }
        }
    }

    public void addAttribute(AttributeBinding attr) {
        if (this.registered == null) {
            this.registered = Collections.singletonMap(attr.getQName(), attr);
        } else {
            if (this.registered.size() == 1) {
                this.registered = new HashMap<QName, AttributeBinding>(this.registered);
            }
            this.registered.put(attr.getQName(), attr);
        }
        if (attr.getDefaultConstraint() != null) {
            if (this.defaultAttrs == null) {
                this.defaultAttrs = Collections.singletonMap(attr.getQName(), attr);
            } else {
                if (this.defaultAttrs.size() == 1) {
                    this.defaultAttrs = new HashMap<QName, AttributeBinding>(this.defaultAttrs);
                }
                this.defaultAttrs.put(attr.getQName(), attr);
            }
        }
    }

    public void setAnyAttribute(AnyAttributeBinding any) {
        this.any = any;
    }
}

