/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.lang.reflect.Array;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;

public abstract class CharactersHandler {
    public static CharactersHandler NOOP = new CharactersHandler(){

        @Override
        public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
            return value;
        }
    };
    public static CharactersHandler DEFAULT = new CharactersHandler(){};
    protected UnmarshalCharactersHandler unmarshalHandler = DEFAULT_UNMARSHAL_HANDLER;
    public static final UnmarshalCharactersHandler NOOP_UNMARSHAL_HANDLER = new UnmarshalCharactersHandler(){

        @Override
        public Object unmarshal(QName name, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
            return value;
        }
    };
    public static final UnmarshalCharactersHandler DEFAULT_UNMARSHAL_HANDLER = new DefaultUnmarshalCharactersHandler();

    public CharactersHandler() {
    }

    public CharactersHandler(UnmarshalCharactersHandler unmarshalHandler) {
        this.unmarshalHandler = unmarshalHandler;
    }

    public Object unmarshalEmpty(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData) {
        if (typeBinding.isIgnoreEmptyString()) {
            return null;
        }
        Object result = "";
        QName typeQName = typeBinding.getQName();
        if (Constants.QNAME_BASE64BINARY.equals(typeQName)) {
            result = new byte[0];
        } else if (Constants.QNAME_BOOLEAN.equals(typeQName)) {
            result = null;
        }
        return result;
    }

    public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
        return this.unmarshalHandler.unmarshal(qName, typeBinding, nsCtx, valueMetaData, value);
    }

    public void setValue(QName qName, ElementBinding element, Object owner, Object value) {
    }

    public static class DefaultUnmarshalCharactersHandler
    implements UnmarshalCharactersHandler {
        @Override
        public Object unmarshal(QName name, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
            Object[] o;
            QName typeQName = typeBinding.getQName();
            TypeBinding itemType = typeBinding.getItemType();
            if (itemType != null) {
                QName itemTypeQName = itemType.getQName();
                ValueAdapter adapter = itemType.getValueAdapter();
                if (itemTypeQName == null || !"http://www.w3.org/2001/XMLSchema".equals(itemTypeQName.getNamespaceURI())) {
                    if (adapter == null) {
                        throw new JBossXBRuntimeException("Only list types with item type from http://www.w3.org/2001/XMLSchema namespace are supported currently.");
                    }
                    itemTypeQName = Constants.QNAME_STRING;
                }
                if (adapter == null) {
                    adapter = ValueAdapter.NOOP;
                }
                List<Object> list = SimpleTypeBindings.unmarshalList(itemTypeQName.getLocalPart(), value, nsCtx, adapter);
                if (typeBinding.getSchemaBinding().isUnmarshalListsToArrays()) {
                    if (list.isEmpty()) {
                        Class<?> compType = SimpleTypeBindings.classForType(itemTypeQName.getLocalPart(), true);
                        o = Array.newInstance(compType, 0);
                    } else {
                        Class<?> compType = list.get(0).getClass();
                        o = list.toArray((Object[])Array.newInstance(compType, list.size()));
                    }
                } else {
                    o = list;
                }
            } else if (typeQName != null && "http://www.w3.org/2001/XMLSchema".equals(typeQName.getNamespaceURI())) {
                try {
                    o = SimpleTypeBindings.unmarshal(typeQName.getLocalPart(), value, nsCtx);
                }
                catch (IllegalStateException e) {
                    throw new JBossXBRuntimeException("Characters are not allowed here", e);
                }
            } else {
                TypeBinding baseType = typeBinding.getBaseType();
                o = baseType == null ? value : this.unmarshal(name, baseType, nsCtx, valueMetaData, value);
            }
            return o;
        }
    }

    public static interface UnmarshalCharactersHandler {
        public Object unmarshal(QName var1, TypeBinding var2, NamespaceContext var3, ValueMetaData var4, String var5);
    }
}

